/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.iocanary.detect;

import com.tencent.matrix.util.MatrixLog;

public final class MatrixCloseGuard {
    private static final String TAG = "Matrix.CloseGuard";
    private static final MatrixCloseGuard NOOP = new MatrixCloseGuard();
    private static volatile boolean sENABLED = true;
    private static volatile Reporter sREPORTER = new DefaultReporter();
    private Throwable allocationSite;

    public static MatrixCloseGuard get() {
        if (!sENABLED) {
            return NOOP;
        }
        return new MatrixCloseGuard();
    }

    public static void setEnabled(boolean enabled) {
        sENABLED = enabled;
    }

    public static void setReporter(Reporter reporter) {
        if (reporter == null) {
            throw new NullPointerException("reporter == null");
        }
        sREPORTER = reporter;
    }

    public static Reporter getReporter() {
        return sREPORTER;
    }

    private MatrixCloseGuard() {
    }

    public void open(String closer) {
        if (closer == null) {
            throw new NullPointerException("closer == null");
        }
        if (this == NOOP || !sENABLED) {
            return;
        }
        String message = "Explicit termination method '" + closer + "' not called";
        this.allocationSite = new Throwable(message);
    }

    public void close() {
        this.allocationSite = null;
    }

    public void warnIfOpen() {
        if (this.allocationSite == null || !sENABLED) {
            return;
        }
        String message = "A resource was acquired at attached stack trace but never released. See java.io.Closeable for information on avoiding resource leaks.";
        sREPORTER.report(message, this.allocationSite);
    }

    private static final class DefaultReporter
    implements Reporter {
        private DefaultReporter() {
        }

        @Override
        public void report(String message, Throwable allocationSite) {
            MatrixLog.e((String)MatrixCloseGuard.TAG, (String)message, (Object[])new Object[]{allocationSite});
        }
    }

    public static interface Reporter {
        public void report(String var1, Throwable var2);
    }
}

