/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.iocanary.util;

import android.content.Context;
import com.tencent.matrix.iocanary.core.IOIssue;
import com.tencent.matrix.report.Issue;
import java.util.ArrayList;
import java.util.ListIterator;
import org.json.JSONException;
import org.json.JSONObject;

public final class IOCanaryUtil {
    private static final int DEFAULT_MAX_STACK_LAYER = 10;
    private static String sPackageName = null;

    public static void setPackageName(Context context) {
        if (sPackageName == null) {
            sPackageName = context.getPackageName();
        }
    }

    public static String stackTraceToString(StackTraceElement[] arr) {
        if (arr == null) {
            return "";
        }
        ArrayList<StackTraceElement> stacks = new ArrayList<StackTraceElement>(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            String className = arr[i].getClassName();
            if (className.contains("libcore.io") || className.contains("com.tencent.matrix.iocanary") || className.contains("java.io") || className.contains("dalvik.system") || className.contains("android.os")) continue;
            stacks.add(arr[i]);
        }
        if (stacks.size() > 10 && sPackageName != null) {
            ListIterator iterator = stacks.listIterator(stacks.size());
            while (iterator.hasPrevious()) {
                StackTraceElement stack = (StackTraceElement)iterator.previous();
                String className = stack.getClassName();
                if (!className.contains(sPackageName)) {
                    iterator.remove();
                }
                if (stacks.size() > 10) continue;
                break;
            }
        }
        StringBuffer sb = new StringBuffer(stacks.size());
        for (StackTraceElement stackTraceElement : stacks) {
            sb.append(stackTraceElement).append('\n');
        }
        return sb.toString();
    }

    public static String getThrowableStack(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        return IOCanaryUtil.stackTraceToString(throwable.getStackTrace());
    }

    public static Issue convertIOIssueToReportIssue(IOIssue ioIssue) {
        if (ioIssue == null) {
            return null;
        }
        Issue issue = new Issue(ioIssue.type);
        JSONObject content = new JSONObject();
        try {
            content.put("path", (Object)ioIssue.path);
            content.put("size", ioIssue.fileSize);
            content.put("op", ioIssue.opCnt);
            content.put("buffer", ioIssue.bufferSize);
            content.put("cost", ioIssue.opCostTime);
            content.put("opType", ioIssue.opType);
            content.put("opSize", ioIssue.opSize);
            content.put("thread", (Object)ioIssue.threadName);
            content.put("stack", (Object)ioIssue.stack);
            content.put("repeat", ioIssue.repeatReadCnt);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        issue.setContent(content);
        return issue;
    }
}

