/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.mallctl;

import androidx.annotation.Keep;
import com.tencent.matrix.util.MatrixLog;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MallCtl {
    private static final String TAG = "Matrix.JeCtl";
    private static boolean initialized = false;
    public static final int MALLOPT_FAILED = 0;
    public static final int MALLOPT_SUCCESS = 1;
    public static final int MALLOPT_SYM_NOT_FOUND = -1;
    public static final int MALLOPT_EXCEPTION = -2;

    public static synchronized String jeVersion() {
        if (!initialized) {
            MatrixLog.e((String)TAG, (String)"JeCtl init failed! check if so exists", (Object[])new Object[0]);
            return "VER_UNKNOWN";
        }
        return MallCtl.getVersionNative();
    }

    public static synchronized boolean jeSetRetain(boolean enable) {
        try {
            return MallCtl.setRetainNative(enable);
        }
        catch (Throwable e) {
            MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"set retain failed", (Object[])new Object[0]);
            return false;
        }
    }

    public static synchronized int mallopt() {
        try {
            return MallCtl.malloptNative();
        }
        catch (Throwable e) {
            MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"mallopt failed", (Object[])new Object[0]);
            return -2;
        }
    }

    public static synchronized void flushReadOnlyFilePages(TrimPrediction prediction) {
        if (prediction == null) {
            prediction = new DefaultPrediction();
        }
        Pattern pattern = Pattern.compile("^([0-9a-f]+)-([0-9a-f]+)\\s+([rwxps-]{4})\\s+[0-9a-f]+\\s+[0-9a-f]+:[0-9a-f]+\\s+\\d+\\s*(.*)$");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/self/maps")));){
            String line = br.readLine();
            while (line != null) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.find()) {
                    String beginStr = matcher.group(1);
                    String endStr = matcher.group(2);
                    String permission = matcher.group(3);
                    String name = matcher.group(4);
                    if (name == null || name.isEmpty()) {
                        name = "[no-name]";
                    }
                    if (prediction.canBeTrim(name, permission) && beginStr != null && endStr != null) {
                        try {
                            long beginPtr = Long.parseLong(beginStr, 16);
                            long endPtr = Long.parseLong(endStr, 16);
                            long size = endPtr - beginPtr;
                            MallCtl.flushReadOnlyFilePagesNative(beginPtr, size);
                        }
                        catch (Throwable e) {
                            MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"%s-%s %s %s", (Object[])new Object[]{beginStr, endStr, permission, name});
                        }
                    }
                }
                line = br.readLine();
            }
        }
        catch (IOException e) {
            MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
        }
    }

    @Keep
    private static native void initNative();

    @Keep
    private static native String getVersionNative();

    @Keep
    private static native int malloptNative();

    @Keep
    private static native boolean setRetainNative(boolean var0);

    private static native int flushReadOnlyFilePagesNative(long var0, long var2);

    static {
        try {
            System.loadLibrary("matrix-mallctl");
            MallCtl.initNative();
            initialized = true;
        }
        catch (Throwable e) {
            MatrixLog.printErrStackTrace((String)TAG, (Throwable)e, (String)"", (Object[])new Object[0]);
        }
    }

    public static class DefaultPrediction
    implements TrimPrediction {
        @Override
        public boolean canBeTrim(String pathName, String permission) {
            if (pathName.endsWith(" (deleted)")) {
                pathName = pathName.substring(0, pathName.length() - " (deleted)".length());
            } else if (pathName.endsWith("]")) {
                pathName = pathName.substring(0, pathName.length() - "]".length());
            }
            return !permission.contains("w") && (pathName.endsWith(".so") || pathName.endsWith(".dex") || pathName.endsWith(".apk") || pathName.endsWith(".vdex") || pathName.endsWith(".odex") || pathName.endsWith(".oat") || pathName.endsWith(".art") || pathName.endsWith(".ttf") || pathName.endsWith(".otf") || pathName.endsWith(".jar"));
        }
    }

    public static interface TrimPrediction {
        public boolean canBeTrim(String var1, String var2);
    }
}

