/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.resource.analyzer;

import com.squareup.haha.perflib.ClassInstance;
import com.squareup.haha.perflib.ClassObj;
import com.squareup.haha.perflib.HahaHelper;
import com.squareup.haha.perflib.Instance;
import com.squareup.haha.perflib.Snapshot;
import com.tencent.matrix.resource.analyzer.HeapSnapshotAnalyzer;
import com.tencent.matrix.resource.analyzer.model.ActivityLeakResult;
import com.tencent.matrix.resource.analyzer.model.ExcludedRefs;
import com.tencent.matrix.resource.analyzer.model.HeapSnapshot;
import com.tencent.matrix.resource.analyzer.model.ReferenceChain;
import com.tencent.matrix.resource.analyzer.utils.AnalyzeUtil;
import com.tencent.matrix.resource.analyzer.utils.ShortestPathFinder;
import java.util.ArrayList;
import java.util.List;

public class ActivityLeakAnalyzer
implements HeapSnapshotAnalyzer<ActivityLeakResult> {
    private static final String DESTROYED_ACTIVITY_INFO_CLASSNAME = "com.tencent.matrix.resource.analyzer.model.DestroyedActivityInfo";
    private static final String ACTIVITY_REFERENCE_KEY_FIELDNAME = "mKey";
    private static final String ACTIVITY_REFERENCE_FIELDNAME = "mActivityRef";
    private final String mRefKey;
    private final ExcludedRefs mExcludedRefs;

    public ActivityLeakAnalyzer(String refKey, ExcludedRefs excludedRefs) {
        this.mRefKey = refKey;
        this.mExcludedRefs = excludedRefs;
    }

    @Override
    public ActivityLeakResult analyze(HeapSnapshot heapSnapshot) {
        return this.checkForLeak(heapSnapshot, this.mRefKey);
    }

    private ActivityLeakResult checkForLeak(HeapSnapshot heapSnapshot, String refKey) {
        long analysisStartNanoTime = System.nanoTime();
        try {
            Snapshot snapshot = heapSnapshot.getSnapshot();
            Instance leakingRef = this.findLeakingReference(refKey, snapshot);
            if (leakingRef == null) {
                return ActivityLeakResult.noLeak(AnalyzeUtil.since(analysisStartNanoTime));
            }
            return this.findLeakTrace(analysisStartNanoTime, snapshot, leakingRef);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return ActivityLeakResult.failure(e, AnalyzeUtil.since(analysisStartNanoTime));
        }
    }

    private Instance findLeakingReference(String key, Snapshot snapshot) {
        ClassObj infoClass = snapshot.findClass(DESTROYED_ACTIVITY_INFO_CLASSNAME);
        if (infoClass == null) {
            throw new IllegalStateException("Unabled to find destroy activity info class with name: com.tencent.matrix.resource.analyzer.model.DestroyedActivityInfo");
        }
        ArrayList<String> keysFound = new ArrayList<String>();
        for (Instance infoInstance : infoClass.getInstancesList()) {
            List<ClassInstance.FieldValue> values = HahaHelper.classInstanceValues(infoInstance);
            String keyCandidate = HahaHelper.asString(HahaHelper.fieldValue(values, ACTIVITY_REFERENCE_KEY_FIELDNAME));
            if (keyCandidate.equals(key)) {
                Instance weakRefObj = (Instance)HahaHelper.fieldValue(values, ACTIVITY_REFERENCE_FIELDNAME);
                if (weakRefObj == null) continue;
                List<ClassInstance.FieldValue> activityRefs = HahaHelper.classInstanceValues(weakRefObj);
                return (Instance)HahaHelper.fieldValue(activityRefs, "referent");
            }
            keysFound.add(keyCandidate);
        }
        throw new IllegalStateException("Could not find weak reference with key " + key + " in " + keysFound);
    }

    private ActivityLeakResult findLeakTrace(long analysisStartNanoTime, Snapshot snapshot, Instance leakingRef) {
        ShortestPathFinder pathFinder = new ShortestPathFinder(this.mExcludedRefs);
        ShortestPathFinder.Result result = pathFinder.findPath(snapshot, leakingRef);
        if (result.referenceChainHead == null) {
            return ActivityLeakResult.noLeak(AnalyzeUtil.since(analysisStartNanoTime));
        }
        ReferenceChain referenceChain = result.buildReferenceChain();
        String className = leakingRef.getClassObj().getClassName();
        if (result.excludingKnown || referenceChain.isEmpty()) {
            return ActivityLeakResult.noLeak(AnalyzeUtil.since(analysisStartNanoTime));
        }
        return ActivityLeakResult.leakDetected(false, className, referenceChain, AnalyzeUtil.since(analysisStartNanoTime));
    }
}

