/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.resource.analyzer.model;

import com.tencent.matrix.resource.analyzer.model.AnalyzeResult;
import com.tencent.matrix.resource.analyzer.model.ReferenceChain;
import com.tencent.matrix.resource.analyzer.model.ReferenceTraceElement;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public final class ActivityLeakResult
extends AnalyzeResult {
    public final boolean mLeakFound;
    public final boolean mExcludedLeak;
    public final String mClassName;
    public final ReferenceChain referenceChain;
    public final Throwable mFailure;
    public final long mAnalysisDurationMs;

    public static ActivityLeakResult noLeak(long analysisDurationMs) {
        return new ActivityLeakResult(false, false, null, null, null, analysisDurationMs);
    }

    public static ActivityLeakResult leakDetected(boolean excludedLeak, String className, ReferenceChain referenceChain, long analysisDurationMs) {
        return new ActivityLeakResult(true, excludedLeak, className, referenceChain, null, analysisDurationMs);
    }

    public static ActivityLeakResult failure(Throwable failure, long analysisDurationMs) {
        return new ActivityLeakResult(false, false, null, null, failure, analysisDurationMs);
    }

    private ActivityLeakResult(boolean mLeakFound, boolean mExcludedLeak, String mClassName, ReferenceChain referenceChain, Throwable mFailure, long mAnalysisDurationMs) {
        this.mLeakFound = mLeakFound;
        this.mExcludedLeak = mExcludedLeak;
        this.mClassName = mClassName;
        this.referenceChain = referenceChain;
        this.mFailure = mFailure;
        this.mAnalysisDurationMs = mAnalysisDurationMs;
    }

    @Override
    public void encodeToJSON(JSONObject jsonObject) throws JSONException {
        JSONArray leakTraceJSONArray = new JSONArray();
        if (this.referenceChain != null) {
            for (ReferenceTraceElement element : this.referenceChain.elements) {
                leakTraceJSONArray.put((Object)element.toString());
            }
        }
        jsonObject.put("leakFound", this.mLeakFound).put("excludedLeak", this.mExcludedLeak).put("className", (Object)this.mClassName).put("failure", (Object)String.valueOf(this.mFailure)).put("analysisDurationMs", this.mAnalysisDurationMs).put("referenceChain", (Object)leakTraceJSONArray);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Leak Reference:");
        if (this.referenceChain != null) {
            for (ReferenceTraceElement element : this.referenceChain.elements) {
                sb.append(element.toCollectableString()).append(";");
            }
        }
        return sb.toString();
    }
}

