/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.resource.analyzer.model;

import com.tencent.matrix.resource.analyzer.model.ExcludedRefs;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public final class ExcludedBmps
extends ExcludedRefs {
    public final Set<PatternInfo> mClassNamePatterns;

    ExcludedBmps(BuilderWithParams builder) {
        super(builder);
        this.mClassNamePatterns = Collections.unmodifiableSet(builder.mClassNamePatterns);
    }

    public static Builder builder() {
        return new BuilderWithParams();
    }

    static final class BuilderWithParams
    extends ExcludedRefs.BuilderWithParams
    implements Builder {
        final Set<PatternInfo> mClassNamePatterns = new HashSet<PatternInfo>();

        BuilderWithParams() {
        }

        @Override
        public Builder addClassNamePattern(String regex, boolean forGCRootOnly) {
            if (regex == null || regex.length() == 0) {
                throw new IllegalArgumentException("bad regex: " + regex);
            }
            this.mClassNamePatterns.add(new PatternInfo(Pattern.compile(regex), forGCRootOnly));
            return this;
        }

        @Override
        public ExcludedBmps build() {
            return new ExcludedBmps(this);
        }
    }

    public static interface Builder
    extends ExcludedRefs.Builder {
        public Builder addClassNamePattern(String var1, boolean var2);

        @Override
        public ExcludedBmps build();
    }

    public static final class PatternInfo {
        public Pattern mPattern;
        public boolean mForGCRootOnly;

        PatternInfo(Pattern pattern, boolean forGCRootOnly) {
            this.mPattern = pattern;
            this.mForGCRootOnly = forGCRootOnly;
        }
    }
}

