/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.resource.analyzer.model;

import com.squareup.haha.perflib.HprofParser;
import com.squareup.haha.perflib.Snapshot;
import com.squareup.haha.perflib.io.HprofBuffer;
import com.squareup.haha.perflib.io.MemoryMappedFileBuffer;
import com.tencent.matrix.resource.analyzer.utils.AnalyzeUtil;
import com.tencent.matrix.resource.common.utils.Preconditions;
import java.io.File;
import java.io.IOException;

public class HeapSnapshot {
    private final File mHprofFile;
    private final Snapshot mSnapshot;

    public HeapSnapshot(File hprofFile) throws IOException {
        this.mHprofFile = (File)Preconditions.checkNotNull((Object)hprofFile, (String)"hprofFile");
        this.mSnapshot = HeapSnapshot.initSnapshot(hprofFile);
    }

    public File getHprofFile() {
        return this.mHprofFile;
    }

    public Snapshot getSnapshot() {
        return this.mSnapshot;
    }

    private static Snapshot initSnapshot(File hprofFile) throws IOException {
        MemoryMappedFileBuffer buffer = new MemoryMappedFileBuffer(hprofFile);
        HprofParser parser = new HprofParser((HprofBuffer)buffer);
        Snapshot result = parser.parse();
        AnalyzeUtil.deduplicateGcRoots(result);
        return result;
    }
}

