/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.resource.analyzer.model;

import com.tencent.matrix.resource.analyzer.model.ReferenceTraceElement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ReferenceChain
implements Serializable {
    final List<ReferenceTraceElement> elements;

    public ReferenceChain(List<ReferenceTraceElement> elements) {
        this.elements = Collections.unmodifiableList(new ArrayList<ReferenceTraceElement>(elements));
    }

    public boolean isEmpty() {
        return this.elements == null || this.elements.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.elements.size(); ++i) {
            ReferenceTraceElement element = this.elements.get(i);
            sb.append("* ");
            if (i == 0) {
                sb.append("GC ROOT ");
            } else if (i == this.elements.size() - 1) {
                sb.append("leaks ");
            } else {
                sb.append("references ");
            }
            sb.append(element).append('\n');
        }
        return sb.toString();
    }

    public String toDetailedString() {
        String string = "";
        for (ReferenceTraceElement element : this.elements) {
            string = string + element.toDetailedString();
        }
        return string;
    }
}

