/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.resource.analyzer.model;

import com.tencent.matrix.resource.analyzer.model.Exclusion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public final class ReferenceTraceElement
implements Serializable {
    final String referenceName;
    final Type type;
    final Holder holder;
    final String className;
    final String extra;
    final Exclusion exclusion;
    final List<String> fields;

    public ReferenceTraceElement(String referenceName, Type type, Holder holder, String className, String extra, Exclusion exclusion, List<String> fields) {
        this.referenceName = referenceName;
        this.type = type;
        this.holder = holder;
        this.className = className;
        this.extra = extra;
        this.exclusion = exclusion;
        this.fields = Collections.unmodifiableList(new ArrayList<String>(fields));
    }

    public String toString() {
        return this.toString(false);
    }

    public String toCollectableString() {
        return this.toString(true);
    }

    private String toString(boolean collectable) {
        String string = "";
        if (this.type == Type.STATIC_FIELD) {
            string = string + "static ";
        }
        if (this.holder == Holder.ARRAY || this.holder == Holder.THREAD) {
            string = string + this.holder.name().toLowerCase(Locale.US) + " ";
        }
        string = string + this.className;
        string = this.referenceName != null ? (collectable && this.holder == Holder.ARRAY ? string + " [*]" : string + " " + this.referenceName) : string + " instance";
        if (this.extra != null) {
            string = string + " " + this.extra;
        }
        if (this.exclusion != null) {
            string = string + " , matching exclusion " + this.exclusion.matching;
        }
        return string;
    }

    public String toDetailedString() {
        String string = "* ";
        string = this.holder == Holder.ARRAY ? string + "Array of" : (this.holder == Holder.CLASS ? string + "Class" : string + "Instance of");
        string = string + " " + this.className + "\n";
        for (String field : this.fields) {
            string = string + "|   " + field + "\n";
        }
        return string;
    }

    public static enum Holder {
        OBJECT,
        CLASS,
        THREAD,
        ARRAY;

    }

    public static enum Type {
        INSTANCE_FIELD,
        STATIC_FIELD,
        LOCAL,
        ARRAY_ENTRY;

    }
}

