/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.resource.analyzer.utils;

import com.squareup.haha.perflib.RootObj;
import com.squareup.haha.perflib.Snapshot;
import com.squareup.haha.trove.THashMap;
import com.squareup.haha.trove.TObjectProcedure;
import java.util.Collection;
import java.util.concurrent.TimeUnit;

public final class AnalyzeUtil {
    public static void deduplicateGcRoots(Snapshot snapshot) {
        final THashMap uniqueRootMap = new THashMap();
        final Collection gcRoots = snapshot.getGCRoots();
        for (RootObj root : gcRoots) {
            String key = AnalyzeUtil.generateRootKey(root);
            if (uniqueRootMap.containsKey((Object)key)) continue;
            uniqueRootMap.put((Object)key, (Object)root);
        }
        gcRoots.clear();
        uniqueRootMap.forEach((TObjectProcedure)new TObjectProcedure<String>(){

            public boolean execute(String key) {
                return gcRoots.add(uniqueRootMap.get((Object)key));
            }
        });
    }

    private static String generateRootKey(RootObj root) {
        return String.format("%s@0x%08x", root.getRootType().getName(), root.getId());
    }

    public static long since(long analysisStartNanoTime) {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - analysisStartNanoTime);
    }

    private AnalyzeUtil() {
        throw new UnsupportedOperationException();
    }
}

