/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.resource.analyzer.utils;

import com.squareup.haha.perflib.ArrayInstance;
import com.squareup.haha.perflib.ClassInstance;
import com.squareup.haha.perflib.ClassObj;
import com.squareup.haha.perflib.Field;
import com.squareup.haha.perflib.HahaHelper;
import com.squareup.haha.perflib.HahaSpy;
import com.squareup.haha.perflib.Instance;
import com.squareup.haha.perflib.RootObj;
import com.squareup.haha.perflib.RootType;
import com.squareup.haha.perflib.Snapshot;
import com.squareup.haha.perflib.Type;
import com.tencent.matrix.resource.analyzer.model.ExcludedRefs;
import com.tencent.matrix.resource.analyzer.model.Exclusion;
import com.tencent.matrix.resource.analyzer.model.ReferenceChain;
import com.tencent.matrix.resource.analyzer.model.ReferenceNode;
import com.tencent.matrix.resource.analyzer.model.ReferenceTraceElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public final class ShortestPathFinder {
    private static final String ANONYMOUS_CLASS_NAME_PATTERN = "^.+\\$\\d+$";
    private final ExcludedRefs excludedRefs;
    private final Queue<ReferenceNode> toVisitQueue;
    private final Queue<ReferenceNode> toVisitIfNoPathQueue;
    private final Set<Instance> toVisitSet;
    private final Set<Instance> toVisitIfNoPathSet;
    private final Set<Instance> visitedSet;
    private boolean canIgnoreStrings;

    public ShortestPathFinder(ExcludedRefs excludedRefs) {
        this.excludedRefs = excludedRefs;
        this.toVisitQueue = new LinkedList<ReferenceNode>();
        this.toVisitIfNoPathQueue = new LinkedList<ReferenceNode>();
        this.toVisitSet = new HashSet<Instance>();
        this.toVisitIfNoPathSet = new HashSet<Instance>();
        this.visitedSet = new HashSet<Instance>();
    }

    public Result findPath(Snapshot snapshot, Instance targetReference) {
        ArrayList<Instance> targetRefList = new ArrayList<Instance>();
        targetRefList.add(targetReference);
        Map<Instance, Result> results = this.findPath(snapshot, targetRefList);
        if (results == null || results.isEmpty()) {
            return new Result(null, false);
        }
        return results.get(targetReference);
    }

    public Map<Instance, Result> findPath(Snapshot snapshot, Collection<Instance> targetReferences) {
        HashMap<Instance, Result> results = new HashMap<Instance, Result>();
        if (targetReferences.isEmpty()) {
            return results;
        }
        this.clearState();
        this.enqueueGcRoots(snapshot);
        this.canIgnoreStrings = true;
        for (Instance targetReference : targetReferences) {
            if (!ShortestPathFinder.isString(targetReference)) continue;
            this.canIgnoreStrings = false;
            break;
        }
        HashSet<Instance> targetRefSet = new HashSet<Instance>(targetReferences);
        while (!this.toVisitQueue.isEmpty() || !this.toVisitIfNoPathQueue.isEmpty()) {
            ReferenceNode node;
            if (!this.toVisitQueue.isEmpty()) {
                node = this.toVisitQueue.poll();
            } else {
                node = this.toVisitIfNoPathQueue.poll();
                if (node.exclusion == null) {
                    throw new IllegalStateException("Expected node to have an exclusion " + node);
                }
            }
            if (targetRefSet.contains(node.instance)) {
                results.put(node.instance, new Result(node, node.exclusion != null));
                targetRefSet.remove(node.instance);
                if (targetRefSet.isEmpty()) break;
            }
            if (this.checkSeen(node)) continue;
            if (node.instance instanceof RootObj) {
                this.visitRootObj(node);
                continue;
            }
            if (node.instance instanceof ClassObj) {
                this.visitClassObj(node);
                continue;
            }
            if (node.instance instanceof ClassInstance) {
                this.visitClassInstance(node);
                continue;
            }
            if (node.instance instanceof ArrayInstance) {
                this.visitArrayInstance(node);
                continue;
            }
            throw new IllegalStateException("Unexpected type for " + node.instance);
        }
        return results;
    }

    private void clearState() {
        this.toVisitQueue.clear();
        this.toVisitIfNoPathQueue.clear();
        this.toVisitSet.clear();
        this.toVisitIfNoPathSet.clear();
        this.visitedSet.clear();
    }

    private void enqueueGcRoots(Snapshot snapshot) {
        block5: for (RootObj rootObj : snapshot.getGCRoots()) {
            switch (rootObj.getRootType()) {
                case JAVA_LOCAL: {
                    Instance thread = HahaSpy.allocatingThread((Instance)rootObj);
                    String threadName = HahaHelper.threadName(thread);
                    Exclusion params = this.excludedRefs.threadNames.get(threadName);
                    if (params != null && params.alwaysExclude) continue block5;
                    this.enqueue(params, null, (Instance)rootObj, null, null);
                    continue block5;
                }
                case INTERNED_STRING: 
                case DEBUGGER: 
                case INVALID_TYPE: 
                case UNREACHABLE: 
                case UNKNOWN: 
                case FINALIZING: {
                    continue block5;
                }
                case SYSTEM_CLASS: 
                case VM_INTERNAL: 
                case NATIVE_LOCAL: 
                case NATIVE_STATIC: 
                case THREAD_BLOCK: 
                case BUSY_MONITOR: 
                case NATIVE_MONITOR: 
                case REFERENCE_CLEANUP: 
                case NATIVE_STACK: 
                case JAVA_STATIC: {
                    this.enqueue(null, null, (Instance)rootObj, null, null);
                    continue block5;
                }
            }
            throw new UnsupportedOperationException("Unknown root type:" + rootObj.getRootType());
        }
    }

    private boolean checkSeen(ReferenceNode node) {
        return !this.visitedSet.add(node.instance);
    }

    private void visitRootObj(ReferenceNode node) {
        RootObj rootObj = (RootObj)node.instance;
        Instance child = rootObj.getReferredInstance();
        if (rootObj.getRootType() == RootType.JAVA_LOCAL) {
            Instance holder = HahaSpy.allocatingThread((Instance)rootObj);
            Exclusion exclusion = null;
            if (node.exclusion != null) {
                exclusion = node.exclusion;
            }
            ReferenceNode parent = new ReferenceNode(null, holder, null, null, null);
            this.enqueue(exclusion, parent, child, "<Java Local>", ReferenceTraceElement.Type.LOCAL);
        } else {
            this.enqueue(null, node, child, null, null);
        }
    }

    private void visitClassObj(ReferenceNode node) {
        ClassObj classObj = (ClassObj)node.instance;
        Map<String, Exclusion> ignoredStaticFields = this.excludedRefs.staticFieldNameByClassName.get(classObj.getClassName());
        for (Map.Entry entry : classObj.getStaticFieldValues().entrySet()) {
            Exclusion params;
            String fieldName;
            Field field = (Field)entry.getKey();
            if (field.getType() != Type.OBJECT || "$staticOverhead".equals(fieldName = field.getName())) continue;
            Instance child = (Instance)entry.getValue();
            boolean visit = true;
            if (ignoredStaticFields != null && (params = ignoredStaticFields.get(fieldName)) != null) {
                visit = false;
                if (!params.alwaysExclude) {
                    this.enqueue(params, node, child, fieldName, ReferenceTraceElement.Type.STATIC_FIELD);
                }
            }
            if (!visit) continue;
            this.enqueue(null, node, child, fieldName, ReferenceTraceElement.Type.STATIC_FIELD);
        }
    }

    private void visitClassInstance(ReferenceNode node) {
        ClassInstance classInstance = (ClassInstance)node.instance;
        LinkedHashMap<String, Exclusion> ignoredFields = new LinkedHashMap<String, Exclusion>();
        Exclusion classExclusion = null;
        for (ClassObj superClassObj = classInstance.getClassObj(); superClassObj != null; superClassObj = superClassObj.getSuperClassObj()) {
            Map<String, Exclusion> classIgnoredFields;
            Exclusion params = this.excludedRefs.classNames.get(superClassObj.getClassName());
            if (!(params == null || classExclusion != null && classExclusion.alwaysExclude)) {
                classExclusion = params;
            }
            if ((classIgnoredFields = this.excludedRefs.fieldNameByClassName.get(superClassObj.getClassName())) == null) continue;
            ignoredFields.putAll(classIgnoredFields);
        }
        if (classExclusion != null && classExclusion.alwaysExclude) {
            return;
        }
        for (ClassInstance.FieldValue fieldValue : classInstance.getValues()) {
            Exclusion fieldExclusion = classExclusion;
            Field field = fieldValue.getField();
            if (field.getType() != Type.OBJECT) continue;
            Instance child = (Instance)fieldValue.getValue();
            String fieldName = field.getName();
            Exclusion params = (Exclusion)ignoredFields.get(fieldName);
            if (params != null && (fieldExclusion == null || params.alwaysExclude && !fieldExclusion.alwaysExclude)) {
                fieldExclusion = params;
            }
            this.enqueue(fieldExclusion, node, child, fieldName, ReferenceTraceElement.Type.INSTANCE_FIELD);
        }
    }

    private void visitArrayInstance(ReferenceNode node) {
        ArrayInstance arrayInstance = (ArrayInstance)node.instance;
        Type arrayType = arrayInstance.getArrayType();
        if (arrayType == Type.OBJECT) {
            Object[] values = arrayInstance.getValues();
            for (int i = 0; i < values.length; ++i) {
                Instance child = (Instance)values[i];
                this.enqueue(null, node, child, "[" + i + "]", ReferenceTraceElement.Type.ARRAY_ENTRY);
            }
        }
    }

    private void enqueue(Exclusion exclusion, ReferenceNode parent, Instance child, String referenceName, ReferenceTraceElement.Type referenceType) {
        boolean visitNow;
        if (child == null) {
            return;
        }
        if (HahaHelper.isPrimitiveOrWrapperArray(child) || HahaHelper.isPrimitiveWrapper(child)) {
            return;
        }
        if (this.toVisitSet.contains(child)) {
            return;
        }
        boolean bl = visitNow = exclusion == null;
        if (!visitNow && this.toVisitIfNoPathSet.contains(child)) {
            return;
        }
        if (this.canIgnoreStrings && ShortestPathFinder.isString(child)) {
            return;
        }
        if (this.visitedSet.contains(child)) {
            return;
        }
        ReferenceNode childNode = new ReferenceNode(exclusion, child, parent, referenceName, referenceType);
        if (visitNow) {
            this.toVisitSet.add(child);
            this.toVisitQueue.add(childNode);
        } else {
            this.toVisitIfNoPathSet.add(child);
            this.toVisitIfNoPathQueue.add(childNode);
        }
    }

    private static boolean isString(Instance instance) {
        return instance.getClassObj() != null && instance.getClassObj().getClassName().equals(String.class.getName());
    }

    public static final class Result {
        public final ReferenceNode referenceChainHead;
        public final boolean excludingKnown;

        Result(ReferenceNode referenceChainHead, boolean excludingKnown) {
            this.referenceChainHead = referenceChainHead;
            this.excludingKnown = excludingKnown;
        }

        public ReferenceChain buildReferenceChain() {
            ArrayList<ReferenceTraceElement> elements = new ArrayList<ReferenceTraceElement>();
            ReferenceNode node = new ReferenceNode(null, null, this.referenceChainHead, null, null);
            while (node != null) {
                ReferenceTraceElement element = this.buildReferenceTraceElement(node);
                if (element != null) {
                    elements.add(0, element);
                }
                node = node.parent;
            }
            return new ReferenceChain(elements);
        }

        private ReferenceTraceElement buildReferenceTraceElement(ReferenceNode node) {
            ReferenceTraceElement.Holder holderType;
            String className;
            List<String> fields;
            String extra;
            String referenceName;
            ReferenceTraceElement.Type type;
            block15: {
                if (node.parent == null) {
                    return null;
                }
                Instance holder = node.parent.instance;
                if (holder instanceof RootObj) {
                    return null;
                }
                type = node.referenceType;
                referenceName = node.referenceName;
                extra = null;
                fields = this.describeFields(holder);
                className = this.getClassName(holder);
                if (holder instanceof ClassObj) {
                    holderType = ReferenceTraceElement.Holder.CLASS;
                } else if (holder instanceof ArrayInstance) {
                    holderType = ReferenceTraceElement.Holder.ARRAY;
                } else {
                    ClassObj classObj = holder.getClassObj();
                    if (HahaHelper.extendsThread(classObj)) {
                        holderType = ReferenceTraceElement.Holder.THREAD;
                        String threadName = HahaHelper.threadName(holder);
                        extra = "(named '" + threadName + "')";
                    } else if (className.matches(ShortestPathFinder.ANONYMOUS_CLASS_NAME_PATTERN)) {
                        String parentClassName = classObj.getSuperClassObj().getClassName();
                        if (Object.class.getName().equals(parentClassName)) {
                            holderType = ReferenceTraceElement.Holder.OBJECT;
                            try {
                                Class<?> actualClass = Class.forName(classObj.getClassName());
                                Class<?>[] interfaces = actualClass.getInterfaces();
                                if (interfaces.length > 0) {
                                    Class<?> implementedInterface = interfaces[0];
                                    extra = "(anonymous implementation of " + implementedInterface.getName() + ")";
                                    break block15;
                                }
                                extra = "(anonymous subclass of java.lang.Object)";
                            }
                            catch (ClassNotFoundException classNotFoundException) {}
                        } else {
                            holderType = ReferenceTraceElement.Holder.OBJECT;
                            extra = "(anonymous subclass of " + parentClassName + ")";
                        }
                    } else {
                        holderType = ReferenceTraceElement.Holder.OBJECT;
                    }
                }
            }
            return new ReferenceTraceElement(referenceName, type, holderType, className, extra, node.exclusion, fields);
        }

        /*
         * WARNING - void declaration
         */
        private List<String> describeFields(Instance instance) {
            ArrayList<String> fields;
            block5: {
                block6: {
                    void var5_11;
                    block4: {
                        fields = new ArrayList<String>();
                        if (!(instance instanceof ClassObj)) break block4;
                        ClassObj classObj = (ClassObj)instance;
                        for (Map.Entry entry : classObj.getStaticFieldValues().entrySet()) {
                            Field field = (Field)entry.getKey();
                            Object value = entry.getValue();
                            fields.add("static " + field.getName() + " = " + value);
                        }
                        break block5;
                    }
                    if (!(instance instanceof ArrayInstance)) break block6;
                    ArrayInstance arrayInstance = (ArrayInstance)instance;
                    if (arrayInstance.getArrayType() != Type.OBJECT) break block5;
                    Object[] values = arrayInstance.getValues();
                    boolean bl = false;
                    while (var5_11 < values.length) {
                        fields.add("[" + (int)var5_11 + "] = " + values[var5_11]);
                        ++var5_11;
                    }
                    break block5;
                }
                ClassObj classObj = instance.getClassObj();
                for (Map.Entry<Field, Object> entry : classObj.getStaticFieldValues().entrySet()) {
                    fields.add("static " + HahaHelper.fieldToString(entry));
                }
                ClassInstance classInstance = (ClassInstance)instance;
                for (ClassInstance.FieldValue field : classInstance.getValues()) {
                    fields.add(HahaHelper.fieldToString(field));
                }
            }
            return fields;
        }

        private String getClassName(Instance instance) {
            String className;
            if (instance instanceof ClassObj) {
                ClassObj classObj = (ClassObj)instance;
                className = classObj.getClassName();
            } else if (instance instanceof ArrayInstance) {
                ArrayInstance arrayInstance = (ArrayInstance)instance;
                className = arrayInstance.getClassObj().getClassName();
            } else {
                ClassObj classObj = instance.getClassObj();
                className = classObj.getClassName();
            }
            return className;
        }
    }
}

