/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.resource.common.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class StreamUtil {
    public static void closeQuietly(Object target) {
        if (target == null) {
            return;
        }
        try {
            if (target instanceof Closeable) {
                ((Closeable)target).close();
            } else if (target instanceof ZipFile) {
                ((ZipFile)target).close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZipEntry(ZipFile zipFile, ZipEntry targetEntry, File output) throws IOException {
        BufferedInputStream is = null;
        BufferedOutputStream os = null;
        try {
            is = new BufferedInputStream(zipFile.getInputStream(targetEntry));
            os = new BufferedOutputStream(new FileOutputStream(output));
            byte[] buffer = new byte[4096];
            int bytesRead = 0;
            while ((bytesRead = ((InputStream)is).read(buffer)) > 0) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.closeQuietly(os);
            StreamUtil.closeQuietly(is);
            throw throwable;
        }
        StreamUtil.closeQuietly(os);
        StreamUtil.closeQuietly(is);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileToStream(File in, OutputStream out) throws IOException {
        BufferedInputStream is = null;
        byte[] buffer = new byte[4096];
        try {
            is = new BufferedInputStream(new FileInputStream(in));
            int bytesRead = 0;
            while ((bytesRead = ((InputStream)is).read(buffer)) > 0) {
                out.write(buffer, 0, bytesRead);
            }
            out.flush();
        }
        catch (Throwable throwable) {
            StreamUtil.closeQuietly(is);
            throw throwable;
        }
        StreamUtil.closeQuietly(is);
    }

    private StreamUtil() {
        throw new UnsupportedOperationException();
    }
}

