/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint;

import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import com.tencent.sqlitelint.R;

public class SQLiteLintIssue
implements Parcelable {
    public static final int PASS = 0;
    public static final int TIPS = 1;
    public static final int SUGGESTION = 2;
    public static final int WARNING = 3;
    public static final int ERROR = 4;
    public String id;
    public String dbPath;
    public int level;
    public int type;
    public String sql;
    public String table;
    public String desc;
    public String detail;
    public String advice;
    public long createTime;
    public String extInfo;
    public long sqlTimeCost;
    public boolean isNew;
    public boolean isInMainThread;
    public static final Parcelable.Creator<SQLiteLintIssue> CREATOR = new Parcelable.Creator<SQLiteLintIssue>(){

        public SQLiteLintIssue createFromParcel(Parcel in) {
            return new SQLiteLintIssue(in);
        }

        public SQLiteLintIssue[] newArray(int size) {
            return new SQLiteLintIssue[size];
        }
    };

    @NonNull
    public static String getLevelText(int level, @NonNull Context context) {
        String levelText = "";
        switch (level) {
            case 1: {
                levelText = context.getString(R.string.diagnosis_level_tips);
                break;
            }
            case 2: {
                levelText = context.getString(R.string.diagnosis_level_suggestion);
                break;
            }
            case 3: {
                levelText = context.getString(R.string.diagnosis_level_warning);
                break;
            }
            case 4: {
                levelText = context.getString(R.string.diagnosis_level_error);
                break;
            }
            default: {
                levelText = context.getString(R.string.diagnosis_level_suggestion);
            }
        }
        return levelText;
    }

    public SQLiteLintIssue() {
    }

    public SQLiteLintIssue(String id, String dbPath, int level, int type, String sql, String table, String desc, String detail, String advice, long createTime, String extInfo, long sqlTimeCost, boolean isInMainThread) {
        this.id = id;
        this.dbPath = dbPath;
        this.level = level;
        this.type = type;
        this.sql = sql;
        this.table = table;
        this.desc = desc;
        this.detail = detail;
        this.advice = advice;
        this.createTime = createTime;
        this.extInfo = extInfo;
        this.sqlTimeCost = sqlTimeCost;
        this.isInMainThread = isInMainThread;
    }

    public boolean equals(Object o) {
        if (!(o instanceof SQLiteLintIssue)) {
            return false;
        }
        SQLiteLintIssue d = (SQLiteLintIssue)o;
        return d.id.equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected SQLiteLintIssue(Parcel in) {
        this.id = in.readString();
        this.dbPath = in.readString();
        this.level = in.readInt();
        this.type = in.readInt();
        this.sql = in.readString();
        this.table = in.readString();
        this.desc = in.readString();
        this.detail = in.readString();
        this.advice = in.readString();
        this.createTime = in.readLong();
        this.extInfo = in.readString();
        this.sqlTimeCost = in.readLong();
        this.isInMainThread = in.readInt() == 1;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.id);
        dest.writeString(this.dbPath);
        dest.writeInt(this.level);
        dest.writeInt(this.type);
        dest.writeString(this.sql);
        dest.writeString(this.table);
        dest.writeString(this.desc);
        dest.writeString(this.detail);
        dest.writeString(this.advice);
        dest.writeLong(this.createTime);
        dest.writeString(this.extInfo);
        dest.writeLong(this.sqlTimeCost);
        dest.writeInt(this.isInMainThread ? 1 : 0);
    }
}

