/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint.behaviour.persistence;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import com.tencent.sqlitelint.behaviour.persistence.IssueStorage;
import com.tencent.sqlitelint.util.SLog;

public enum SQLiteLintDbHelper {
    INSTANCE;

    private static final String TAG = "SQLiteLint.SQLiteLintOwnDatabase";
    private static final String DB_NAME = "SQLiteLintInternal.db";
    private static final int VERSION_1 = 1;
    private volatile InternalDbHelper mHelper;

    public SQLiteDatabase getDatabase() {
        if (this.mHelper == null) {
            throw new IllegalStateException("getIssueStorage db not ready");
        }
        return this.mHelper.getWritableDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Context context) {
        if (this.mHelper == null) {
            SQLiteLintDbHelper sQLiteLintDbHelper = this;
            synchronized (sQLiteLintDbHelper) {
                if (this.mHelper == null) {
                    this.mHelper = new InternalDbHelper(context);
                }
            }
        }
    }

    private static final class InternalDbHelper
    extends SQLiteOpenHelper {
        private static final String DB_NAME = "SQLiteLintInternal.db";
        private static final int VERSION_1 = 1;

        InternalDbHelper(Context context) {
            super(context, "SQLiteLintInternal.db", null, 1);
        }

        public void onCreate(SQLiteDatabase db) {
            SLog.i(SQLiteLintDbHelper.TAG, "onCreate", new Object[0]);
            db.execSQL(IssueStorage.DB_VERSION_1_CREATE_SQL);
            for (int i = 0; i < IssueStorage.DB_VERSION_1_CREATE_INDEX.length; ++i) {
                db.execSQL(IssueStorage.DB_VERSION_1_CREATE_INDEX[i]);
            }
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        }
    }
}

