/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint;

import android.database.Cursor;
import android.database.SQLException;
import com.tencent.sqlitelint.ISQLiteExecutionDelegate;
import com.tencent.sqlitelint.SQLiteLintAndroidCore;
import com.tencent.sqlitelint.SQLiteLintAndroidCoreManager;
import com.tencent.sqlitelint.SQLiteLintIssue;
import com.tencent.sqlitelint.util.SLog;
import java.util.ArrayList;

public class SQLiteLintNativeBridge {
    private static final String TAG = "SQLiteLint.SQLiteLintNativeBridge";

    public static void loadLibrary() {
        System.loadLibrary("SqliteLint-lib");
        SLog.nativeSetLogger(2);
    }

    SQLiteLintNativeBridge() {
    }

    static native void nativeInstall(String var0);

    static native void nativeUninstall(String var0);

    static native void nativeNotifySqlExecute(String var0, String var1, long var2, String var4);

    private native void execSqlCallback(long var1, long var3, String var5, int var6, String[] var7, String[] var8);

    public static native void nativeAddToWhiteList(String var0, String[] var1, String[][] var2);

    public static native void nativeEnableCheckers(String var0, String[] var1);

    private static void onPublishIssue(String dbName, ArrayList<SQLiteLintIssue> publishedIssues) {
        try {
            SQLiteLintAndroidCoreManager.INSTANCE.get(dbName).onPublish(publishedIssues);
        }
        catch (Throwable e) {
            SLog.e(TAG, "onPublishIssue ex ", e.getMessage());
        }
    }

    private String[] sqliteLintExecSql(String dbPath, String sql, boolean needCallBack, long execSqlCallbackPtr, long paraPtr) {
        String[] retObj;
        block12: {
            retObj = new String[2];
            try {
                SLog.i(TAG, "dbPath %s, sql is %s ,needCallBack: %b", dbPath, sql, needCallBack);
                retObj[0] = "";
                retObj[1] = "-1";
                ISQLiteExecutionDelegate executionDelegate = null;
                SQLiteLintAndroidCore core = SQLiteLintAndroidCoreManager.INSTANCE.get(dbPath);
                if (core != null) {
                    executionDelegate = core.getSQLiteExecutionDelegate();
                }
                if (executionDelegate == null) {
                    SLog.w(TAG, "sqliteLintExecSql mExecSqlImp is null", new Object[0]);
                    return retObj;
                }
                if (needCallBack) {
                    try {
                        Cursor cu = executionDelegate.rawQuery(sql, new String[0]);
                        if (cu == null || cu.getCount() < 0) {
                            SLog.w(TAG, "sqliteLintExecSql cu is null", new Object[0]);
                            retObj[0] = "Cursor is null";
                        } else {
                            this.doExecSqlCallback(execSqlCallbackPtr, paraPtr, dbPath, cu);
                            retObj[1] = "0";
                        }
                        if (cu != null) {
                            cu.close();
                        }
                        break block12;
                    }
                    catch (Exception e) {
                        SLog.w(TAG, "sqliteLintExecSql rawQuery exp: %s", e.getMessage());
                        retObj[0] = e.getMessage();
                    }
                    break block12;
                }
                try {
                    executionDelegate.execSQL(sql);
                    retObj[1] = "0";
                }
                catch (SQLException e) {
                    SLog.w(TAG, "sqliteLintExecSql execSQL exp: %s", e.getMessage());
                    retObj[0] = e.getMessage();
                }
            }
            catch (Throwable e) {
                SLog.e(TAG, "sqliteLintExecSql ex ", e.getMessage());
            }
        }
        return retObj;
    }

    private void doExecSqlCallback(long execSqlCallbackPtr, long paraPtr, String dbName, Cursor cu) {
        if (cu == null) {
            SLog.w(TAG, "doExecSqlCallback cu is null", new Object[0]);
            return;
        }
        while (cu.moveToNext()) {
            int columnCount = cu.getColumnCount();
            String[] name = new String[columnCount];
            String[] value = new String[columnCount];
            block7: for (int i = 0; i < columnCount; ++i) {
                name[i] = cu.getColumnName(i);
                switch (cu.getType(i)) {
                    case 4: {
                        value[i] = String.valueOf(cu.getBlob(i));
                        continue block7;
                    }
                    case 1: {
                        value[i] = String.valueOf(cu.getLong(i));
                        continue block7;
                    }
                    case 3: {
                        value[i] = String.valueOf(cu.getString(i));
                        continue block7;
                    }
                    case 2: {
                        value[i] = String.valueOf(cu.getFloat(i));
                        continue block7;
                    }
                    default: {
                        value[i] = "";
                    }
                }
            }
            this.execSqlCallback(execSqlCallbackPtr, paraPtr, dbName, columnCount, value, name);
        }
    }
}

