/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint.behaviour.alert;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.tencent.sqlitelint.R;
import com.tencent.sqlitelint.SQLiteLintIssue;
import com.tencent.sqlitelint.behaviour.alert.IssueDetailActivity;
import com.tencent.sqlitelint.behaviour.alert.SQLiteLintBaseActivity;
import com.tencent.sqlitelint.behaviour.persistence.IssueStorage;
import com.tencent.sqlitelint.util.SLog;
import com.tencent.sqlitelint.util.SQLiteLintUtil;
import java.util.List;

public class CheckResultActivity
extends SQLiteLintBaseActivity {
    private static final String TAG = "MpApp.CheckResultActivity";
    public static final String KEY_DB_LABEL = "db_label";
    private String mDbLabel;
    private List<SQLiteLintIssue> mCheckResultList;
    private CheckResultListAdapter mAdapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mDbLabel = this.getIntent().getStringExtra(KEY_DB_LABEL);
        this.initView();
        this.refreshData();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.refreshData();
    }

    private void refreshData() {
        List<SQLiteLintIssue> issueList = IssueStorage.getIssueListByDb(this.mDbLabel);
        if (this.mCheckResultList == null) {
            this.mCheckResultList = issueList;
        } else {
            this.mCheckResultList.clear();
            this.mCheckResultList.addAll(issueList);
        }
        SLog.d(TAG, "refreshData size %d", this.mCheckResultList.size());
        this.mAdapter.notifyDataSetChanged();
    }

    private void initView() {
        String dbName = SQLiteLintUtil.extractDbName(this.mDbLabel);
        this.setTitle(this.getString(R.string.check_result_title, new Object[]{dbName}));
        ListView listView = (ListView)this.findViewById(R.id.list);
        this.mAdapter = new CheckResultListAdapter();
        listView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                SQLiteLintIssue issue = (SQLiteLintIssue)parent.getItemAtPosition(position);
                Intent intent = new Intent();
                intent.putExtra("issue", (Parcelable)issue);
                intent.setClass(CheckResultActivity.this.getBaseContext(), IssueDetailActivity.class);
                CheckResultActivity.this.startActivity(intent);
            }
        });
        listView.setAdapter((ListAdapter)this.mAdapter);
        this.mAdapter.notifyDataSetChanged();
    }

    @Override
    protected int getLayoutId() {
        return R.layout.activity_check_result;
    }

    static class ViewHolder {
        public TextView checkResultTv;
        public TextView diagnosisLevelTv;
        public TextView timeTv;

        ViewHolder() {
        }
    }

    class CheckResultListAdapter
    extends BaseAdapter {
        private final LayoutInflater mInflater;

        CheckResultListAdapter() {
            this.mInflater = LayoutInflater.from((Context)CheckResultActivity.this);
        }

        public int getCount() {
            if (CheckResultActivity.this.mCheckResultList == null) {
                return 0;
            }
            return CheckResultActivity.this.mCheckResultList.size();
        }

        public SQLiteLintIssue getItem(int position) {
            return (SQLiteLintIssue)CheckResultActivity.this.mCheckResultList.get(position);
        }

        public long getItemId(int position) {
            return 0L;
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            ViewHolder viewHolder;
            if (convertView == null) {
                convertView = this.mInflater.inflate(R.layout.view_check_result_item, parent, false);
                viewHolder = new ViewHolder();
                viewHolder.checkResultTv = (TextView)convertView.findViewById(R.id.result_tv);
                viewHolder.diagnosisLevelTv = (TextView)convertView.findViewById(R.id.diagnosis_level_tv);
                viewHolder.timeTv = (TextView)convertView.findViewById(R.id.time_tv);
                convertView.setTag((Object)viewHolder);
            } else {
                viewHolder = (ViewHolder)convertView.getTag();
            }
            SQLiteLintIssue issue = this.getItem(position);
            viewHolder.checkResultTv.setText((CharSequence)String.format("%d\u3001%s", position + 1, issue.desc));
            viewHolder.timeTv.setText((CharSequence)SQLiteLintUtil.formatTime("yyyy-MM-dd HH:mm", issue.createTime));
            viewHolder.diagnosisLevelTv.setText((CharSequence)SQLiteLintIssue.getLevelText(issue.level, CheckResultActivity.this.getBaseContext()));
            return convertView;
        }
    }
}

