/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint.behaviour.alert;

import android.os.Bundle;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tencent.sqlitelint.R;
import com.tencent.sqlitelint.SQLiteLintIssue;
import com.tencent.sqlitelint.behaviour.alert.SQLiteLintBaseActivity;
import com.tencent.sqlitelint.util.SLog;
import com.tencent.sqlitelint.util.SQLiteLintUtil;

public class IssueDetailActivity
extends SQLiteLintBaseActivity {
    private static final String TAG = "MicroMsg.IssueDetailActivity";
    public static final String KEY_ISSUE = "issue";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initView((SQLiteLintIssue)this.getIntent().getParcelableExtra(KEY_ISSUE));
    }

    private void initView(final SQLiteLintIssue issue) {
        LinearLayout adviceLayout;
        if (issue == null) {
            return;
        }
        this.setTitle(this.getString(R.string.diagnosis_detail_title));
        TextView timeTv = (TextView)this.findViewById(R.id.time_tv);
        TextView diagnosisLevelTv = (TextView)this.findViewById(R.id.diagnosis_level_tv);
        timeTv.setText((CharSequence)SQLiteLintUtil.formatTime("yyyy-MM-dd HH:mm", issue.createTime));
        diagnosisLevelTv.setText((CharSequence)SQLiteLintIssue.getLevelText(issue.level, this.getBaseContext()));
        if (!SQLiteLintUtil.isNullOrNil(issue.desc)) {
            LinearLayout descLayout = (LinearLayout)this.findViewById(R.id.desc_layout);
            TextView descTv = (TextView)this.findViewById(R.id.desc_tv);
            descTv.setText((CharSequence)issue.desc);
            descLayout.setVisibility(0);
            descLayout.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SLog.v(IssueDetailActivity.TAG, issue.desc.replace("%", "###"), new Object[0]);
                }
            });
        }
        if (!SQLiteLintUtil.isNullOrNil(issue.detail)) {
            LinearLayout detailLayout = (LinearLayout)this.findViewById(R.id.detail_layout);
            TextView detailTv = (TextView)this.findViewById(R.id.detail_tv);
            detailTv.setText((CharSequence)issue.detail);
            detailLayout.setVisibility(0);
            detailTv.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    SLog.v(IssueDetailActivity.TAG, issue.detail.replace("%", "###"), new Object[0]);
                }
            });
        }
        if (!SQLiteLintUtil.isNullOrNil(issue.advice)) {
            adviceLayout = (LinearLayout)this.findViewById(R.id.advice_layout);
            TextView adviceTv = (TextView)this.findViewById(R.id.advice_tv);
            adviceTv.setText((CharSequence)issue.advice);
            adviceLayout.setVisibility(0);
        }
        if (!SQLiteLintUtil.isNullOrNil(issue.extInfo)) {
            adviceLayout = (LinearLayout)this.findViewById(R.id.ext_info_layout);
            TextView extInfoTv = (TextView)this.findViewById(R.id.ext_info_tv);
            extInfoTv.setText((CharSequence)this.getString(R.string.diagnosis_ext_info_title, new Object[]{issue.extInfo}));
            adviceLayout.setVisibility(0);
        }
    }

    @Override
    protected int getLayoutId() {
        return R.layout.activity_diagnosis_detail;
    }
}

