/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.sqlitelint.util;

import com.tencent.sqlitelint.SQLiteLint;
import com.tencent.sqlitelint.util.SLog;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.ListIterator;

public class SQLiteLintUtil {
    private static final String TAG = "SQLiteLint.SQLiteLintUtil";
    public static final String YYYY_MM_DD_HH_mm = "yyyy-MM-dd HH:mm";
    private static final int DEFAULT_MAX_STACK_LAYER = 6;

    public static boolean isNullOrNil(String object) {
        return object == null || object.length() <= 0;
    }

    public static String nullAsNil(String object) {
        return object == null ? "" : object;
    }

    public static String extractDbName(String dbPath) {
        if (SQLiteLintUtil.isNullOrNil(dbPath)) {
            return null;
        }
        String dbName = null;
        String[] arr = dbPath.split("/");
        if (arr != null && arr.length > 0) {
            dbName = arr[arr.length - 1];
        }
        return dbName;
    }

    public static int getInt(String string, int def) {
        try {
            return string == null || string.length() <= 0 ? def : Integer.parseInt(string);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            return def;
        }
    }

    public static String formatTime(String format, long timeMilliSecond) {
        return new SimpleDateFormat(format).format(new Date(timeMilliSecond));
    }

    public static void mkdirs(String filePath) {
        File parentFile;
        File file = new File(filePath);
        if (!file.exists() && (parentFile = file.getParentFile()) != null) {
            parentFile.mkdirs();
        }
    }

    public static String stackTraceToString(StackTraceElement[] arr) {
        if (arr == null) {
            return "";
        }
        ArrayList<StackTraceElement> stacks = new ArrayList<StackTraceElement>(arr.length);
        for (int i = 0; i < arr.length; ++i) {
            String className = arr[i].getClassName();
            if (className.contains("com.tencent.sqlitelint")) continue;
            stacks.add(arr[i]);
        }
        if (stacks.size() > 6 && SQLiteLint.sPackageName != null) {
            ListIterator iterator = stacks.listIterator(stacks.size());
            while (iterator.hasPrevious()) {
                StackTraceElement stack = (StackTraceElement)iterator.previous();
                String className = stack.getClassName();
                if (!className.contains(SQLiteLint.sPackageName)) {
                    iterator.remove();
                }
                if (stacks.size() > 6) continue;
                break;
            }
        }
        StringBuffer sb = new StringBuffer(stacks.size());
        for (StackTraceElement stackTraceElement : stacks) {
            sb.append(stackTraceElement).append('\n');
        }
        return sb.toString();
    }

    public static String getThrowableStack(Throwable throwable) {
        if (throwable == null) {
            return "";
        }
        return SQLiteLintUtil.stackTraceToString(throwable.getStackTrace());
    }

    public static String getThrowableStack() {
        try {
            return SQLiteLintUtil.getThrowableStack(new Throwable());
        }
        catch (Throwable e) {
            SLog.e(TAG, "getThrowableStack ex %s", e.getMessage());
            return "";
        }
    }
}

