/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace;

import android.app.Application;
import android.os.Build;
import android.os.Looper;
import com.tencent.matrix.plugin.Plugin;
import com.tencent.matrix.plugin.PluginListener;
import com.tencent.matrix.trace.config.TraceConfig;
import com.tencent.matrix.trace.core.AppMethodBeat;
import com.tencent.matrix.trace.core.UIThreadMonitor;
import com.tencent.matrix.trace.tracer.EvilMethodTracer;
import com.tencent.matrix.trace.tracer.FrameTracer;
import com.tencent.matrix.trace.tracer.IdleHandlerLagTracer;
import com.tencent.matrix.trace.tracer.LooperAnrTracer;
import com.tencent.matrix.trace.tracer.SignalAnrTracer;
import com.tencent.matrix.trace.tracer.StartupTracer;
import com.tencent.matrix.trace.tracer.TouchEventLagTracer;
import com.tencent.matrix.util.MatrixHandlerThread;
import com.tencent.matrix.util.MatrixLog;

public class TracePlugin
extends Plugin {
    private static final String TAG = "Matrix.TracePlugin";
    private final TraceConfig traceConfig;
    private EvilMethodTracer evilMethodTracer;
    private StartupTracer startupTracer;
    private FrameTracer frameTracer;
    private LooperAnrTracer looperAnrTracer;
    private SignalAnrTracer signalAnrTracer;
    private IdleHandlerLagTracer idleHandlerLagTracer;
    private TouchEventLagTracer touchEventLagTracer;
    private final int sdkInt = Build.VERSION.SDK_INT;

    public TracePlugin(TraceConfig config) {
        this.traceConfig = config;
    }

    public void init(Application app, PluginListener listener) {
        super.init(app, listener);
        MatrixLog.i((String)TAG, (String)"trace plugin init, trace config: %s", (Object[])new Object[]{this.traceConfig.toString()});
        if (this.sdkInt < 16) {
            MatrixLog.e((String)TAG, (String)"[FrameBeat] API is low Build.VERSION_CODES.JELLY_BEAN(16), TracePlugin is not supported", (Object[])new Object[0]);
            this.unSupportPlugin();
            return;
        }
        this.looperAnrTracer = new LooperAnrTracer(this.traceConfig);
        this.frameTracer = new FrameTracer(this.traceConfig);
        this.evilMethodTracer = new EvilMethodTracer(this.traceConfig);
        this.startupTracer = new StartupTracer(this.traceConfig);
    }

    public void start() {
        super.start();
        if (!this.isSupported()) {
            MatrixLog.w((String)TAG, (String)"[start] Plugin is unSupported!", (Object[])new Object[0]);
            return;
        }
        MatrixLog.w((String)TAG, (String)"start!", (Object[])new Object[0]);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (TracePlugin.this.sdkInt < 24 && TracePlugin.this.willUiThreadMonitorRunning(TracePlugin.this.traceConfig) && !UIThreadMonitor.getMonitor().isInit()) {
                    try {
                        UIThreadMonitor.getMonitor().init(TracePlugin.this.traceConfig);
                    }
                    catch (RuntimeException e) {
                        MatrixLog.e((String)TracePlugin.TAG, (String)"[start] RuntimeException:%s", (Object[])new Object[]{e});
                        return;
                    }
                }
                if (TracePlugin.this.traceConfig.isAppMethodBeatEnable()) {
                    AppMethodBeat.getInstance().onStart();
                } else {
                    AppMethodBeat.getInstance().forceStop();
                }
                UIThreadMonitor.getMonitor().onStart();
                if (TracePlugin.this.traceConfig.isAnrTraceEnable()) {
                    TracePlugin.this.looperAnrTracer.onStartTrace();
                }
                if (TracePlugin.this.traceConfig.isIdleHandlerTraceEnable()) {
                    TracePlugin.this.idleHandlerLagTracer = new IdleHandlerLagTracer(TracePlugin.this.traceConfig);
                    TracePlugin.this.idleHandlerLagTracer.onStartTrace();
                }
                if (TracePlugin.this.traceConfig.isTouchEventTraceEnable()) {
                    TracePlugin.this.touchEventLagTracer = new TouchEventLagTracer(TracePlugin.this.traceConfig);
                    TracePlugin.this.touchEventLagTracer.onStartTrace();
                }
                if (TracePlugin.this.traceConfig.isSignalAnrTraceEnable() && !SignalAnrTracer.hasInstance) {
                    TracePlugin.this.signalAnrTracer = new SignalAnrTracer(TracePlugin.this.traceConfig);
                    TracePlugin.this.signalAnrTracer.onStartTrace();
                }
                if (TracePlugin.this.traceConfig.isFPSEnable()) {
                    TracePlugin.this.frameTracer.onStartTrace();
                }
                if (TracePlugin.this.traceConfig.isEvilMethodTraceEnable()) {
                    TracePlugin.this.evilMethodTracer.onStartTrace();
                }
                if (TracePlugin.this.traceConfig.isStartupEnable()) {
                    TracePlugin.this.startupTracer.onStartTrace();
                }
            }
        };
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            MatrixLog.w((String)TAG, (String)"start TracePlugin in Thread[%s] but not in mainThread!", (Object[])new Object[]{Thread.currentThread().getId()});
            MatrixHandlerThread.getDefaultMainHandler().post(runnable);
        }
    }

    public void stop() {
        super.stop();
        if (!this.isSupported()) {
            MatrixLog.w((String)TAG, (String)"[stop] Plugin is unSupported!", (Object[])new Object[0]);
            return;
        }
        MatrixLog.w((String)TAG, (String)"stop!", (Object[])new Object[0]);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                AppMethodBeat.getInstance().onStop();
                UIThreadMonitor.getMonitor().onStop();
                TracePlugin.this.looperAnrTracer.onCloseTrace();
                TracePlugin.this.frameTracer.onCloseTrace();
                TracePlugin.this.evilMethodTracer.onCloseTrace();
                TracePlugin.this.startupTracer.onCloseTrace();
                if (TracePlugin.this.signalAnrTracer != null) {
                    TracePlugin.this.signalAnrTracer.onCloseTrace();
                }
                if (TracePlugin.this.idleHandlerLagTracer != null) {
                    TracePlugin.this.idleHandlerLagTracer.onCloseTrace();
                }
            }
        };
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            runnable.run();
        } else {
            MatrixLog.w((String)TAG, (String)"stop TracePlugin in Thread[%s] but not in mainThread!", (Object[])new Object[]{Thread.currentThread().getId()});
            MatrixHandlerThread.getDefaultMainHandler().post(runnable);
        }
    }

    public void onForeground(boolean isForeground) {
        super.onForeground(isForeground);
        if (!this.isSupported()) {
            return;
        }
        if (this.frameTracer != null) {
            this.frameTracer.onForeground(isForeground);
        }
        if (this.looperAnrTracer != null) {
            this.looperAnrTracer.onForeground(isForeground);
        }
        if (this.evilMethodTracer != null) {
            this.evilMethodTracer.onForeground(isForeground);
        }
        if (this.startupTracer != null) {
            this.startupTracer.onForeground(isForeground);
        }
    }

    private boolean willUiThreadMonitorRunning(TraceConfig traceConfig) {
        return traceConfig.isEvilMethodTraceEnable() || traceConfig.isAnrTraceEnable() || traceConfig.isFPSEnable();
    }

    public void destroy() {
        super.destroy();
    }

    public String getTag() {
        return "Trace";
    }

    public FrameTracer getFrameTracer() {
        return this.frameTracer;
    }

    public AppMethodBeat getAppMethodBeat() {
        return AppMethodBeat.getInstance();
    }

    public LooperAnrTracer getLooperAnrTracer() {
        return this.looperAnrTracer;
    }

    public EvilMethodTracer getEvilMethodTracer() {
        return this.evilMethodTracer;
    }

    public StartupTracer getStartupTracer() {
        return this.startupTracer;
    }

    public UIThreadMonitor getUIThreadMonitor() {
        if (UIThreadMonitor.getMonitor().isInit()) {
            return UIThreadMonitor.getMonitor();
        }
        return null;
    }

    public TraceConfig getTraceConfig() {
        return this.traceConfig;
    }
}

