/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.config;

import com.tencent.matrix.trace.listeners.IDefaultConfig;
import com.tencent.mrs.plugin.IDynamicConfig;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class TraceConfig
implements IDefaultConfig {
    private static final String TAG = "Matrix.TraceConfig";
    public static final int STACK_STYLE_SIMPLE = 0;
    public static final int STACK_STYLE_WHOLE = 1;
    public static final int STACK_STYLE_RAW = 2;
    public IDynamicConfig dynamicConfig;
    public boolean defaultFpsEnable;
    public boolean defaultMethodTraceEnable;
    public boolean defaultStartupEnable;
    public boolean defaultAppMethodBeatEnable = true;
    public boolean defaultAnrEnable;
    public boolean defaultIdleHandlerTraceEnable;
    public int idleHandlerLagThreshold = 2000;
    public int touchEventLagThreshold = 2000;
    public boolean defaultTouchEventTraceEnable;
    public boolean isDebug;
    public boolean isDevEnv;
    public boolean defaultSignalAnrEnable;
    public int stackStyle = 0;
    public String splashActivities;
    public Set<String> splashActivitiesSet;
    public String anrTraceFilePath = "";
    public String printTraceFilePath = "";
    public boolean isHasActivity = true;
    public boolean historyMsgRecorder;
    public boolean denseMsgTracer;

    private TraceConfig() {
    }

    public String toString() {
        StringBuilder ss = new StringBuilder(" \n");
        ss.append("# TraceConfig\n");
        ss.append("* isDebug:\t").append(this.isDebug).append("\n");
        ss.append("* isDevEnv:\t").append(this.isDevEnv).append("\n");
        ss.append("* isHasActivity:\t").append(this.isHasActivity).append("\n");
        ss.append("* defaultFpsEnable:\t").append(this.defaultFpsEnable).append("\n");
        ss.append("* defaultMethodTraceEnable:\t").append(this.defaultMethodTraceEnable).append("\n");
        ss.append("* defaultStartupEnable:\t").append(this.defaultStartupEnable).append("\n");
        ss.append("* defaultAnrEnable:\t").append(this.defaultAnrEnable).append("\n");
        ss.append("* splashActivities:\t").append(this.splashActivities).append("\n");
        ss.append("* historyMsgRecorder:\t").append(this.historyMsgRecorder).append("\n");
        ss.append("* denseMsgTracer:\t").append(this.denseMsgTracer).append("\n");
        return ss.toString();
    }

    @Override
    public boolean isAppMethodBeatEnable() {
        return this.defaultMethodTraceEnable || this.defaultStartupEnable;
    }

    @Override
    public boolean isFPSEnable() {
        return this.defaultFpsEnable;
    }

    @Override
    public boolean isDebug() {
        return this.isDebug;
    }

    @Override
    public boolean isDevEnv() {
        return this.isDevEnv;
    }

    @Override
    public int getLooperPrinterStackStyle() {
        return this.stackStyle;
    }

    @Override
    public boolean isEvilMethodTraceEnable() {
        return this.defaultMethodTraceEnable;
    }

    public boolean isStartupEnable() {
        return this.defaultStartupEnable;
    }

    public boolean isHasActivity() {
        return this.isHasActivity;
    }

    @Override
    public boolean isAnrTraceEnable() {
        return this.defaultAnrEnable;
    }

    @Override
    public boolean isIdleHandlerTraceEnable() {
        return this.defaultIdleHandlerTraceEnable;
    }

    @Override
    public boolean isTouchEventTraceEnable() {
        return this.defaultTouchEventTraceEnable;
    }

    @Override
    public boolean isSignalAnrTraceEnable() {
        return this.defaultSignalAnrEnable;
    }

    @Override
    public String getAnrTraceFilePath() {
        return this.anrTraceFilePath;
    }

    @Override
    public String getPrintTraceFilePath() {
        return this.printTraceFilePath;
    }

    @Override
    public boolean isHistoryMsgRecorderEnable() {
        return this.historyMsgRecorder;
    }

    @Override
    public boolean isDenseMsgTracerEnable() {
        return this.denseMsgTracer;
    }

    public Set<String> getSplashActivities() {
        if (null == this.splashActivitiesSet) {
            this.splashActivitiesSet = new HashSet<String>();
            if (null == this.dynamicConfig) {
                if (null == this.splashActivities) {
                    return this.splashActivitiesSet;
                }
                this.splashActivitiesSet.addAll(Arrays.asList(this.splashActivities.split(";")));
            } else {
                String dySplashActivities = this.dynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_trace_care_scene_set.name(), this.splashActivities);
                if (null != dySplashActivities) {
                    this.splashActivities = dySplashActivities;
                }
                if (null != this.splashActivities) {
                    this.splashActivitiesSet.addAll(Arrays.asList(this.splashActivities.split(";")));
                }
            }
        }
        return this.splashActivitiesSet;
    }

    public int getIdleHandlerLagThreshold() {
        return this.idleHandlerLagThreshold;
    }

    public int getTouchEventLagThreshold() {
        return this.touchEventLagThreshold;
    }

    public int getEvilThresholdMs() {
        return null == this.dynamicConfig ? 700 : this.dynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_trace_evil_method_threshold.name(), 700);
    }

    public int getTimeSliceMs() {
        return null == this.dynamicConfig ? 10000 : this.dynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_trace_fps_time_slice.name(), 10000);
    }

    public int getColdStartupThresholdMs() {
        return null == this.dynamicConfig ? 10000 : this.dynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_trace_app_start_up_threshold.name(), 10000);
    }

    public int getWarmStartupThresholdMs() {
        return null == this.dynamicConfig ? 4000 : this.dynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_trace_warm_app_start_up_threshold.name(), 4000);
    }

    public int getFrozenThreshold() {
        return null == this.dynamicConfig ? 42 : this.dynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_fps_dropped_frozen.name(), 42);
    }

    public int getHighThreshold() {
        return null == this.dynamicConfig ? 24 : this.dynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_fps_dropped_high.name(), 24);
    }

    public int getMiddleThreshold() {
        return null == this.dynamicConfig ? 9 : this.dynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_fps_dropped_middle.name(), 9);
    }

    public int getNormalThreshold() {
        return null == this.dynamicConfig ? 3 : this.dynamicConfig.get(IDynamicConfig.ExptEnum.clicfg_matrix_fps_dropped_normal.name(), 3);
    }

    public static class Builder {
        private final TraceConfig config = new TraceConfig();

        public Builder dynamicConfig(IDynamicConfig dynamicConfig) {
            this.config.dynamicConfig = dynamicConfig;
            return this;
        }

        public Builder enableAppMethodBeat(boolean enable) {
            this.config.defaultAppMethodBeatEnable = enable;
            return this;
        }

        public Builder enableFPS(boolean enable) {
            this.config.defaultFpsEnable = enable;
            return this;
        }

        public Builder enableEvilMethodTrace(boolean enable) {
            this.config.defaultMethodTraceEnable = enable;
            return this;
        }

        public Builder enableAnrTrace(boolean enable) {
            this.config.defaultAnrEnable = enable;
            return this;
        }

        public Builder looperPrinterStackStyle(int stackStyle) {
            this.config.stackStyle = stackStyle;
            return this;
        }

        public Builder enableSignalAnrTrace(boolean enable) {
            this.config.defaultSignalAnrEnable = enable;
            return this;
        }

        public Builder enableStartup(boolean enable) {
            this.config.defaultStartupEnable = enable;
            return this;
        }

        public Builder isDebug(boolean isDebug) {
            this.config.isDebug = isDebug;
            return this;
        }

        public Builder isDevEnv(boolean isDevEnv) {
            this.config.isDevEnv = isDevEnv;
            return this;
        }

        public Builder isHasActivity(boolean isHasActivity) {
            this.config.isHasActivity = isHasActivity;
            return this;
        }

        public Builder splashActivities(String activities) {
            this.config.splashActivities = activities;
            return this;
        }

        public Builder anrTracePath(String anrTraceFilePath) {
            this.config.anrTraceFilePath = anrTraceFilePath;
            return this;
        }

        public Builder printTracePath(String anrTraceFilePath) {
            this.config.printTraceFilePath = anrTraceFilePath;
            return this;
        }

        public Builder enableIdleHandlerTrace(boolean enable) {
            this.config.defaultIdleHandlerTraceEnable = enable;
            return this;
        }

        public Builder setIdleHandlerThreshold(int threshold) {
            this.config.idleHandlerLagThreshold = threshold;
            return this;
        }

        public Builder enableTouchEventTrace(boolean enable) {
            this.config.defaultTouchEventTraceEnable = enable;
            return this;
        }

        public Builder setTouchEventThreshold(int threshold) {
            this.config.touchEventLagThreshold = threshold;
            return this;
        }

        public Builder enableHistoryMsgRecorder(boolean enable) {
            this.config.historyMsgRecorder = enable;
            return this;
        }

        public Builder enableDenseMsgTracer(boolean enable) {
            this.config.denseMsgTracer = enable;
            return this;
        }

        public TraceConfig build() {
            return this.config;
        }
    }
}

