/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.core;

import android.app.Activity;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import com.tencent.matrix.lifecycle.owners.ProcessUILifecycleOwner;
import com.tencent.matrix.trace.core.BeatLifecycle;
import com.tencent.matrix.trace.core.LooperMonitor;
import com.tencent.matrix.trace.hacker.ActivityThreadHacker;
import com.tencent.matrix.trace.listeners.IAppMethodBeatListener;
import com.tencent.matrix.trace.listeners.ILooperListener;
import com.tencent.matrix.trace.util.Utils;
import com.tencent.matrix.util.MatrixHandlerThread;
import com.tencent.matrix.util.MatrixLog;
import java.util.HashSet;
import java.util.Set;

public class AppMethodBeat
implements BeatLifecycle {
    private static final String TAG = "Matrix.AppMethodBeat";
    public static boolean isDev = false;
    private static AppMethodBeat sInstance = new AppMethodBeat();
    private static final int STATUS_DEFAULT = Integer.MAX_VALUE;
    private static final int STATUS_STARTED = 2;
    private static final int STATUS_READY = 1;
    private static final int STATUS_STOPPED = -1;
    private static final int STATUS_EXPIRED_START = -2;
    private static final int STATUS_OUT_RELEASE = -3;
    private static volatile int status = Integer.MAX_VALUE;
    private static final Object statusLock = new Object();
    public static MethodEnterListener sMethodEnterListener;
    private static long[] sBuffer;
    private static int sIndex;
    private static int sLastIndex;
    private static boolean assertIn;
    private static volatile long sCurrentDiffTime;
    private static volatile long sDiffTime;
    private static long sMainThreadId;
    private static HandlerThread sTimerUpdateThread;
    private static Handler sHandler;
    private static final int METHOD_ID_MAX = 1048575;
    public static final int METHOD_ID_DISPATCH = 1048574;
    private static Set<String> sFocusActivitySet;
    private static final HashSet<IAppMethodBeatListener> listeners;
    private static final Object updateTimeLock;
    private static volatile boolean isPauseUpdateTime;
    private static Runnable checkStartExpiredRunnable;
    private static ILooperListener looperMonitorListener;
    private static Runnable realReleaseRunnable;
    private static Runnable sUpdateDiffTimeRunnable;
    private static IndexRecord sIndexRecordHead;

    public static AppMethodBeat getInstance() {
        return sInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        Object object = statusLock;
        synchronized (object) {
            if (status < 2 && status >= -2) {
                sHandler.removeCallbacks(checkStartExpiredRunnable);
                MatrixHandlerThread.getDefaultHandler().removeCallbacks(realReleaseRunnable);
                if (sBuffer == null) {
                    throw new RuntimeException("Matrix.AppMethodBeat sBuffer == null");
                }
                MatrixLog.i((String)TAG, (String)"[onStart] preStatus:%s", (Object[])new Object[]{status, Utils.getStack()});
                status = 2;
            } else {
                MatrixLog.w((String)TAG, (String)"[onStart] current status:%s", (Object[])new Object[]{status});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        Object object = statusLock;
        synchronized (object) {
            if (status == 2) {
                MatrixLog.i((String)TAG, (String)"[onStop] %s", (Object[])new Object[]{Utils.getStack()});
                status = -1;
            } else {
                MatrixLog.w((String)TAG, (String)"[onStop] current status:%s", (Object[])new Object[]{status});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceStop() {
        Object object = statusLock;
        synchronized (object) {
            status = -1;
        }
    }

    @Override
    public boolean isAlive() {
        return status >= 2;
    }

    public static boolean isRealTrace() {
        return status >= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void realRelease() {
        Object object = statusLock;
        synchronized (object) {
            if (status == Integer.MAX_VALUE || status <= 1) {
                MatrixLog.i((String)TAG, (String)"[realRelease] timestamp:%s", (Object[])new Object[]{System.currentTimeMillis()});
                sHandler.removeCallbacksAndMessages(null);
                LooperMonitor.unregister(looperMonitorListener);
                sTimerUpdateThread.quit();
                sBuffer = null;
                status = -3;
            }
        }
    }

    private static void realExecute() {
        MatrixLog.i((String)TAG, (String)"[realExecute] timestamp:%s", (Object[])new Object[]{System.currentTimeMillis()});
        sCurrentDiffTime = SystemClock.uptimeMillis() - sDiffTime;
        sHandler.removeCallbacksAndMessages(null);
        sHandler.postDelayed(sUpdateDiffTimeRunnable, 5L);
        checkStartExpiredRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = statusLock;
                synchronized (object) {
                    MatrixLog.i((String)AppMethodBeat.TAG, (String)"[startExpired] timestamp:%s status:%s", (Object[])new Object[]{System.currentTimeMillis(), status});
                    if (status == Integer.MAX_VALUE || status == 1) {
                        status = -2;
                    }
                }
            }
        };
        sHandler.postDelayed(checkStartExpiredRunnable, 10000L);
        ActivityThreadHacker.hackSysHandlerCallback();
        LooperMonitor.register(looperMonitorListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dispatchBegin() {
        sCurrentDiffTime = SystemClock.uptimeMillis() - sDiffTime;
        isPauseUpdateTime = false;
        Object object = updateTimeLock;
        synchronized (object) {
            updateTimeLock.notify();
        }
    }

    private static void dispatchEnd() {
        isPauseUpdateTime = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void i(int methodId) {
        if (status <= -1) {
            return;
        }
        if (methodId >= 1048575) {
            return;
        }
        if (status == Integer.MAX_VALUE) {
            Object object = statusLock;
            synchronized (object) {
                if (status == Integer.MAX_VALUE) {
                    AppMethodBeat.realExecute();
                    status = 1;
                }
            }
        }
        long threadId = Thread.currentThread().getId();
        if (sMethodEnterListener != null) {
            sMethodEnterListener.enter(methodId, threadId);
        }
        if (threadId == sMainThreadId) {
            if (assertIn) {
                Log.e((String)TAG, (String)"ERROR!!! AppMethodBeat.i Recursive calls!!!");
                return;
            }
            assertIn = true;
            if (sIndex < 1000000) {
                AppMethodBeat.mergeData(methodId, sIndex, true);
            } else {
                sIndex = 0;
                AppMethodBeat.mergeData(methodId, sIndex, true);
            }
            ++sIndex;
            assertIn = false;
        }
    }

    public static void o(int methodId) {
        if (status <= -1) {
            return;
        }
        if (methodId >= 1048575) {
            return;
        }
        if (Thread.currentThread().getId() == sMainThreadId) {
            if (sIndex < 1000000) {
                AppMethodBeat.mergeData(methodId, sIndex, false);
            } else {
                sIndex = 0;
                AppMethodBeat.mergeData(methodId, sIndex, false);
            }
            ++sIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void at(Activity activity, boolean isFocus) {
        String activityName = activity.getClass().getName();
        if (isFocus) {
            if (sFocusActivitySet.add(activityName)) {
                HashSet<IAppMethodBeatListener> hashSet = listeners;
                synchronized (hashSet) {
                    for (IAppMethodBeatListener listener : listeners) {
                        listener.onActivityFocused(activity);
                    }
                }
                MatrixLog.i((String)TAG, (String)"[at] visibleScene[%s] has %s focus!", (Object[])new Object[]{AppMethodBeat.getVisibleScene(), "attach"});
            }
        } else if (sFocusActivitySet.remove(activityName)) {
            MatrixLog.i((String)TAG, (String)"[at] visibleScene[%s] has %s focus!", (Object[])new Object[]{AppMethodBeat.getVisibleScene(), "detach"});
        }
    }

    public static String getVisibleScene() {
        return ProcessUILifecycleOwner.INSTANCE.getVisibleScene();
    }

    private static void mergeData(int methodId, int index, boolean isIn) {
        if (methodId == 1048574) {
            sCurrentDiffTime = SystemClock.uptimeMillis() - sDiffTime;
        }
        try {
            long trueId = 0L;
            if (isIn) {
                trueId |= Long.MIN_VALUE;
            }
            trueId |= (long)methodId << 43;
            AppMethodBeat.sBuffer[index] = trueId |= sCurrentDiffTime & 0x7FFFFFFFFFFL;
            AppMethodBeat.checkPileup(index);
            sLastIndex = index;
        }
        catch (Throwable t) {
            MatrixLog.e((String)TAG, (String)t.getMessage(), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IAppMethodBeatListener listener) {
        HashSet<IAppMethodBeatListener> hashSet = listeners;
        synchronized (hashSet) {
            listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IAppMethodBeatListener listener) {
        HashSet<IAppMethodBeatListener> hashSet = listeners;
        synchronized (hashSet) {
            listeners.remove(listener);
        }
    }

    public IndexRecord maskIndex(String source) {
        if (sIndexRecordHead == null) {
            sIndexRecordHead = new IndexRecord(sIndex - 1);
            AppMethodBeat.sIndexRecordHead.source = source;
            return sIndexRecordHead;
        }
        IndexRecord indexRecord = new IndexRecord(sIndex - 1);
        indexRecord.source = source;
        IndexRecord record = sIndexRecordHead;
        IndexRecord last = null;
        while (record != null) {
            if (indexRecord.index <= record.index) {
                if (null == last) {
                    IndexRecord tmp = sIndexRecordHead;
                    sIndexRecordHead = indexRecord;
                    indexRecord.next = tmp;
                } else {
                    IndexRecord tmp = last.next;
                    last.next = indexRecord;
                    indexRecord.next = tmp;
                }
                return indexRecord;
            }
            last = record;
            record = record.next;
        }
        last.next = indexRecord;
        return indexRecord;
    }

    private static void checkPileup(int index) {
        IndexRecord indexRecord = sIndexRecordHead;
        while (indexRecord != null && (indexRecord.index == index || indexRecord.index == -1 && sLastIndex == 999999)) {
            indexRecord.isValid = false;
            MatrixLog.w((String)TAG, (String)"[checkPileup] %s", (Object[])new Object[]{indexRecord.toString()});
            sIndexRecordHead = indexRecord = indexRecord.next;
        }
    }

    public long[] copyData(IndexRecord startRecord) {
        return this.copyData(startRecord, new IndexRecord(sIndex - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long[] copyData(IndexRecord startRecord, IndexRecord endRecord) {
        long[] length3;
        long[] data;
        long current;
        block8: {
            current = System.currentTimeMillis();
            data = new long[]{};
            if (!startRecord.isValid || !endRecord.isValid) break block8;
            int start = Math.max(0, startRecord.index);
            int end = Math.max(0, endRecord.index);
            if (end > start) {
                int length2 = end - start + 1;
                data = new long[length2];
                System.arraycopy(sBuffer, start, data, 0, length2);
            } else if (end < start) {
                int length3 = 1 + end + (sBuffer.length - start);
                data = new long[length3];
                System.arraycopy(sBuffer, start, data, 0, sBuffer.length - start);
                System.arraycopy(sBuffer, 0, data, sBuffer.length - start, end + 1);
            }
            long[] lArray = data;
            MatrixLog.i((String)TAG, (String)"[copyData] [%s:%s] length:%s cost:%sms", (Object[])new Object[]{Math.max(0, startRecord.index), endRecord.index, data.length, System.currentTimeMillis() - current});
            return lArray;
        }
        try {
            length3 = data;
        }
        catch (Throwable t) {
            long[] lArray;
            try {
                MatrixLog.e((String)TAG, (String)t.toString(), (Object[])new Object[0]);
                lArray = data;
            }
            catch (Throwable throwable) {
                MatrixLog.i((String)TAG, (String)"[copyData] [%s:%s] length:%s cost:%sms", (Object[])new Object[]{Math.max(0, startRecord.index), endRecord.index, data.length, System.currentTimeMillis() - current});
                throw throwable;
            }
            MatrixLog.i((String)TAG, (String)"[copyData] [%s:%s] length:%s cost:%sms", (Object[])new Object[]{Math.max(0, startRecord.index), endRecord.index, data.length, System.currentTimeMillis() - current});
            return lArray;
        }
        MatrixLog.i((String)TAG, (String)"[copyData] [%s:%s] length:%s cost:%sms", (Object[])new Object[]{Math.max(0, startRecord.index), endRecord.index, data.length, System.currentTimeMillis() - current});
        return length3;
    }

    public static long getDiffTime() {
        return sDiffTime;
    }

    public void printIndexRecord() {
        StringBuilder ss = new StringBuilder(" \n");
        IndexRecord record = sIndexRecordHead;
        while (null != record) {
            ss.append(record).append("\n");
            record = record.next;
        }
        MatrixLog.i((String)TAG, (String)"[printIndexRecord] %s", (Object[])new Object[]{ss.toString()});
    }

    static {
        sBuffer = new long[1000000];
        sIndex = 0;
        sLastIndex = -1;
        assertIn = false;
        sDiffTime = sCurrentDiffTime = SystemClock.uptimeMillis();
        sMainThreadId = Looper.getMainLooper().getThread().getId();
        sTimerUpdateThread = MatrixHandlerThread.getNewHandlerThread((String)"matrix_time_update_thread", (int)3);
        sHandler = new Handler(sTimerUpdateThread.getLooper());
        sFocusActivitySet = new HashSet<String>();
        listeners = new HashSet();
        updateTimeLock = new Object();
        isPauseUpdateTime = false;
        checkStartExpiredRunnable = null;
        looperMonitorListener = new ILooperListener(){

            @Override
            public boolean isValid() {
                return status >= 1;
            }

            @Override
            public void onDispatchBegin(String log) {
                AppMethodBeat.dispatchBegin();
            }

            @Override
            public void onDispatchEnd(String log, long beginNs, long endNs) {
                AppMethodBeat.dispatchEnd();
            }
        };
        realReleaseRunnable = new Runnable(){

            @Override
            public void run() {
                AppMethodBeat.realRelease();
            }
        };
        MatrixHandlerThread.getDefaultHandler().postDelayed(realReleaseRunnable, 10000L);
        sUpdateDiffTimeRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    while (true) {
                        if (!isPauseUpdateTime && status > -1) {
                            sCurrentDiffTime = SystemClock.uptimeMillis() - sDiffTime;
                            SystemClock.sleep((long)5L);
                            continue;
                        }
                        Object object = updateTimeLock;
                        synchronized (object) {
                            updateTimeLock.wait();
                        }
                    }
                }
                catch (Exception e) {
                    MatrixLog.e((String)AppMethodBeat.TAG, (String)("" + e.toString()), (Object[])new Object[0]);
                    return;
                }
            }
        };
        sIndexRecordHead = null;
    }

    public static final class IndexRecord {
        public int index;
        private IndexRecord next;
        public boolean isValid = true;
        public String source;

        public IndexRecord(int index) {
            this.index = index;
        }

        public IndexRecord() {
            this.isValid = false;
        }

        public void release() {
            this.isValid = false;
            IndexRecord record = sIndexRecordHead;
            IndexRecord last = null;
            while (null != record) {
                if (record == this) {
                    if (null != last) {
                        last.next = record.next;
                    } else {
                        sIndexRecordHead = record.next;
                    }
                    record.next = null;
                    break;
                }
                last = record;
                record = record.next;
            }
        }

        public String toString() {
            return "index:" + this.index + ",\tisValid:" + this.isValid + " source:" + this.source;
        }
    }

    public static interface MethodEnterListener {
        public void enter(int var1, long var2);
    }
}

