/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.core;

import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import com.tencent.matrix.trace.listeners.ILooperListener;
import com.tencent.matrix.util.MatrixHandlerThread;
import com.tencent.matrix.util.MatrixLog;
import com.tencent.matrix.util.ReflectUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public class LooperMonitor
implements MessageQueue.IdleHandler {
    private static final String TAG = "Matrix.LooperMonitor";
    private static final Map<Looper, LooperMonitor> sLooperMonitorMap = new ConcurrentHashMap<Looper, LooperMonitor>();
    private static final LooperMonitor sMainMonitor = LooperMonitor.of(Looper.getMainLooper());
    private static final HandlerThread historyMsgHandlerThread = MatrixHandlerThread.getNewHandlerThread((String)"historyMsgHandlerThread", (int)5);
    private static final Handler historyMsgHandler = new Handler(historyMsgHandlerThread.getLooper());
    private static final int HISTORY_QUEUE_MAX_SIZE = 200;
    private static final int RECENT_QUEUE_MAX_SIZE = 5000;
    private final Queue<M> anrHistoryMQ = new ConcurrentLinkedQueue<M>();
    private final Queue<M> recentMsgQ = new ConcurrentLinkedQueue<M>();
    private long messageStartTime = 0L;
    private String latestMsgLog = "";
    private long recentMCount = 0L;
    private long recentMDuration = 0L;
    private boolean denseMsgTracer = false;
    private boolean historyMsgRecorder = false;
    @Deprecated
    private final HashSet<LooperDispatchListener> oldListeners = new HashSet();
    private final Map<ILooperListener, DispatchListenerWrapper> listeners = new HashMap<ILooperListener, DispatchListenerWrapper>();
    private LooperPrinter printer;
    private Looper looper;
    private static final long CHECK_TIME = 60000L;
    private long lastCheckPrinterTime = 0L;
    private static boolean isReflectLoggingError = false;

    public static LooperMonitor getMainMonitor() {
        return sMainMonitor;
    }

    public static LooperMonitor of(@NonNull Looper looper) {
        LooperMonitor looperMonitor = sLooperMonitorMap.get(looper);
        if (looperMonitor == null) {
            looperMonitor = new LooperMonitor(looper);
            sLooperMonitorMap.put(looper, looperMonitor);
        }
        return looperMonitor;
    }

    @Deprecated
    static void register(LooperDispatchListener listener) {
        sMainMonitor.addListener(listener);
    }

    @Deprecated
    static void unregister(LooperDispatchListener listener) {
        sMainMonitor.removeListener(listener);
    }

    public static void register(ILooperListener listener) {
        sMainMonitor.addListener(listener);
    }

    public static void unregister(ILooperListener listener) {
        sMainMonitor.removeListener(listener);
    }

    @Deprecated
    public HashSet<LooperDispatchListener> getOldListeners() {
        return this.oldListeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addListener(LooperDispatchListener listener) {
        HashSet<LooperDispatchListener> hashSet = this.oldListeners;
        synchronized (hashSet) {
            this.oldListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeListener(LooperDispatchListener listener) {
        HashSet<LooperDispatchListener> hashSet = this.oldListeners;
        synchronized (hashSet) {
            this.oldListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(ILooperListener listener) {
        Map<ILooperListener, DispatchListenerWrapper> map = this.listeners;
        synchronized (map) {
            DispatchListenerWrapper wrapper = new DispatchListenerWrapper(listener);
            this.listeners.put(listener, wrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(ILooperListener listener) {
        Map<ILooperListener, DispatchListenerWrapper> map = this.listeners;
        synchronized (map) {
            this.listeners.remove(listener);
        }
    }

    private LooperMonitor(Looper looper) {
        Objects.requireNonNull(looper);
        this.looper = looper;
        this.resetPrinter();
        this.addIdleHandler(looper);
    }

    public Looper getLooper() {
        return this.looper;
    }

    public boolean queueIdle() {
        if (SystemClock.uptimeMillis() - this.lastCheckPrinterTime >= 60000L) {
            this.resetPrinter();
            this.lastCheckPrinterTime = SystemClock.uptimeMillis();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onRelease() {
        if (this.printer != null) {
            Object object = this.oldListeners;
            synchronized (object) {
                this.oldListeners.clear();
            }
            object = this.listeners;
            synchronized (object) {
                this.listeners.clear();
            }
            MatrixLog.v((String)TAG, (String)"[onRelease] %s, origin printer:%s", (Object[])new Object[]{this.looper.getThread().getName(), this.printer.origin});
            this.removeIdleHandler(this.looper);
            this.looper.setMessageLogging(this.printer.origin);
            this.looper = null;
            this.printer = null;
        }
    }

    private synchronized void resetPrinter() {
        Printer originPrinter = null;
        try {
            if (!isReflectLoggingError) {
                originPrinter = (Printer)ReflectUtils.get(this.looper.getClass(), (String)"mLogging", (Object)this.looper);
                if (originPrinter == this.printer && null != this.printer) {
                    return;
                }
                if (originPrinter != null && this.printer != null && originPrinter.getClass().getName().equals(this.printer.getClass().getName())) {
                    MatrixLog.w((String)TAG, (String)("LooperPrinter might be loaded by different classloader, my = " + this.printer.getClass().getClassLoader() + ", other = " + originPrinter.getClass().getClassLoader()), (Object[])new Object[0]);
                    return;
                }
            }
        }
        catch (Exception e) {
            isReflectLoggingError = true;
            Log.e((String)TAG, (String)"[resetPrinter] %s", (Throwable)e);
        }
        if (null != this.printer) {
            MatrixLog.w((String)TAG, (String)"maybe thread:%s printer[%s] was replace other[%s]!", (Object[])new Object[]{this.looper.getThread().getName(), this.printer, originPrinter});
        }
        this.printer = new LooperPrinter(originPrinter);
        this.looper.setMessageLogging((Printer)this.printer);
        if (null != originPrinter) {
            MatrixLog.i((String)TAG, (String)"reset printer, originPrinter[%s] in %s", (Object[])new Object[]{originPrinter, this.looper.getThread().getName()});
        }
    }

    private synchronized void removeIdleHandler(Looper looper) {
        if (Build.VERSION.SDK_INT >= 23) {
            looper.getQueue().removeIdleHandler((MessageQueue.IdleHandler)this);
        } else {
            try {
                MessageQueue queue = (MessageQueue)ReflectUtils.get(looper.getClass(), (String)"mQueue", (Object)looper);
                queue.removeIdleHandler((MessageQueue.IdleHandler)this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[removeIdleHandler] %s", (Throwable)e);
            }
        }
    }

    private synchronized void addIdleHandler(Looper looper) {
        if (Build.VERSION.SDK_INT >= 23) {
            looper.getQueue().addIdleHandler((MessageQueue.IdleHandler)this);
        } else {
            try {
                MessageQueue queue = (MessageQueue)ReflectUtils.get(looper.getClass(), (String)"mQueue", (Object)looper);
                queue.addIdleHandler((MessageQueue.IdleHandler)this);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"[removeIdleHandler] %s", (Throwable)e);
            }
        }
    }

    private void recordMsg(final String log, final long duration) {
        historyMsgHandler.post(new Runnable(){

            @Override
            public void run() {
                LooperMonitor.this.enqueueHistoryMQ(new M(log, duration));
            }
        });
        if (this.denseMsgTracer) {
            historyMsgHandler.post(new Runnable(){

                @Override
                public void run() {
                    LooperMonitor.this.enqueueRecentMQ(new M(log, duration));
                }
            });
        }
    }

    private void enqueueRecentMQ(M m) {
        if (this.recentMsgQ.size() == 5000) {
            this.recentMsgQ.poll();
        }
        this.recentMsgQ.offer(m);
        this.recentMDuration += m.d;
    }

    private void enqueueHistoryMQ(M m) {
        if (this.anrHistoryMQ.size() == 200) {
            this.anrHistoryMQ.poll();
        }
        this.anrHistoryMQ.offer(m);
    }

    public Queue<M> getHistoryMQ() {
        this.enqueueHistoryMQ(new M(this.latestMsgLog, System.currentTimeMillis() - this.messageStartTime));
        return this.anrHistoryMQ;
    }

    public Queue<M> getRecentMsgQ() {
        return this.recentMsgQ;
    }

    public void cleanRecentMQ() {
        this.recentMsgQ.clear();
        this.recentMCount = 0L;
        this.recentMDuration = 0L;
    }

    public long getRecentMCount() {
        return this.recentMCount;
    }

    public long getRecentMDuration() {
        return this.recentMDuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(boolean isBegin, String log) {
        if (isBegin) {
            if (this.historyMsgRecorder) {
                this.messageStartTime = System.currentTimeMillis();
                this.latestMsgLog = log;
                ++this.recentMCount;
            }
            Object object = this.oldListeners;
            synchronized (object) {
                for (LooperDispatchListener looperDispatchListener : this.oldListeners) {
                    if (!looperDispatchListener.isValid()) continue;
                    looperDispatchListener.onDispatchStart(log);
                }
            }
            object = this.listeners;
            synchronized (object) {
                for (DispatchListenerWrapper dispatchListenerWrapper : this.listeners.values()) {
                    if (!dispatchListenerWrapper.isValid()) continue;
                    dispatchListenerWrapper.onDispatchBegin(log);
                }
            }
        }
        if (this.historyMsgRecorder) {
            this.recordMsg(log, System.currentTimeMillis() - this.messageStartTime);
        }
        Object object = this.oldListeners;
        synchronized (object) {
            for (LooperDispatchListener looperDispatchListener : this.oldListeners) {
                if (!looperDispatchListener.isValid()) continue;
                looperDispatchListener.onDispatchEnd(log);
            }
        }
        object = this.listeners;
        synchronized (object) {
            for (DispatchListenerWrapper dispatchListenerWrapper : this.listeners.values()) {
                if (!dispatchListenerWrapper.isValid()) continue;
                dispatchListenerWrapper.onDispatchEnd(log);
            }
        }
    }

    public static class M {
        public String l;
        public long d;

        M(String l, long d) {
            this.l = l;
            this.d = d;
        }

        public String toString() {
            return "{" + this.l + " -> " + this.d + '}';
        }
    }

    class LooperPrinter
    implements Printer {
        public Printer origin;
        boolean isHasChecked = false;
        boolean isValid = false;

        LooperPrinter(Printer printer) {
            this.origin = printer;
        }

        public void println(String x) {
            if (null != this.origin) {
                this.origin.println(x);
                if (this.origin == this) {
                    throw new RuntimeException("Matrix.LooperMonitor origin == this");
                }
            }
            if (!this.isHasChecked) {
                this.isValid = x.charAt(0) == '>' || x.charAt(0) == '<';
                this.isHasChecked = true;
                if (!this.isValid) {
                    MatrixLog.e((String)LooperMonitor.TAG, (String)"[println] Printer is inValid! x:%s", (Object[])new Object[]{x});
                }
            }
            if (this.isValid) {
                LooperMonitor.this.dispatch(x.charAt(0) == '>', x);
            }
        }
    }

    private static final class DispatchListenerWrapper {
        private boolean isHasDispatchStart = false;
        private long beginNs;
        private final ILooperListener dispatchListener;

        DispatchListenerWrapper(ILooperListener dispatchListener) {
            this.dispatchListener = dispatchListener;
        }

        public boolean isValid() {
            return this.dispatchListener.isValid();
        }

        public void onDispatchBegin(String x) {
            if (!this.isHasDispatchStart) {
                this.isHasDispatchStart = true;
                this.beginNs = System.nanoTime();
                this.dispatchListener.onDispatchBegin(x);
            }
        }

        public void onDispatchEnd(String x) {
            if (this.isHasDispatchStart) {
                this.isHasDispatchStart = false;
                this.dispatchListener.onDispatchEnd(x, this.beginNs, System.nanoTime());
            }
        }
    }

    @Deprecated
    public static abstract class LooperDispatchListener {
        boolean isHasDispatchStart = false;
        boolean historyMsgRecorder = false;
        boolean denseMsgTracer = false;

        public LooperDispatchListener(boolean historyMsgRecorder, boolean denseMsgTracer) {
            this.historyMsgRecorder = historyMsgRecorder;
            this.denseMsgTracer = denseMsgTracer;
        }

        public LooperDispatchListener() {
        }

        public boolean isValid() {
            return false;
        }

        public void dispatchStart() {
        }

        @CallSuper
        public void onDispatchStart(String x) {
            if (!this.isHasDispatchStart) {
                this.isHasDispatchStart = true;
                this.dispatchStart();
            }
        }

        @CallSuper
        public void onDispatchEnd(String x) {
            if (this.isHasDispatchStart) {
                this.isHasDispatchStart = false;
                this.dispatchEnd();
            }
        }

        public void dispatchEnd() {
        }
    }
}

