/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.core;

import android.os.Build;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Choreographer;
import com.tencent.matrix.AppActiveMatrixDelegate;
import com.tencent.matrix.trace.config.TraceConfig;
import com.tencent.matrix.trace.core.AppMethodBeat;
import com.tencent.matrix.trace.core.BeatLifecycle;
import com.tencent.matrix.trace.core.LooperMonitor;
import com.tencent.matrix.trace.listeners.LooperObserver;
import com.tencent.matrix.trace.util.Utils;
import com.tencent.matrix.util.MatrixLog;
import com.tencent.matrix.util.ReflectUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;

@Deprecated
public class UIThreadMonitor
implements BeatLifecycle,
Runnable {
    private static final String TAG = "Matrix.UIThreadMonitor";
    private static final String ADD_CALLBACK = "addCallbackLocked";
    private volatile boolean isAlive = false;
    private long[] dispatchTimeMs = new long[4];
    private final HashSet<LooperObserver> observers = new HashSet();
    private volatile long token = 0L;
    private boolean isVsyncFrame = false;
    private static final int OLDEST_INPUT_EVENT = 3;
    private static final int NEWEST_INPUT_EVENT = 4;
    public static final int CALLBACK_INPUT = 0;
    public static final int CALLBACK_ANIMATION = 1;
    public static final int CALLBACK_TRAVERSAL = 2;
    public static final int DO_QUEUE_END_ERROR = -100;
    private static final int CALLBACK_LAST = 2;
    private static final UIThreadMonitor sInstance = new UIThreadMonitor();
    private TraceConfig config;
    private Object callbackQueueLock;
    private Object[] callbackQueues;
    private Method addTraversalQueue;
    private Method addInputQueue;
    private Method addAnimationQueue;
    private Choreographer choreographer;
    private Object vsyncReceiver;
    private long frameIntervalNanos = 16666666L;
    private int[] queueStatus = new int[3];
    private boolean[] callbackExist = new boolean[3];
    private long[] queueCost = new long[3];
    private static final int DO_QUEUE_DEFAULT = 0;
    private static final int DO_QUEUE_BEGIN = 1;
    private static final int DO_QUEUE_END = 2;
    private boolean isInit = false;
    private long[] frameInfo = null;

    public static UIThreadMonitor getMonitor() {
        return sInstance;
    }

    public boolean isInit() {
        return this.isInit;
    }

    public void init(TraceConfig config) {
        this.config = config;
        if (Thread.currentThread() != Looper.getMainLooper().getThread()) {
            throw new AssertionError((Object)"must be init in main thread!");
        }
        boolean historyMsgRecorder = config.historyMsgRecorder;
        boolean denseMsgTracer = config.denseMsgTracer;
        LooperMonitor.register(new LooperMonitor.LooperDispatchListener(historyMsgRecorder, denseMsgTracer){

            @Override
            public boolean isValid() {
                return UIThreadMonitor.this.isAlive;
            }

            @Override
            public void dispatchStart() {
                super.dispatchStart();
                UIThreadMonitor.this.dispatchBegin();
            }

            @Override
            public void dispatchEnd() {
                super.dispatchEnd();
                UIThreadMonitor.this.dispatchEnd();
            }
        });
        this.isInit = true;
        this.choreographer = Choreographer.getInstance();
        this.frameIntervalNanos = (Long)ReflectUtils.reflectObject((Object)this.choreographer, (String)"mFrameIntervalNanos", (Object)16666667L);
        this.callbackQueueLock = ReflectUtils.reflectObject((Object)this.choreographer, (String)"mLock", (Object)new Object());
        this.callbackQueues = (Object[])ReflectUtils.reflectObject((Object)this.choreographer, (String)"mCallbackQueues", null);
        if (null != this.callbackQueues) {
            this.addInputQueue = ReflectUtils.reflectMethod((Object)this.callbackQueues[0], (String)ADD_CALLBACK, (Class[])new Class[]{Long.TYPE, Object.class, Object.class});
            this.addAnimationQueue = ReflectUtils.reflectMethod((Object)this.callbackQueues[1], (String)ADD_CALLBACK, (Class[])new Class[]{Long.TYPE, Object.class, Object.class});
            this.addTraversalQueue = ReflectUtils.reflectMethod((Object)this.callbackQueues[2], (String)ADD_CALLBACK, (Class[])new Class[]{Long.TYPE, Object.class, Object.class});
        }
        this.vsyncReceiver = ReflectUtils.reflectObject((Object)this.choreographer, (String)"mDisplayEventReceiver", null);
        MatrixLog.i((String)TAG, (String)"[UIThreadMonitor] %s %s %s %s %s %s frameIntervalNanos:%s", (Object[])new Object[]{this.callbackQueueLock == null, this.callbackQueues == null, this.addInputQueue == null, this.addTraversalQueue == null, this.addAnimationQueue == null, this.vsyncReceiver == null, this.frameIntervalNanos});
        if (config.isDevEnv()) {
            this.addObserver(new LooperObserver(){

                @Override
                public void doFrame(String focusedActivity, long startNs, long endNs, boolean isVsyncFrame, long intendedFrameTimeNs, long inputCostNs, long animationCostNs, long traversalCostNs) {
                    MatrixLog.i((String)UIThreadMonitor.TAG, (String)"focusedActivity[%s] frame cost:%sms isVsyncFrame=%s intendedFrameTimeNs=%s [%s|%s|%s]ns", (Object[])new Object[]{focusedActivity, (endNs - startNs) / 1000000L, isVsyncFrame, intendedFrameTimeNs, inputCostNs, animationCostNs, traversalCostNs});
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void addFrameCallback(int type, Runnable callback, boolean isAddHeader) {
        if (this.callbackExist[type]) {
            MatrixLog.w((String)TAG, (String)"[addFrameCallback] this type %s callback has exist! isAddHeader:%s", (Object[])new Object[]{type, isAddHeader});
            return;
        }
        if (!this.isAlive && type == 0) {
            MatrixLog.w((String)TAG, (String)"[addFrameCallback] UIThreadMonitor is not alive!", (Object[])new Object[0]);
            return;
        }
        try {
            Object object = this.callbackQueueLock;
            synchronized (object) {
                Method method = null;
                switch (type) {
                    case 0: {
                        method = this.addInputQueue;
                        break;
                    }
                    case 1: {
                        method = this.addAnimationQueue;
                        break;
                    }
                    case 2: {
                        method = this.addTraversalQueue;
                    }
                }
                if (null != method) {
                    method.invoke(this.callbackQueues[type], !isAddHeader ? SystemClock.uptimeMillis() : -1L, callback, null);
                    this.callbackExist[type] = true;
                }
            }
        }
        catch (Exception e) {
            MatrixLog.e((String)TAG, (String)e.toString(), (Object[])new Object[0]);
        }
    }

    public long getFrameIntervalNanos() {
        return this.frameIntervalNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(LooperObserver observer) {
        if (!this.isAlive) {
            this.onStart();
        }
        HashSet<LooperObserver> hashSet = this.observers;
        synchronized (hashSet) {
            this.observers.add(observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(LooperObserver observer) {
        HashSet<LooperObserver> hashSet = this.observers;
        synchronized (hashSet) {
            this.observers.remove(observer);
            if (this.observers.isEmpty()) {
                this.onStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchBegin() {
        this.token = this.dispatchTimeMs[0] = System.nanoTime();
        this.dispatchTimeMs[2] = SystemClock.currentThreadTimeMillis();
        if (this.config.isAppMethodBeatEnable()) {
            AppMethodBeat.i(1048574);
        }
        HashSet<LooperObserver> hashSet = this.observers;
        synchronized (hashSet) {
            for (LooperObserver observer : this.observers) {
                if (observer.isDispatchBegin()) continue;
                observer.dispatchBegin(this.dispatchTimeMs[0], this.dispatchTimeMs[2], this.token);
            }
        }
        if (this.config.isDevEnv()) {
            MatrixLog.d((String)TAG, (String)"[dispatchBegin#run] inner cost:%sns", (Object[])new Object[]{System.nanoTime() - this.token});
        }
    }

    private void doFrameBegin(long token) {
        this.isVsyncFrame = true;
    }

    private void doFrameEnd(long token) {
        this.doQueueEnd(2);
        for (int i : this.queueStatus) {
            if (i == 2) continue;
            this.queueCost[i] = -100L;
            if (!this.config.isDevEnv) continue;
            throw new RuntimeException(String.format("UIThreadMonitor happens type[%s] != DO_QUEUE_END", i));
        }
        this.queueStatus = new int[3];
        this.addFrameCallback(0, this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchEnd() {
        long traceBegin = 0L;
        if (this.config.isDevEnv()) {
            traceBegin = System.nanoTime();
        }
        if (this.config.isFPSEnable()) {
            long startNs;
            long intendedFrameTimeNs = startNs = this.token;
            if (this.isVsyncFrame) {
                this.doFrameEnd(this.token);
                intendedFrameTimeNs = this.getIntendedFrameTimeNs(startNs);
            }
            long endNs = System.nanoTime();
            HashSet<LooperObserver> hashSet = this.observers;
            synchronized (hashSet) {
                for (LooperObserver observer : this.observers) {
                    if (!observer.isDispatchBegin()) continue;
                    observer.doFrame(AppActiveMatrixDelegate.INSTANCE.getVisibleScene(), startNs, endNs, this.isVsyncFrame, intendedFrameTimeNs, this.queueCost[0], this.queueCost[1], this.queueCost[2]);
                }
            }
        }
        if (this.config.isEvilMethodTraceEnable() || this.config.isDevEnv()) {
            this.dispatchTimeMs[3] = SystemClock.currentThreadTimeMillis();
            this.dispatchTimeMs[1] = System.nanoTime();
        }
        AppMethodBeat.o(1048574);
        HashSet<LooperObserver> hashSet = this.observers;
        synchronized (hashSet) {
            for (LooperObserver observer : this.observers) {
                if (!observer.isDispatchBegin()) continue;
                observer.dispatchEnd(this.dispatchTimeMs[0], this.dispatchTimeMs[2], this.dispatchTimeMs[1], this.dispatchTimeMs[3], this.token, this.isVsyncFrame);
            }
        }
        this.isVsyncFrame = false;
        if (this.config.isDevEnv()) {
            MatrixLog.d((String)TAG, (String)"[dispatchEnd#run] inner cost:%sns", (Object[])new Object[]{System.nanoTime() - traceBegin});
        }
    }

    private void doQueueBegin(int type) {
        this.queueStatus[type] = 1;
        this.queueCost[type] = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueueEnd(int type) {
        this.queueStatus[type] = 2;
        this.queueCost[type] = System.nanoTime() - this.queueCost[type];
        UIThreadMonitor uIThreadMonitor = this;
        synchronized (uIThreadMonitor) {
            this.callbackExist[type] = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void onStart() {
        if (!this.isInit) {
            MatrixLog.e((String)TAG, (String)"[onStart] is never init.", (Object[])new Object[0]);
            return;
        }
        if (!this.isAlive) {
            this.isAlive = true;
            UIThreadMonitor uIThreadMonitor = this;
            synchronized (uIThreadMonitor) {
                MatrixLog.i((String)TAG, (String)"[onStart] callbackExist:%s %s", (Object[])new Object[]{Arrays.toString(this.callbackExist), Utils.getStack()});
                this.callbackExist = new boolean[3];
            }
            this.queueStatus = new int[3];
            this.queueCost = new long[3];
            this.addFrameCallback(0, this, true);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        long start = System.nanoTime();
        try {
            this.doFrameBegin(this.token);
            this.doQueueBegin(0);
            this.addFrameCallback(1, new Runnable(){

                @Override
                public void run() {
                    UIThreadMonitor.this.doQueueEnd(0);
                    UIThreadMonitor.this.doQueueBegin(1);
                }
            }, true);
            this.addFrameCallback(2, new Runnable(){

                @Override
                public void run() {
                    UIThreadMonitor.this.doQueueEnd(1);
                    UIThreadMonitor.this.doQueueBegin(2);
                }
            }, true);
            if (!this.config.isDevEnv()) return;
        }
        catch (Throwable throwable) {
            if (!this.config.isDevEnv()) throw throwable;
            MatrixLog.d((String)TAG, (String)"[UIThreadMonitor#run] inner cost:%sns", (Object[])new Object[]{System.nanoTime() - start});
            throw throwable;
        }
        MatrixLog.d((String)TAG, (String)"[UIThreadMonitor#run] inner cost:%sns", (Object[])new Object[]{System.nanoTime() - start});
    }

    @Override
    public synchronized void onStop() {
        if (!this.isInit) {
            MatrixLog.e((String)TAG, (String)"[onStart] is never init.", (Object[])new Object[0]);
            return;
        }
        if (this.isAlive) {
            this.isAlive = false;
            MatrixLog.i((String)TAG, (String)"[onStop] callbackExist:%s %s", (Object[])new Object[]{Arrays.toString(this.callbackExist), Utils.getStack()});
        }
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    private long getIntendedFrameTimeNs(long defaultValue) {
        try {
            return (Long)ReflectUtils.reflectObject((Object)this.vsyncReceiver, (String)"mTimestampNanos", (Object)defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            MatrixLog.e((String)TAG, (String)e.toString(), (Object[])new Object[0]);
            return defaultValue;
        }
    }

    public long getQueueCost(int type, long token) {
        if (token != this.token) {
            return -1L;
        }
        return this.queueStatus[type] == 2 ? this.queueCost[type] : 0L;
    }

    public long getInputEventCost() {
        if (Build.VERSION.SDK_INT >= 23) {
            Object obj = ReflectUtils.reflectObject((Object)this.choreographer, (String)"mFrameInfo", null);
            if (null == this.frameInfo) {
                this.frameInfo = (long[])ReflectUtils.reflectObject((Object)obj, (String)"frameInfo", null);
                if (null == this.frameInfo) {
                    this.frameInfo = (long[])ReflectUtils.reflectObject((Object)obj, (String)"mFrameInfo", (Object)new long[9]);
                }
            }
            long start = this.frameInfo[3];
            long end = this.frameInfo[4];
            return end - start;
        }
        return 0L;
    }
}

