/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.tracer;

import android.app.Application;
import android.os.Process;
import com.tencent.matrix.AppActiveMatrixDelegate;
import com.tencent.matrix.Matrix;
import com.tencent.matrix.report.Issue;
import com.tencent.matrix.trace.TracePlugin;
import com.tencent.matrix.trace.config.TraceConfig;
import com.tencent.matrix.trace.constants.Constants;
import com.tencent.matrix.trace.core.AppMethodBeat;
import com.tencent.matrix.trace.core.LooperMonitor;
import com.tencent.matrix.trace.items.MethodItem;
import com.tencent.matrix.trace.listeners.ILooperListener;
import com.tencent.matrix.trace.tracer.Tracer;
import com.tencent.matrix.trace.util.TraceDataUtils;
import com.tencent.matrix.trace.util.Utils;
import com.tencent.matrix.util.DeviceUtil;
import com.tencent.matrix.util.MatrixHandlerThread;
import com.tencent.matrix.util.MatrixLog;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.json.JSONException;
import org.json.JSONObject;

public class EvilMethodTracer
extends Tracer
implements ILooperListener {
    private static final String TAG = "Matrix.EvilMethodTracer";
    private final TraceConfig config;
    private AppMethodBeat.IndexRecord indexRecord;
    private long evilThresholdMs;
    private final boolean isEvilMethodTraceEnable;

    public EvilMethodTracer(TraceConfig config) {
        this.config = config;
        this.evilThresholdMs = config.getEvilThresholdMs();
        this.isEvilMethodTraceEnable = config.isEvilMethodTraceEnable();
    }

    @Override
    public void onAlive() {
        super.onAlive();
        if (this.isEvilMethodTraceEnable) {
            LooperMonitor.register(this);
        }
    }

    @Override
    public void onDead() {
        super.onDead();
        if (this.isEvilMethodTraceEnable) {
            LooperMonitor.unregister(this);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void onDispatchBegin(String log) {
        this.indexRecord = AppMethodBeat.getInstance().maskIndex("EvilMethodTracer#dispatchBegin");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDispatchEnd(String log, long beginNs, long endNs) {
        long dispatchCost = (endNs - beginNs) / 1000000L;
        try {
            if (dispatchCost >= this.evilThresholdMs) {
                long[] data = AppMethodBeat.getInstance().copyData(this.indexRecord);
                String scene = AppActiveMatrixDelegate.INSTANCE.getVisibleScene();
                MatrixHandlerThread.getDefaultHandler().post((Runnable)new AnalyseTask(this.isForeground(), scene, data, dispatchCost, endNs));
            }
        }
        finally {
            this.indexRecord.release();
        }
    }

    public void modifyEvilThresholdMs(long evilThresholdMs) {
        this.evilThresholdMs = evilThresholdMs;
    }

    private static class AnalyseTask
    implements Runnable {
        long[] data;
        long cost;
        long endMs;
        String scene;
        boolean isForeground;

        AnalyseTask(boolean isForeground, String scene, long[] data, long cost, long endMs) {
            this.isForeground = isForeground;
            this.scene = scene;
            this.cost = cost;
            this.data = data;
            this.endMs = endMs;
        }

        void analyse() {
            int[] processStat = Utils.getProcessPriority(Process.myPid());
            LinkedList<MethodItem> stack = new LinkedList<MethodItem>();
            if (this.data.length > 0) {
                TraceDataUtils.structuredDataToStack(this.data, stack, true, this.endMs);
                TraceDataUtils.trimStack(stack, 30, new TraceDataUtils.IStructuredDataFilter(){

                    @Override
                    public boolean isFilter(long during, int filterCount) {
                        return during < (long)filterCount * 5L;
                    }

                    @Override
                    public int getFilterMaxCount() {
                        return 60;
                    }

                    @Override
                    public void fallback(List<MethodItem> stack, int size) {
                        MatrixLog.w((String)EvilMethodTracer.TAG, (String)"[fallback] size:%s targetSize:%s stack:%s", (Object[])new Object[]{size, 30, stack});
                        ListIterator<MethodItem> iterator = stack.listIterator(Math.min(size, 30));
                        while (iterator.hasNext()) {
                            iterator.next();
                            iterator.remove();
                        }
                    }
                });
            }
            StringBuilder reportBuilder = new StringBuilder();
            StringBuilder logcatBuilder = new StringBuilder();
            long stackCost = Math.max(this.cost, TraceDataUtils.stackToString(stack, reportBuilder, logcatBuilder));
            String stackKey = TraceDataUtils.getTreeKey(stack, stackCost);
            MatrixLog.w((String)EvilMethodTracer.TAG, (String)"%s", (Object[])new Object[]{this.printEvil(this.scene, processStat, this.isForeground, logcatBuilder, stack.size(), stackKey, this.cost)});
            try {
                TracePlugin plugin = (TracePlugin)Matrix.with().getPluginByClass(TracePlugin.class);
                if (null == plugin) {
                    return;
                }
                JSONObject jsonObject = new JSONObject();
                DeviceUtil.getDeviceInfo((JSONObject)jsonObject, (Application)Matrix.with().getApplication());
                jsonObject.put("detail", (Object)Constants.Type.NORMAL);
                jsonObject.put("cost", stackCost);
                jsonObject.put("scene", (Object)this.scene);
                jsonObject.put("stack", (Object)reportBuilder.toString());
                jsonObject.put("stackKey", (Object)stackKey);
                Issue issue = new Issue();
                issue.setTag("Trace_EvilMethod");
                issue.setContent(jsonObject);
                plugin.onDetectIssue(issue);
            }
            catch (JSONException e) {
                MatrixLog.e((String)EvilMethodTracer.TAG, (String)"[JSONException error: %s", (Object[])new Object[]{e});
            }
        }

        @Override
        public void run() {
            this.analyse();
        }

        private String printEvil(String scene, int[] processStat, boolean isForeground, StringBuilder stack, long stackSize, String stackKey, long allCost) {
            StringBuilder print = new StringBuilder();
            print.append(String.format("-\n>>>>>>>>>>>>>>>>>>>>> maybe happens Jankiness!(%sms) <<<<<<<<<<<<<<<<<<<<<\n", allCost));
            print.append("|* [Status]").append("\n");
            print.append("|*\t\tScene: ").append(scene).append("\n");
            print.append("|*\t\tForeground: ").append(isForeground).append("\n");
            print.append("|*\t\tPriority: ").append(processStat[0]).append("\tNice: ").append(processStat[1]).append("\n");
            print.append("|*\t\tis64BitRuntime: ").append(DeviceUtil.is64BitRuntime()).append("\n");
            if (stackSize > 0L) {
                print.append("|*\t\tStackKey: ").append(stackKey).append("\n");
                print.append(stack.toString());
            } else {
                print.append(String.format("AppMethodBeat is close[%s].", AppMethodBeat.getInstance().isAlive())).append("\n");
            }
            print.append("=========================================================================");
            return print.toString();
        }
    }
}

