/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.tracer;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.view.FrameMetrics;
import android.view.Window;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.tencent.matrix.Matrix;
import com.tencent.matrix.lifecycle.owners.ProcessUILifecycleOwner;
import com.tencent.matrix.report.Issue;
import com.tencent.matrix.trace.TracePlugin;
import com.tencent.matrix.trace.config.TraceConfig;
import com.tencent.matrix.trace.core.UIThreadMonitor;
import com.tencent.matrix.trace.listeners.IDoFrameListener;
import com.tencent.matrix.trace.listeners.IDropFrameListener;
import com.tencent.matrix.trace.listeners.IFrameListener;
import com.tencent.matrix.trace.listeners.ISceneFrameListener;
import com.tencent.matrix.trace.listeners.LooperObserver;
import com.tencent.matrix.trace.tracer.Tracer;
import com.tencent.matrix.util.DeviceUtil;
import com.tencent.matrix.util.MatrixHandlerThread;
import com.tencent.matrix.util.MatrixLog;
import com.tencent.matrix.util.MatrixUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class FrameTracer
extends Tracer
implements Application.ActivityLifecycleCallbacks {
    private static final String TAG = "Matrix.FrameTracer";
    private static final long HALF_MAX = 0x3FFFFFFFFFFFFFFFL;
    public static final int sdkInt = Build.VERSION.SDK_INT;
    public static float defaultRefreshRate = 60.0f;
    private double droppedSum = 0.0;
    @Deprecated
    private long durationSum = 0L;
    @Deprecated
    private final HashSet<IDoFrameListener> oldListeners = new HashSet();
    @Deprecated
    private long frameIntervalNs;
    @Deprecated
    private LooperObserver looperObserver = new LooperObserver(){

        @Override
        public void doFrame(String focusedActivity, long startNs, long endNs, boolean isVsyncFrame, long intendedFrameTimeNs, long inputCostNs, long animationCostNs, long traversalCostNs) {
            if (FrameTracer.this.isForeground()) {
                this.notifyListener(focusedActivity, startNs, endNs, isVsyncFrame, intendedFrameTimeNs, inputCostNs, animationCostNs, traversalCostNs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Deprecated
        private void notifyListener(final String focusedActivity, final long startNs, final long endNs, final boolean isVsyncFrame, final long intendedFrameTimeNs, final long inputCostNs, final long animationCostNs, final long traversalCostNs) {
            long traceBegin = System.currentTimeMillis();
            try {
                long jitter = endNs - intendedFrameTimeNs;
                final int dropFrame = (int)(jitter / FrameTracer.this.frameIntervalNs);
                if (FrameTracer.this.oldDropFrameListener != null && dropFrame > FrameTracer.this.dropFrameListenerThreshold) {
                    try {
                        if (MatrixUtil.getTopActivityName() != null) {
                            FrameTracer.this.oldDropFrameListener.dropFrame(dropFrame, jitter, MatrixUtil.getTopActivityName());
                        }
                    }
                    catch (Exception e) {
                        MatrixLog.e((String)FrameTracer.TAG, (String)("dropFrameListener error e:" + e.getMessage()), (Object[])new Object[0]);
                    }
                }
                FrameTracer.this.droppedSum = FrameTracer.this.droppedSum + (double)dropFrame;
                FrameTracer.this.durationSum = FrameTracer.this.durationSum + Math.max(jitter, FrameTracer.this.frameIntervalNs);
                HashSet hashSet = FrameTracer.this.oldListeners;
                synchronized (hashSet) {
                    for (final IDoFrameListener listener : FrameTracer.this.oldListeners) {
                        if (FrameTracer.this.config.isDevEnv()) {
                            listener.time = SystemClock.uptimeMillis();
                        }
                        if (null != listener.getExecutor()) {
                            if (listener.getIntervalFrameReplay() > 0) {
                                listener.collect(focusedActivity, startNs, endNs, dropFrame, isVsyncFrame, intendedFrameTimeNs, inputCostNs, animationCostNs, traversalCostNs);
                            } else {
                                listener.getExecutor().execute(new Runnable(){

                                    @Override
                                    public void run() {
                                        listener.doFrameAsync(focusedActivity, startNs, endNs, dropFrame, isVsyncFrame, intendedFrameTimeNs, inputCostNs, animationCostNs, traversalCostNs);
                                    }
                                });
                            }
                        } else {
                            listener.doFrameSync(focusedActivity, startNs, endNs, dropFrame, isVsyncFrame, intendedFrameTimeNs, inputCostNs, animationCostNs, traversalCostNs);
                        }
                        if (!FrameTracer.this.config.isDevEnv()) continue;
                        listener.time = SystemClock.uptimeMillis() - listener.time;
                        MatrixLog.d((String)FrameTracer.TAG, (String)"[notifyListener] cost:%sms listener:%s", (Object[])new Object[]{listener.time, listener});
                    }
                }
            }
            catch (Throwable throwable) {
                long cost = System.currentTimeMillis() - traceBegin;
                if (FrameTracer.this.config.isDebug() && cost > FrameTracer.this.frameIntervalNs) {
                    MatrixLog.w((String)FrameTracer.TAG, (String)"[notifyListener] warm! maybe do heavy work in doFrameSync! size:%s cost:%sms", (Object[])new Object[]{FrameTracer.this.oldListeners.size(), cost});
                }
                throw throwable;
            }
            long cost = System.currentTimeMillis() - traceBegin;
            if (FrameTracer.this.config.isDebug() && cost > FrameTracer.this.frameIntervalNs) {
                MatrixLog.w((String)FrameTracer.TAG, (String)"[notifyListener] warm! maybe do heavy work in doFrameSync! size:%s cost:%sms", (Object[])new Object[]{FrameTracer.this.oldListeners.size(), cost});
            }
        }
    };
    @Deprecated
    private DropFrameListener oldDropFrameListener;
    private IDropFrameListener dropFrameListener;
    private int dropFrameListenerThreshold = 0;
    private final TraceConfig config;
    private final HashSet<IFrameListener> listeners = new HashSet();
    private final long frozenThreshold;
    private final long highThreshold;
    private final long middleThreshold;
    private final long normalThreshold;
    SceneFrameCollector sceneFrameCollector;
    private final Map<Integer, Window.OnFrameMetricsAvailableListener> frameListenerMap = new ConcurrentHashMap<Integer, Window.OnFrameMetricsAvailableListener>();

    public FrameTracer(TraceConfig config) {
        this.config = config;
        this.frameIntervalNs = UIThreadMonitor.getMonitor().getFrameIntervalNanos();
        this.frozenThreshold = config.getFrozenThreshold();
        this.highThreshold = config.getHighThreshold();
        this.normalThreshold = config.getNormalThreshold();
        this.middleThreshold = config.getMiddleThreshold();
        MatrixLog.i((String)TAG, (String)"[init] frameIntervalMs:%s isFPSEnable:%s", (Object[])new Object[]{this.frameIntervalNs, config.isFPSEnable()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addListener(IDoFrameListener listener) {
        HashSet<IDoFrameListener> hashSet = this.oldListeners;
        synchronized (hashSet) {
            this.oldListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removeListener(IDoFrameListener listener) {
        HashSet<IDoFrameListener> hashSet = this.oldListeners;
        synchronized (hashSet) {
            this.oldListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=24)
    public void addListener(IFrameListener listener) {
        HashSet<IFrameListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresApi(value=24)
    public void removeListener(IFrameListener listener) {
        HashSet<IFrameListener> hashSet = this.listeners;
        synchronized (hashSet) {
            this.listeners.remove(listener);
        }
    }

    @RequiresApi(value=24)
    public void register(ISceneFrameListener listener) {
        if (this.sceneFrameCollector != null) {
            this.sceneFrameCollector.register(listener);
        }
    }

    @RequiresApi(value=24)
    public void unregister(ISceneFrameListener listener, boolean isCallbackRestAfterUnregister) {
        if (this.sceneFrameCollector != null) {
            this.sceneFrameCollector.unregister(listener, isCallbackRestAfterUnregister);
        }
    }

    @RequiresApi(value=24)
    public void unregister(ISceneFrameListener listener) {
        this.unregister(listener, false);
    }

    @RequiresApi(value=24)
    public void reset(ISceneFrameListener listener, boolean isCallbackRestBeforeReset) {
        if (this.sceneFrameCollector != null) {
            this.sceneFrameCollector.reset(listener, isCallbackRestBeforeReset);
        }
    }

    @RequiresApi(value=24)
    public void reset(ISceneFrameListener listener) {
        this.unregister(listener, false);
    }

    @Override
    public void onAlive() {
        super.onAlive();
        if (this.config.isFPSEnable()) {
            this.forceEnable();
        }
    }

    public void forceEnable() {
        MatrixLog.i((String)TAG, (String)"forceEnable", (Object[])new Object[0]);
        if (sdkInt >= 24) {
            Matrix.with().getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.sceneFrameCollector = new SceneFrameCollector();
            this.addListener(this.sceneFrameCollector);
            this.register(new AllSceneFrameListener());
        } else {
            UIThreadMonitor.getMonitor().addObserver(this.looperObserver);
        }
    }

    public void forceDisable() {
        MatrixLog.i((String)TAG, (String)"forceDisable", (Object[])new Object[0]);
        this.removeDropFrameListener();
        if (sdkInt >= 24) {
            Matrix.with().getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
            this.listeners.clear();
            this.frameListenerMap.clear();
        } else {
            UIThreadMonitor.getMonitor().removeObserver(this.looperObserver);
            this.oldListeners.clear();
        }
    }

    @Override
    public void onDead() {
        super.onDead();
        if (this.config.isFPSEnable()) {
            this.forceDisable();
        }
    }

    public int getDroppedSum() {
        return (int)this.droppedSum;
    }

    @Deprecated
    public long getDurationSum() {
        return this.durationSum;
    }

    @Deprecated
    public void addDropFrameListener(int dropFrameListenerThreshold, DropFrameListener dropFrameListener) {
        this.oldDropFrameListener = dropFrameListener;
        this.dropFrameListenerThreshold = dropFrameListenerThreshold;
    }

    public void setDropFrameListener(int dropFrameListenerThreshold, IDropFrameListener dropFrameListener) {
        this.dropFrameListener = dropFrameListener;
        this.dropFrameListenerThreshold = dropFrameListenerThreshold;
    }

    public void removeDropFrameListener() {
        this.oldDropFrameListener = null;
        this.dropFrameListener = null;
    }

    @RequiresApi(value=24)
    public static String metricsToString(FrameMetrics frameMetrics) {
        StringBuilder sb = new StringBuilder();
        sb.append("{unknown_delay_duration=").append(frameMetrics.getMetric(0));
        sb.append("; input_handling_duration=").append(frameMetrics.getMetric(1));
        sb.append("; animation_duration=").append(frameMetrics.getMetric(2));
        sb.append("; layout_measure_duration=").append(frameMetrics.getMetric(3));
        sb.append("; draw_duration=").append(frameMetrics.getMetric(4));
        sb.append("; sync_duration=").append(frameMetrics.getMetric(5));
        sb.append("; command_issue_duration=").append(frameMetrics.getMetric(6));
        sb.append("; swap_buffers_duration=").append(frameMetrics.getMetric(7));
        sb.append("; total_duration=").append(frameMetrics.getMetric(8));
        sb.append("; first_draw_frame=").append(frameMetrics.getMetric(9));
        if (sdkInt >= 31) {
            sb.append("; gpu_duration=").append(frameMetrics.getMetric(12));
        }
        sb.append("}");
        return sb.toString();
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
    }

    private float getRefreshRate(Window window) {
        if (sdkInt >= 30) {
            return window.getContext().getDisplay().getRefreshRate();
        }
        return window.getWindowManager().getDefaultDisplay().getRefreshRate();
    }

    @RequiresApi(value=24)
    public void onActivityResumed(Activity activity) {
        if (this.frameListenerMap.containsKey(activity.hashCode())) {
            return;
        }
        defaultRefreshRate = this.getRefreshRate(activity.getWindow());
        MatrixLog.i((String)TAG, (String)"default refresh rate is %dHz", (Object[])new Object[]{(int)defaultRefreshRate});
        Window.OnFrameMetricsAvailableListener onFrameMetricsAvailableListener = new Window.OnFrameMetricsAvailableListener(){
            private float cachedRefreshRate = defaultRefreshRate;
            private float cachedThreshold = (float)FrameTracer.access$200(FrameTracer.this) / 60.0f * this.cachedRefreshRate;
            private int lastModeId = -1;
            private int lastThreshold = -1;
            private WindowManager.LayoutParams attributes = null;

            private void updateRefreshRate(Window window) {
                if (this.attributes == null) {
                    this.attributes = window.getAttributes();
                }
                if (this.attributes.preferredDisplayModeId != this.lastModeId || this.lastThreshold != FrameTracer.this.dropFrameListenerThreshold) {
                    this.lastModeId = this.attributes.preferredDisplayModeId;
                    this.lastThreshold = FrameTracer.this.dropFrameListenerThreshold;
                    this.cachedRefreshRate = FrameTracer.this.getRefreshRate(window);
                    this.cachedThreshold = (float)FrameTracer.this.dropFrameListenerThreshold / 60.0f * this.cachedRefreshRate;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @RequiresApi(api=26)
            public void onFrameMetricsAvailable(Window window, FrameMetrics frameMetrics, int dropCountSinceLastInvocation) {
                if (FrameTracer.this.isForeground()) {
                    for (int i = FrameDuration.UNKNOWN_DELAY_DURATION.ordinal(); i <= FrameDuration.TOTAL_DURATION.ordinal(); ++i) {
                        long v = frameMetrics.getMetric(FrameDuration.indices[i]);
                        if (v >= 0L && v < 0x3FFFFFFFFFFFFFFFL) continue;
                        return;
                    }
                    FrameMetrics frameMetricsCopy = new FrameMetrics(frameMetrics);
                    this.updateRefreshRate(window);
                    long totalDuration = frameMetricsCopy.getMetric(8);
                    float frameIntervalNanos = 1.0E9f / this.cachedRefreshRate;
                    float droppedFrames = Math.max(0.0f, ((float)totalDuration - frameIntervalNanos) / frameIntervalNanos);
                    FrameTracer.this.droppedSum = FrameTracer.this.droppedSum + (double)droppedFrames;
                    if (FrameTracer.this.dropFrameListener != null && droppedFrames >= this.cachedThreshold) {
                        FrameTracer.this.dropFrameListener.onFrameMetricsAvailable(ProcessUILifecycleOwner.INSTANCE.getVisibleScene(), frameMetricsCopy, droppedFrames, this.cachedRefreshRate);
                    }
                    HashSet hashSet = FrameTracer.this.listeners;
                    synchronized (hashSet) {
                        for (IFrameListener observer : FrameTracer.this.listeners) {
                            observer.onFrameMetricsAvailable(ProcessUILifecycleOwner.INSTANCE.getVisibleScene(), frameMetricsCopy, droppedFrames, this.cachedRefreshRate);
                        }
                    }
                }
            }
        };
        this.frameListenerMap.put(activity.hashCode(), onFrameMetricsAvailableListener);
        activity.getWindow().addOnFrameMetricsAvailableListener(onFrameMetricsAvailableListener, MatrixHandlerThread.getDefaultHandler());
        MatrixLog.i((String)TAG, (String)"onActivityResumed addOnFrameMetricsAvailableListener", (Object[])new Object[0]);
    }

    @RequiresApi(value=24)
    public void onActivityPaused(Activity activity) {
        this.sceneFrameCollector.resetAllAndCallBack();
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    @RequiresApi(value=24)
    public void onActivityDestroyed(Activity activity) {
        try {
            activity.getWindow().removeOnFrameMetricsAvailableListener(this.frameListenerMap.remove(activity.hashCode()));
        }
        catch (Throwable t) {
            MatrixLog.e((String)TAG, (String)("removeOnFrameMetricsAvailableListener error : " + t.getMessage()), (Object[])new Object[0]);
        }
    }

    @RequiresApi(value=24)
    static class AllSceneFrameListener
    implements ISceneFrameListener {
        private static final String TAG = "AllSceneFrameListener";

        AllSceneFrameListener() {
        }

        @Override
        public int getIntervalMs() {
            return 10000;
        }

        @Override
        public String getName() {
            return null;
        }

        @Override
        public boolean skipFirstFrame() {
            return false;
        }

        @Override
        public int getThreshold() {
            return 0;
        }

        @Override
        public void onFrameMetricsAvailable(@NonNull String sceneName, long[] avgDurations, int[] dropLevel, int[] dropSum, float avgDroppedFrame, float avgRefreshRate, float avgFps) {
            MatrixLog.i((String)TAG, (String)"[report] FPS:%s %s", (Object[])new Object[]{Float.valueOf(avgFps), this.toString()});
            try {
                TracePlugin plugin = (TracePlugin)Matrix.with().getPluginByClass(TracePlugin.class);
                if (null == plugin) {
                    return;
                }
                JSONObject dropLevelObject = new JSONObject();
                JSONObject dropSumObject = new JSONObject();
                for (DropStatus dropStatus : DropStatus.values()) {
                    dropLevelObject.put(dropStatus.name(), dropLevel[dropStatus.ordinal()]);
                    dropSumObject.put(dropStatus.name(), dropSum[dropStatus.ordinal()]);
                }
                JSONObject resultObject = new JSONObject();
                DeviceUtil.getDeviceInfo((JSONObject)resultObject, (Application)plugin.getApplication());
                resultObject.put("scene", (Object)sceneName);
                resultObject.put("dropLevel", (Object)dropLevelObject);
                resultObject.put("dropSum", (Object)dropSumObject);
                resultObject.put("fps", (double)avgFps);
                for (FrameDuration frameDuration : FrameDuration.values()) {
                    resultObject.put(frameDuration.name(), avgDurations[frameDuration.ordinal()]);
                    if (frameDuration.equals((Object)FrameDuration.TOTAL_DURATION)) break;
                }
                if (sdkInt >= 31) {
                    resultObject.put("GPU_DURATION", avgDurations[FrameDuration.GPU_DURATION.ordinal()]);
                }
                resultObject.put("DROP_COUNT", Math.round(avgDroppedFrame));
                resultObject.put("REFRESH_RATE", (int)avgRefreshRate);
                Issue issue = new Issue();
                issue.setTag("Trace_FPS");
                issue.setContent(resultObject);
                plugin.onDetectIssue(issue);
            }
            catch (JSONException e) {
                MatrixLog.e((String)TAG, (String)"json error", (Object[])new Object[]{e});
            }
        }
    }

    @Deprecated
    public static interface DropFrameListener {
        public void dropFrame(int var1, long var2, String var4);
    }

    @RequiresApi(value=24)
    private class SceneFrameCollectItem {
        private final long[] durations = new long[FrameDuration.values().length];
        private final int[] dropLevel = new int[DropStatus.values().length];
        private final int[] dropSum = new int[DropStatus.values().length];
        private float dropCount;
        private float refreshRate;
        private float totalDuration;
        private long beginMs;
        private String lastScene;
        private int count = 0;
        ISceneFrameListener listener;

        SceneFrameCollectItem(ISceneFrameListener listener) {
            this.listener = listener;
        }

        public void append(String scene, FrameMetrics frameMetrics, float droppedFrames, float refreshRate) {
            if (this.listener.skipFirstFrame() && frameMetrics.getMetric(9) == 1L || droppedFrames < refreshRate / 60.0f * (float)this.listener.getThreshold()) {
                return;
            }
            if (this.count == 0) {
                this.beginMs = SystemClock.uptimeMillis();
            }
            for (int i = FrameDuration.UNKNOWN_DELAY_DURATION.ordinal(); i <= FrameDuration.TOTAL_DURATION.ordinal(); ++i) {
                int n = i;
                this.durations[n] = this.durations[n] + frameMetrics.getMetric(FrameDuration.indices[i]);
            }
            if (sdkInt >= 31) {
                int n = FrameDuration.GPU_DURATION.ordinal();
                this.durations[n] = this.durations[n] + frameMetrics.getMetric(12);
            }
            this.dropCount += droppedFrames;
            this.collect(Math.round(droppedFrames));
            this.refreshRate += refreshRate;
            float frameIntervalNanos = 1.0E9f / refreshRate;
            this.totalDuration += Math.max((float)frameMetrics.getMetric(8), frameIntervalNanos);
            ++this.count;
            this.lastScene = scene;
            if (SystemClock.uptimeMillis() - this.beginMs >= (long)this.listener.getIntervalMs()) {
                this.tryCallBackAndReset();
            }
        }

        void tryCallBackAndReset() {
            if (this.count > 20) {
                this.dropCount /= (float)this.count;
                this.refreshRate /= (float)this.count;
                this.totalDuration /= (float)this.count;
                int i = 0;
                while (i < this.durations.length) {
                    int n = i++;
                    this.durations[n] = this.durations[n] / (long)this.count;
                }
                this.listener.onFrameMetricsAvailable(this.lastScene, this.durations, this.dropLevel, this.dropSum, this.dropCount, this.refreshRate, 1.0E9f / this.totalDuration);
            }
            this.reset();
        }

        private void collect(int droppedFrames) {
            if ((long)droppedFrames >= FrameTracer.this.frozenThreshold) {
                int n = DropStatus.DROPPED_FROZEN.ordinal();
                this.dropLevel[n] = this.dropLevel[n] + 1;
                int n2 = DropStatus.DROPPED_FROZEN.ordinal();
                this.dropSum[n2] = this.dropSum[n2] + droppedFrames;
            } else if ((long)droppedFrames >= FrameTracer.this.highThreshold) {
                int n = DropStatus.DROPPED_HIGH.ordinal();
                this.dropLevel[n] = this.dropLevel[n] + 1;
                int n3 = DropStatus.DROPPED_HIGH.ordinal();
                this.dropSum[n3] = this.dropSum[n3] + droppedFrames;
            } else if ((long)droppedFrames >= FrameTracer.this.middleThreshold) {
                int n = DropStatus.DROPPED_MIDDLE.ordinal();
                this.dropLevel[n] = this.dropLevel[n] + 1;
                int n4 = DropStatus.DROPPED_MIDDLE.ordinal();
                this.dropSum[n4] = this.dropSum[n4] + droppedFrames;
            } else if ((long)droppedFrames >= FrameTracer.this.normalThreshold) {
                int n = DropStatus.DROPPED_NORMAL.ordinal();
                this.dropLevel[n] = this.dropLevel[n] + 1;
                int n5 = DropStatus.DROPPED_NORMAL.ordinal();
                this.dropSum[n5] = this.dropSum[n5] + droppedFrames;
            } else {
                int n = DropStatus.DROPPED_BEST.ordinal();
                this.dropLevel[n] = this.dropLevel[n] + 1;
                int n6 = DropStatus.DROPPED_BEST.ordinal();
                this.dropSum[n6] = this.dropSum[n6] + Math.max(droppedFrames, 0);
            }
        }

        private void reset() {
            this.dropCount = 0.0f;
            this.refreshRate = 0.0f;
            this.totalDuration = 0.0f;
            this.count = 0;
            Arrays.fill(this.durations, 0L);
            Arrays.fill(this.dropLevel, 0);
            Arrays.fill(this.dropSum, 0);
        }
    }

    public static enum FrameDuration {
        UNKNOWN_DELAY_DURATION,
        INPUT_HANDLING_DURATION,
        ANIMATION_DURATION,
        LAYOUT_MEASURE_DURATION,
        DRAW_DURATION,
        SYNC_DURATION,
        COMMAND_ISSUE_DURATION,
        SWAP_BUFFERS_DURATION,
        TOTAL_DURATION,
        GPU_DURATION;

        @SuppressLint(value={"InlinedApi"})
        static final int[] indices;

        public static String stringify(long[] durations) {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            for (FrameDuration item : FrameDuration.values()) {
                sb.append(item.name()).append('=').append(durations[item.ordinal()]).append("; ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("}");
            return sb.toString();
        }

        static {
            indices = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 12};
        }
    }

    public static enum DropStatus {
        DROPPED_BEST,
        DROPPED_NORMAL,
        DROPPED_MIDDLE,
        DROPPED_HIGH,
        DROPPED_FROZEN;


        public static String stringify(int[] level, int[] sum) {
            StringBuilder sb = new StringBuilder();
            sb.append('{');
            for (DropStatus item : DropStatus.values()) {
                sb.append('(').append(item.name()).append("_LEVEL=").append(level[item.ordinal()]).append(" ");
                sb.append(item.name()).append("_SUM=").append(sum[item.ordinal()]).append("); ");
            }
            sb.setLength(sb.length() - 2);
            sb.append("}");
            return sb.toString();
        }
    }

    @RequiresApi(value=24)
    private class SceneFrameCollector
    implements IFrameListener {
        private final Handler frameHandler = new Handler(MatrixHandlerThread.getDefaultHandlerThread().getLooper());
        private final HashMap<String, SceneFrameCollectItem> specifiedSceneMap = new HashMap();
        private final HashMap<ISceneFrameListener, SceneFrameCollectItem> unspecifiedSceneMap = new HashMap();

        private SceneFrameCollector() {
        }

        public synchronized void register(@NonNull ISceneFrameListener listener) {
            if (listener.getIntervalMs() < 1 || listener.getThreshold() < 0) {
                MatrixLog.e((String)FrameTracer.TAG, (String)"Illegal value, intervalMs=%d, threshold=%d, activity=%s", (Object[])new Object[]{listener.getIntervalMs(), listener.getThreshold(), listener.getClass().getName()});
                return;
            }
            String scene = listener.getName();
            SceneFrameCollectItem collectItem = new SceneFrameCollectItem(listener);
            if (scene == null || scene.isEmpty()) {
                this.unspecifiedSceneMap.put(listener, collectItem);
            } else {
                this.specifiedSceneMap.put(scene, collectItem);
            }
        }

        public synchronized void unregister(@NonNull ISceneFrameListener listener, boolean isCallbackRestAfterUnregister) {
            SceneFrameCollectItem target;
            String scene = listener.getName();
            SceneFrameCollectItem sceneFrameCollectItem = target = scene == null || scene.isEmpty() ? this.unspecifiedSceneMap.remove(listener) : this.specifiedSceneMap.remove(scene);
            if (target != null && isCallbackRestAfterUnregister) {
                this.frameHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        target.tryCallBackAndReset();
                    }
                });
            }
        }

        public synchronized void reset(ISceneFrameListener listener, boolean isCallbackRestBeforeReset) {
            SceneFrameCollectItem target;
            String scene = listener.getName();
            SceneFrameCollectItem sceneFrameCollectItem = target = scene == null || scene.isEmpty() ? this.unspecifiedSceneMap.get(listener) : this.specifiedSceneMap.get(scene);
            if (target != null && isCallbackRestBeforeReset) {
                target.tryCallBackAndReset();
            }
        }

        public synchronized void resetAllAndCallBack() {
            for (SceneFrameCollectItem value : this.unspecifiedSceneMap.values()) {
                value.tryCallBackAndReset();
            }
            for (SceneFrameCollectItem value : this.specifiedSceneMap.values()) {
                value.tryCallBackAndReset();
            }
        }

        @Override
        public void onFrameMetricsAvailable(final String sceneName, final FrameMetrics frameMetrics, final float droppedFrames, final float refreshRate) {
            this.frameHandler.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String scene = sceneName.getClass().getName();
                    SceneFrameCollector sceneFrameCollector = SceneFrameCollector.this;
                    synchronized (sceneFrameCollector) {
                        SceneFrameCollectItem collectItem = (SceneFrameCollectItem)SceneFrameCollector.this.specifiedSceneMap.get(scene);
                        if (collectItem != null) {
                            collectItem.append(sceneName, frameMetrics, droppedFrames, refreshRate);
                        }
                        for (SceneFrameCollectItem frameCollectItem : SceneFrameCollector.this.unspecifiedSceneMap.values()) {
                            frameCollectItem.append(sceneName, frameMetrics, droppedFrames, refreshRate);
                        }
                    }
                }
            });
        }
    }
}

