/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.tracer;

import android.app.Application;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.MessageQueue;
import androidx.annotation.Nullable;
import com.tencent.matrix.AppActiveMatrixDelegate;
import com.tencent.matrix.Matrix;
import com.tencent.matrix.report.Issue;
import com.tencent.matrix.trace.TracePlugin;
import com.tencent.matrix.trace.config.TraceConfig;
import com.tencent.matrix.trace.constants.Constants;
import com.tencent.matrix.trace.tracer.Tracer;
import com.tencent.matrix.trace.util.AppForegroundUtil;
import com.tencent.matrix.trace.util.Utils;
import com.tencent.matrix.util.DeviceUtil;
import com.tencent.matrix.util.MatrixLog;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONObject;

public class IdleHandlerLagTracer
extends Tracer {
    private static final String TAG = "Matrix.IdleHandlerLagTracer";
    private static TraceConfig traceConfig;
    private static HandlerThread idleHandlerLagHandlerThread;
    private static Handler idleHandlerLagHandler;
    private static Runnable idleHandlerLagRunnable;

    public IdleHandlerLagTracer(TraceConfig config) {
        traceConfig = config;
    }

    @Override
    public void onAlive() {
        super.onAlive();
        if (traceConfig.isIdleHandlerTraceEnable()) {
            idleHandlerLagHandlerThread = new HandlerThread("IdleHandlerLagThread");
            idleHandlerLagRunnable = new IdleHandlerLagRunable();
            IdleHandlerLagTracer.detectIdleHandler();
        }
    }

    @Override
    public void onDead() {
        super.onDead();
        if (traceConfig.isIdleHandlerTraceEnable()) {
            idleHandlerLagHandler.removeCallbacksAndMessages(null);
        }
    }

    private static void detectIdleHandler() {
        try {
            if (Build.VERSION.SDK_INT < 23) {
                return;
            }
            MessageQueue mainQueue = Looper.getMainLooper().getQueue();
            Field field = MessageQueue.class.getDeclaredField("mIdleHandlers");
            field.setAccessible(true);
            MyArrayList myIdleHandlerArrayList = new MyArrayList();
            field.set(mainQueue, myIdleHandlerArrayList);
            idleHandlerLagHandlerThread.start();
            idleHandlerLagHandler = new Handler(idleHandlerLagHandlerThread.getLooper());
        }
        catch (Throwable t) {
            MatrixLog.e((String)TAG, (String)("reflect idle handler error = " + t.getMessage()), (Object[])new Object[0]);
        }
    }

    static class MyArrayList<T>
    extends ArrayList {
        Map<MessageQueue.IdleHandler, MyIdleHandler> map = new HashMap<MessageQueue.IdleHandler, MyIdleHandler>();

        MyArrayList() {
        }

        @Override
        public boolean add(Object o) {
            if (o instanceof MessageQueue.IdleHandler) {
                MyIdleHandler myIdleHandler = new MyIdleHandler((MessageQueue.IdleHandler)o);
                this.map.put((MessageQueue.IdleHandler)o, myIdleHandler);
                return super.add(myIdleHandler);
            }
            return super.add(o);
        }

        @Override
        public boolean remove(@Nullable Object o) {
            if (o instanceof MyIdleHandler) {
                MessageQueue.IdleHandler idleHandler = ((MyIdleHandler)o).idleHandler;
                this.map.remove(idleHandler);
                return super.remove(o);
            }
            MyIdleHandler myIdleHandler = this.map.remove(o);
            if (myIdleHandler != null) {
                return super.remove(myIdleHandler);
            }
            return super.remove(o);
        }
    }

    static class MyIdleHandler
    implements MessageQueue.IdleHandler {
        private final MessageQueue.IdleHandler idleHandler;

        MyIdleHandler(MessageQueue.IdleHandler idleHandler) {
            this.idleHandler = idleHandler;
        }

        public boolean queueIdle() {
            idleHandlerLagHandler.postDelayed(idleHandlerLagRunnable, (long)traceConfig.idleHandlerLagThreshold);
            boolean ret = this.idleHandler.queueIdle();
            idleHandlerLagHandler.removeCallbacks(idleHandlerLagRunnable);
            return ret;
        }
    }

    static class IdleHandlerLagRunable
    implements Runnable {
        IdleHandlerLagRunable() {
        }

        @Override
        public void run() {
            try {
                TracePlugin plugin = (TracePlugin)Matrix.with().getPluginByClass(TracePlugin.class);
                if (null == plugin) {
                    return;
                }
                String stackTrace = Utils.getMainThreadJavaStackTrace();
                boolean currentForeground = AppForegroundUtil.isInterestingToUser();
                String scene = AppActiveMatrixDelegate.INSTANCE.getVisibleScene();
                JSONObject jsonObject = new JSONObject();
                DeviceUtil.getDeviceInfo((JSONObject)jsonObject, (Application)Matrix.with().getApplication());
                jsonObject.put("detail", (Object)Constants.Type.LAG_IDLE_HANDLER);
                jsonObject.put("scene", (Object)scene);
                jsonObject.put("threadStack", (Object)stackTrace);
                jsonObject.put("isProcessForeground", currentForeground);
                Issue issue = new Issue();
                issue.setTag("Trace_EvilMethod");
                issue.setContent(jsonObject);
                plugin.onDetectIssue(issue);
                MatrixLog.e((String)IdleHandlerLagTracer.TAG, (String)"happens idle handler Lag : %s ", (Object[])new Object[]{jsonObject.toString()});
            }
            catch (Throwable t) {
                MatrixLog.e((String)IdleHandlerLagTracer.TAG, (String)("Matrix error, error = " + t.getMessage()), (Object[])new Object[0]);
            }
        }
    }
}

