/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.tracer;

import android.app.Application;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import com.tencent.matrix.AppActiveMatrixDelegate;
import com.tencent.matrix.Matrix;
import com.tencent.matrix.report.Issue;
import com.tencent.matrix.trace.TracePlugin;
import com.tencent.matrix.trace.config.TraceConfig;
import com.tencent.matrix.trace.constants.Constants;
import com.tencent.matrix.trace.core.AppMethodBeat;
import com.tencent.matrix.trace.core.LooperMonitor;
import com.tencent.matrix.trace.items.MethodItem;
import com.tencent.matrix.trace.listeners.ILooperListener;
import com.tencent.matrix.trace.tracer.Tracer;
import com.tencent.matrix.trace.util.TraceDataUtils;
import com.tencent.matrix.trace.util.Utils;
import com.tencent.matrix.util.DeviceUtil;
import com.tencent.matrix.util.MatrixHandlerThread;
import com.tencent.matrix.util.MatrixLog;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.json.JSONException;
import org.json.JSONObject;

public class LooperAnrTracer
extends Tracer
implements ILooperListener {
    private static final String TAG = "Matrix.AnrTracer";
    private Handler anrHandler;
    private Handler lagHandler;
    private final TraceConfig traceConfig;
    private final AnrHandleTask anrTask = new AnrHandleTask();
    private final LagHandleTask lagTask = new LagHandleTask();
    private final boolean isAnrTraceEnable;

    public LooperAnrTracer(TraceConfig traceConfig) {
        this.traceConfig = traceConfig;
        this.isAnrTraceEnable = traceConfig.isAnrTraceEnable();
    }

    @Override
    public void onAlive() {
        super.onAlive();
        if (this.isAnrTraceEnable) {
            LooperMonitor.register(this);
            this.anrHandler = new Handler(MatrixHandlerThread.getDefaultHandler().getLooper());
            this.lagHandler = new Handler(MatrixHandlerThread.getDefaultHandler().getLooper());
        }
    }

    @Override
    public void onDead() {
        super.onDead();
        if (this.isAnrTraceEnable) {
            LooperMonitor.unregister(this);
            this.anrTask.getBeginRecord().release();
            this.anrHandler.removeCallbacksAndMessages(null);
            this.lagHandler.removeCallbacksAndMessages(null);
        }
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public void onDispatchBegin(String log) {
        this.anrTask.beginRecord = AppMethodBeat.getInstance().maskIndex("AnrTracer#dispatchBegin");
        if (this.traceConfig.isDevEnv()) {
            MatrixLog.v((String)TAG, (String)"* [dispatchBegin] index:%s", (Object[])new Object[]{this.anrTask.beginRecord.index});
        }
        this.anrHandler.postDelayed((Runnable)this.anrTask, 5000L);
        this.lagHandler.postDelayed((Runnable)this.lagTask, 2000L);
    }

    @Override
    public void onDispatchEnd(String log, long beginNs, long endNs) {
        if (this.traceConfig.isDevEnv()) {
            long cost = (endNs - beginNs) / 1000000L;
            MatrixLog.v((String)TAG, (String)"[dispatchEnd] beginNs:%s endNs:%s cost:%sms", (Object[])new Object[]{beginNs, endNs, cost});
        }
        this.anrTask.getBeginRecord().release();
        this.anrHandler.removeCallbacks((Runnable)this.anrTask);
        this.lagHandler.removeCallbacks((Runnable)this.lagTask);
    }

    private String printInputExpired(long inputCost) {
        StringBuilder print = new StringBuilder();
        String scene = AppActiveMatrixDelegate.INSTANCE.getVisibleScene();
        boolean isForeground = this.isForeground();
        long[] memoryInfo = this.dumpMemory();
        int[] processStat = Utils.getProcessPriority(Process.myPid());
        print.append(String.format("-\n>>>>>>>>>>>>>>>>>>>>>>> maybe happens Input ANR(%s ms)! <<<<<<<<<<<<<<<<<<<<<<<\n", inputCost));
        print.append("|* [Status]").append("\n");
        print.append("|*\t\tScene: ").append(scene).append("\n");
        print.append("|*\t\tForeground: ").append(isForeground).append("\n");
        print.append("|*\t\tPriority: ").append(processStat[0]).append("\tNice: ").append(processStat[1]).append("\n");
        print.append("|*\t\tis64BitRuntime: ").append(DeviceUtil.is64BitRuntime()).append("\n");
        print.append("|* [Memory]").append("\n");
        print.append("|*\t\tDalvikHeap: ").append(memoryInfo[0]).append("kb\n");
        print.append("|*\t\tNativeHeap: ").append(memoryInfo[1]).append("kb\n");
        print.append("|*\t\tVmSize: ").append(memoryInfo[2]).append("kb\n");
        print.append("=========================================================================");
        return print.toString();
    }

    private long[] dumpMemory() {
        long[] memory = new long[]{DeviceUtil.getDalvikHeap(), DeviceUtil.getNativeHeap(), DeviceUtil.getVmSize()};
        return memory;
    }

    class AnrHandleTask
    implements Runnable {
        AppMethodBeat.IndexRecord beginRecord;
        long token;

        public AppMethodBeat.IndexRecord getBeginRecord() {
            return this.beginRecord;
        }

        AnrHandleTask() {
        }

        AnrHandleTask(AppMethodBeat.IndexRecord record, long token) {
            this.beginRecord = record;
            this.token = token;
        }

        @Override
        public void run() {
            String dumpStack;
            long curTime = SystemClock.uptimeMillis();
            boolean isForeground = LooperAnrTracer.this.isForeground();
            int[] processStat = Utils.getProcessPriority(Process.myPid());
            long[] data = AppMethodBeat.getInstance().copyData(this.beginRecord);
            this.beginRecord.release();
            String scene = AppActiveMatrixDelegate.INSTANCE.getVisibleScene();
            long[] memoryInfo = LooperAnrTracer.this.dumpMemory();
            Thread.State status = Looper.getMainLooper().getThread().getState();
            switch (LooperAnrTracer.this.traceConfig.getLooperPrinterStackStyle()) {
                case 1: {
                    dumpStack = Utils.getWholeStack(Looper.getMainLooper().getThread().getStackTrace(), "|*\t\t");
                    break;
                }
                case 2: {
                    dumpStack = Utils.getMainThreadJavaStackTrace();
                    break;
                }
                default: {
                    dumpStack = Utils.getStack(Looper.getMainLooper().getThread().getStackTrace(), "|*\t\t", 12);
                }
            }
            LinkedList<MethodItem> stack = new LinkedList<MethodItem>();
            if (data.length > 0) {
                TraceDataUtils.structuredDataToStack(data, stack, true, curTime);
                TraceDataUtils.trimStack(stack, 30, new TraceDataUtils.IStructuredDataFilter(){

                    @Override
                    public boolean isFilter(long during, int filterCount) {
                        return during < (long)filterCount * 5L;
                    }

                    @Override
                    public int getFilterMaxCount() {
                        return 60;
                    }

                    @Override
                    public void fallback(List<MethodItem> stack, int size) {
                        MatrixLog.w((String)LooperAnrTracer.TAG, (String)"[fallback] size:%s targetSize:%s stack:%s", (Object[])new Object[]{size, 30, stack});
                        ListIterator<MethodItem> iterator = stack.listIterator(Math.min(size, 30));
                        while (iterator.hasNext()) {
                            iterator.next();
                            iterator.remove();
                        }
                    }
                });
            }
            StringBuilder reportBuilder = new StringBuilder();
            StringBuilder logcatBuilder = new StringBuilder();
            long stackCost = Math.max(5000L, TraceDataUtils.stackToString(stack, reportBuilder, logcatBuilder));
            String stackKey = TraceDataUtils.getTreeKey(stack, stackCost);
            MatrixLog.w((String)LooperAnrTracer.TAG, (String)"%s \npostTime:%s curTime:%s", (Object[])new Object[]{this.printAnr(scene, processStat, memoryInfo, status, logcatBuilder, isForeground, stack.size(), stackKey, dumpStack, stackCost), this.token / 1000000L, curTime});
            if (stackCost >= 6000L) {
                MatrixLog.w((String)LooperAnrTracer.TAG, (String)"The checked anr task was not executed on time. The possible reason is that the current process has a low priority. just pass this report", (Object[])new Object[0]);
                return;
            }
            try {
                TracePlugin plugin = (TracePlugin)Matrix.with().getPluginByClass(TracePlugin.class);
                if (null == plugin) {
                    return;
                }
                JSONObject jsonObject = new JSONObject();
                DeviceUtil.getDeviceInfo((JSONObject)jsonObject, (Application)Matrix.with().getApplication());
                jsonObject.put("detail", (Object)Constants.Type.ANR);
                jsonObject.put("cost", stackCost);
                jsonObject.put("stackKey", (Object)stackKey);
                jsonObject.put("scene", (Object)scene);
                jsonObject.put("stack", (Object)reportBuilder.toString());
                jsonObject.put("threadStack", (Object)dumpStack);
                jsonObject.put("processPriority", processStat[0]);
                jsonObject.put("processNice", processStat[1]);
                jsonObject.put("isProcessForeground", isForeground);
                JSONObject memJsonObject = new JSONObject();
                memJsonObject.put("dalvik_heap", memoryInfo[0]);
                memJsonObject.put("native_heap", memoryInfo[1]);
                memJsonObject.put("vm_size", memoryInfo[2]);
                jsonObject.put("memory", (Object)memJsonObject);
                Issue issue = new Issue();
                issue.setKey(this.token + "");
                issue.setTag("Trace_EvilMethod");
                issue.setContent(jsonObject);
                plugin.onDetectIssue(issue);
            }
            catch (JSONException e) {
                MatrixLog.e((String)LooperAnrTracer.TAG, (String)"[JSONException error: %s", (Object[])new Object[]{e});
            }
        }

        private String printAnr(String scene, int[] processStat, long[] memoryInfo, Thread.State state, StringBuilder stack, boolean isForeground, long stackSize, String stackKey, String dumpStack, long stackCost) {
            StringBuilder print = new StringBuilder();
            print.append(String.format("-\n>>>>>>>>>>>>>>>>>>>>>>> maybe happens ANR(%s ms)! <<<<<<<<<<<<<<<<<<<<<<<\n", stackCost));
            print.append("|* [Status]").append("\n");
            print.append("|*\t\tScene: ").append(scene).append("\n");
            print.append("|*\t\tForeground: ").append(isForeground).append("\n");
            print.append("|*\t\tPriority: ").append(processStat[0]).append("\tNice: ").append(processStat[1]).append("\n");
            print.append("|*\t\tis64BitRuntime: ").append(DeviceUtil.is64BitRuntime()).append("\n");
            print.append("|* [Memory]").append("\n");
            print.append("|*\t\tDalvikHeap: ").append(memoryInfo[0]).append("kb\n");
            print.append("|*\t\tNativeHeap: ").append(memoryInfo[1]).append("kb\n");
            print.append("|*\t\tVmSize: ").append(memoryInfo[2]).append("kb\n");
            print.append("|* [Thread]").append("\n");
            print.append(String.format("|*\t\tStack(%s): ", new Object[]{state})).append(dumpStack);
            print.append("|* [Trace]").append("\n");
            if (stackSize > 0L) {
                print.append("|*\t\tStackKey: ").append(stackKey).append("\n");
                print.append(stack.toString());
            } else {
                print.append(String.format("AppMethodBeat is close[%s].", AppMethodBeat.getInstance().isAlive())).append("\n");
            }
            print.append("=========================================================================");
            return print.toString();
        }
    }

    class LagHandleTask
    implements Runnable {
        LagHandleTask() {
        }

        @Override
        public void run() {
            String scene = AppActiveMatrixDelegate.INSTANCE.getVisibleScene();
            boolean isForeground = LooperAnrTracer.this.isForeground();
            try {
                TracePlugin plugin = (TracePlugin)Matrix.with().getPluginByClass(TracePlugin.class);
                if (null == plugin) {
                    return;
                }
                StackTraceElement[] stackTrace = Looper.getMainLooper().getThread().getStackTrace();
                String dumpStack = Utils.getWholeStack(stackTrace);
                JSONObject jsonObject = new JSONObject();
                DeviceUtil.getDeviceInfo((JSONObject)jsonObject, (Application)Matrix.with().getApplication());
                jsonObject.put("detail", (Object)Constants.Type.LAG);
                jsonObject.put("scene", (Object)scene);
                jsonObject.put("threadStack", (Object)dumpStack);
                jsonObject.put("isProcessForeground", isForeground);
                Issue issue = new Issue();
                issue.setTag("Trace_EvilMethod");
                issue.setContent(jsonObject);
                plugin.onDetectIssue(issue);
                MatrixLog.e((String)LooperAnrTracer.TAG, (String)"happens lag : %s, scene : %s ", (Object[])new Object[]{dumpStack, scene});
            }
            catch (JSONException e) {
                MatrixLog.e((String)LooperAnrTracer.TAG, (String)"[JSONException error: %s", (Object[])new Object[]{e});
            }
        }
    }
}

