/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.tracer;

import android.app.ActivityManager;
import android.app.Application;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.os.Process;
import android.os.SystemClock;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.tencent.matrix.AppActiveMatrixDelegate;
import com.tencent.matrix.Matrix;
import com.tencent.matrix.report.Issue;
import com.tencent.matrix.trace.TracePlugin;
import com.tencent.matrix.trace.config.TraceConfig;
import com.tencent.matrix.trace.constants.Constants;
import com.tencent.matrix.trace.tracer.Tracer;
import com.tencent.matrix.trace.util.AppForegroundUtil;
import com.tencent.matrix.trace.util.Utils;
import com.tencent.matrix.util.DeviceUtil;
import com.tencent.matrix.util.MatrixLog;
import com.tencent.matrix.util.MatrixUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class SignalAnrTracer
extends Tracer {
    private static final String TAG = "SignalAnrTracer";
    private static final String CHECK_ANR_STATE_THREAD_NAME = "Check-ANR-State-Thread";
    private static final String ANR_DUMP_THREAD_NAME = "ANR-Dump-Thread";
    private static final int CHECK_ERROR_STATE_INTERVAL = 500;
    private static final int ANR_DUMP_MAX_TIME = 20000;
    private static long anrReportTimeout = 20000L;
    private static final int CHECK_ERROR_STATE_COUNT = 40;
    private static final long FOREGROUND_MSG_THRESHOLD = -2000L;
    private static final long BACKGROUND_MSG_THRESHOLD = -10000L;
    private static boolean currentForeground = false;
    private static String sAnrTraceFilePath = "";
    private static String sPrintTraceFilePath = "";
    private static SignalAnrDetectedListener sSignalAnrDetectedListener;
    private static Application sApplication;
    private static boolean hasInit;
    public static boolean hasInstance;
    private static long anrMessageWhen;
    private static String anrMessageString;
    private static String cgroup;
    private static String stackTrace;
    private static String nativeBacktraceStackTrace;
    private static long lastReportedTimeStamp;
    private static long onAnrDumpedTimeStamp;

    @Override
    protected void onAlive() {
        super.onAlive();
        if (!hasInit) {
            SignalAnrTracer.nativeInitSignalAnrDetective(sAnrTraceFilePath, sPrintTraceFilePath);
            AppForegroundUtil.INSTANCE.init();
            hasInit = true;
        }
    }

    @Override
    protected void onDead() {
        super.onDead();
        SignalAnrTracer.nativeFreeSignalAnrDetective();
    }

    public SignalAnrTracer(TraceConfig traceConfig) {
        hasInstance = true;
        sAnrTraceFilePath = traceConfig.anrTraceFilePath;
        sPrintTraceFilePath = traceConfig.printTraceFilePath;
    }

    public SignalAnrTracer(Application application) {
        hasInstance = true;
        sApplication = application;
    }

    public SignalAnrTracer(Application application, String anrTraceFilePath, String printTraceFilePath) {
        hasInstance = true;
        sAnrTraceFilePath = anrTraceFilePath;
        sPrintTraceFilePath = printTraceFilePath;
        sApplication = application;
    }

    public static void setAnrReportTimeout(long timeout) {
        anrReportTimeout = timeout;
    }

    public void setSignalAnrDetectedListener(SignalAnrDetectedListener listener) {
        sSignalAnrDetectedListener = listener;
    }

    public static String readCgroup() {
        StringBuilder ret = new StringBuilder();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/self/cgroup")));){
            String line;
            while ((line = reader.readLine()) != null) {
                ret.append(line).append("\n");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return ret.toString();
    }

    @RequiresApi(api=23)
    private static void confirmRealAnr(final boolean isSigQuit) {
        MatrixLog.i((String)TAG, (String)("confirmRealAnr, isSigQuit = " + isSigQuit), (Object[])new Object[0]);
        boolean needReport = SignalAnrTracer.isMainThreadBlocked();
        if (needReport) {
            SignalAnrTracer.report(false, isSigQuit);
        } else {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    SignalAnrTracer.checkErrorStateCycle(isSigQuit);
                }
            }, CHECK_ANR_STATE_THREAD_NAME).start();
        }
    }

    @RequiresApi(api=23)
    @Keep
    private static synchronized void onANRDumped() {
        final CountDownLatch anrDumpLatch = new CountDownLatch(1);
        new Thread(new Runnable(){

            @Override
            public void run() {
                onAnrDumpedTimeStamp = System.currentTimeMillis();
                MatrixLog.i((String)SignalAnrTracer.TAG, (String)"onANRDumped", (Object[])new Object[0]);
                stackTrace = Utils.getMainThreadJavaStackTrace();
                MatrixLog.i((String)SignalAnrTracer.TAG, (String)"onANRDumped, stackTrace = %s, duration = %d", (Object[])new Object[]{stackTrace, System.currentTimeMillis() - onAnrDumpedTimeStamp});
                cgroup = SignalAnrTracer.readCgroup();
                MatrixLog.i((String)SignalAnrTracer.TAG, (String)"onANRDumped, read cgroup duration = %d", (Object[])new Object[]{System.currentTimeMillis() - onAnrDumpedTimeStamp});
                currentForeground = AppForegroundUtil.isInterestingToUser();
                MatrixLog.i((String)SignalAnrTracer.TAG, (String)"onANRDumped, isInterestingToUser duration = %d", (Object[])new Object[]{System.currentTimeMillis() - onAnrDumpedTimeStamp});
                SignalAnrTracer.confirmRealAnr(true);
                anrDumpLatch.countDown();
            }
        }, ANR_DUMP_THREAD_NAME).start();
        try {
            anrDumpLatch.await(anrReportTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Keep
    private static void onANRDumpTrace() {
        try {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(sAnrTraceFilePath)), "UTF-8"));){
                String line;
                SimpleDeadLockDetector detector = new SimpleDeadLockDetector();
                while ((line = reader.readLine()) != null) {
                    detector.parseLine(line);
                    MatrixLog.i((String)TAG, (String)line, (Object[])new Object[0]);
                }
                if (sSignalAnrDetectedListener != null) {
                    if (detector.hasDeadLock()) {
                        sSignalAnrDetectedListener.onDeadLockAnrDetected(detector.getMainThreadInfo(), detector.getLockHeldThread1Info(), detector.getLockHeldThread2Info(), detector.getWaitingThreadsInfo());
                    } else if (detector.getMainThreadInfo().contains("android.os.MessageQueue.nativePollOnce")) {
                        sSignalAnrDetectedListener.onMainThreadStuckAtNativePollOnce(detector.getMainThreadInfo());
                    }
                }
            }
            catch (Throwable t) {
                MatrixLog.e((String)TAG, (String)("printFileByLine failed e : " + t.getMessage()), (Object[])new Object[0]);
            }
        }
        catch (Throwable t) {
            MatrixLog.e((String)TAG, (String)"onANRDumpTrace error: %s", (Object[])new Object[]{t.getMessage()});
        }
    }

    @Keep
    private static void onPrintTrace() {
        try {
            MatrixUtil.printFileByLine((String)TAG, (String)sPrintTraceFilePath);
        }
        catch (Throwable t) {
            MatrixLog.e((String)TAG, (String)"onPrintTrace error: %s", (Object[])new Object[]{t.getMessage()});
        }
    }

    @RequiresApi(api=23)
    @Keep
    private static void onNativeBacktraceDumped() {
        MatrixLog.i((String)TAG, (String)"happens onNativeBacktraceDumped", (Object[])new Object[0]);
        if (System.currentTimeMillis() - lastReportedTimeStamp < 20000L) {
            MatrixLog.i((String)TAG, (String)"report SIGQUIT recently, just return", (Object[])new Object[0]);
            return;
        }
        nativeBacktraceStackTrace = Utils.getMainThreadJavaStackTrace();
        MatrixLog.i((String)TAG, (String)("happens onNativeBacktraceDumped, mainThreadStackTrace = " + stackTrace), (Object[])new Object[0]);
        SignalAnrTracer.confirmRealAnr(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void report(boolean fromProcessErrorState, boolean isSigQuit) {
        try {
            if (sSignalAnrDetectedListener != null) {
                if (isSigQuit) {
                    sSignalAnrDetectedListener.onAnrDetected(stackTrace, anrMessageString, anrMessageWhen, fromProcessErrorState, cgroup);
                } else {
                    sSignalAnrDetectedListener.onNativeBacktraceDetected(nativeBacktraceStackTrace, anrMessageString, anrMessageWhen, fromProcessErrorState);
                }
                return;
            }
            TracePlugin plugin = (TracePlugin)Matrix.with().getPluginByClass(TracePlugin.class);
            if (null == plugin) {
                return;
            }
            String scene = AppActiveMatrixDelegate.INSTANCE.getVisibleScene();
            JSONObject jsonObject = new JSONObject();
            jsonObject = DeviceUtil.getDeviceInfo((JSONObject)jsonObject, (Application)Matrix.with().getApplication());
            if (isSigQuit) {
                jsonObject.put("detail", (Object)Constants.Type.SIGNAL_ANR);
                jsonObject.put("threadStack", (Object)stackTrace);
            } else {
                jsonObject.put("detail", (Object)Constants.Type.SIGNAL_ANR_NATIVE_BACKTRACE);
                jsonObject.put("threadStack", (Object)nativeBacktraceStackTrace);
            }
            jsonObject.put("scene", (Object)scene);
            jsonObject.put("isProcessForeground", currentForeground);
            Issue issue = new Issue();
            issue.setTag("Trace_EvilMethod");
            issue.setContent(jsonObject);
            plugin.onDetectIssue(issue);
            MatrixLog.e((String)TAG, (String)"happens real ANR : %s ", (Object[])new Object[]{jsonObject.toString()});
        }
        catch (JSONException e) {
            MatrixLog.e((String)TAG, (String)"[JSONException error: %s", (Object[])new Object[]{e});
        }
        finally {
            lastReportedTimeStamp = System.currentTimeMillis();
        }
    }

    @RequiresApi(api=23)
    private static boolean isMainThreadBlocked() {
        try {
            MessageQueue mainQueue = Looper.getMainLooper().getQueue();
            Field field = mainQueue.getClass().getDeclaredField("mMessages");
            field.setAccessible(true);
            Message mMessage = (Message)field.get(mainQueue);
            if (mMessage != null) {
                long time;
                anrMessageString = mMessage.toString();
                MatrixLog.i((String)TAG, (String)("anrMessageString = " + anrMessageString), (Object[])new Object[0]);
                long when = mMessage.getWhen();
                if (when == 0L) {
                    return false;
                }
                anrMessageWhen = time = when - SystemClock.uptimeMillis();
                long timeThreshold = -10000L;
                if (currentForeground) {
                    timeThreshold = -2000L;
                }
                return time < timeThreshold;
            }
            MatrixLog.i((String)TAG, (String)"mMessage is null", (Object[])new Object[0]);
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    private static void checkErrorStateCycle(boolean isSigQuit) {
        for (int checkErrorStateCount = 0; checkErrorStateCount < 40; ++checkErrorStateCount) {
            try {
                boolean myAnr = SignalAnrTracer.checkErrorState();
                if (myAnr) {
                    SignalAnrTracer.report(true, isSigQuit);
                    break;
                }
                Thread.sleep(500L);
                continue;
            }
            catch (Throwable t) {
                MatrixLog.e((String)TAG, (String)("checkErrorStateCycle error, e : " + t.getMessage()), (Object[])new Object[0]);
                break;
            }
        }
    }

    private static boolean checkErrorState() {
        try {
            MatrixLog.i((String)TAG, (String)"[checkErrorState] start", (Object[])new Object[0]);
            Application application = sApplication == null ? Matrix.with().getApplication() : sApplication;
            ActivityManager am = (ActivityManager)application.getSystemService("activity");
            List procs = am.getProcessesInErrorState();
            if (procs == null) {
                MatrixLog.i((String)TAG, (String)"[checkErrorState] procs == null", (Object[])new Object[0]);
                return false;
            }
            for (ActivityManager.ProcessErrorStateInfo proc : procs) {
                MatrixLog.i((String)TAG, (String)"[checkErrorState] found Error State proccessName = %s, proc.condition = %d", (Object[])new Object[]{proc.processName, proc.condition});
                if (proc.uid != Process.myUid() && proc.condition == 2) {
                    MatrixLog.i((String)TAG, (String)"maybe received other apps ANR signal", (Object[])new Object[0]);
                    return false;
                }
                if (proc.pid != Process.myPid() || proc.condition != 2) continue;
                MatrixLog.i((String)TAG, (String)"error sate longMsg = %s", (Object[])new Object[]{proc.longMsg});
                return true;
            }
            return false;
        }
        catch (Throwable t) {
            MatrixLog.e((String)TAG, (String)"[checkErrorState] error : %s", (Object[])new Object[]{t.getMessage()});
            return false;
        }
    }

    public static void printTrace() {
        if (!hasInstance) {
            MatrixLog.e((String)TAG, (String)"SignalAnrTracer has not been initialize", (Object[])new Object[0]);
            return;
        }
        if (sPrintTraceFilePath.equals("")) {
            MatrixLog.e((String)TAG, (String)"PrintTraceFilePath has not been set", (Object[])new Object[0]);
            return;
        }
        SignalAnrTracer.nativePrintTrace();
    }

    private static native void nativeInitSignalAnrDetective(String var0, String var1);

    private static native void nativeFreeSignalAnrDetective();

    private static native void nativePrintTrace();

    static {
        hasInit = false;
        hasInstance = false;
        anrMessageWhen = 0L;
        anrMessageString = "";
        cgroup = "";
        stackTrace = "";
        nativeBacktraceStackTrace = "";
        lastReportedTimeStamp = 0L;
        onAnrDumpedTimeStamp = 0L;
        System.loadLibrary("trace-canary");
    }

    public static interface SignalAnrDetectedListener {
        public void onAnrDetected(String var1, String var2, long var3, boolean var5, String var6);

        public void onNativeBacktraceDetected(String var1, String var2, long var3, boolean var5);

        public void onDeadLockAnrDetected(String var1, String var2, String var3, Map.Entry<int[], String[]> var4);

        public void onMainThreadStuckAtNativePollOnce(String var1);
    }

    private static class SimpleDeadLockDetector {
        private final Pattern threadPattern = Pattern.compile("^\"(.*?)\" .*? tid=(\\d+) \\w+$");
        private final Pattern lockHeldPattern = Pattern.compile("^  - .*?\\(a (.*?)\\) held by thread (\\d+)$");
        private final StringBuilder currentSb = new StringBuilder();
        private final HashMap<Integer, ThreadNode> threadsWaitingForHeldLock = new HashMap();
        private LinkedList<ThreadNode> waitingList = new LinkedList();
        private String mainThreadInfo = "";
        private boolean threadInfoBegin = false;
        private ThreadNode currentThreadInfo = new ThreadNode();

        private SimpleDeadLockDetector() {
        }

        public void parseLine(String line) {
            if (line.isEmpty()) {
                this.threadInfoBegin = false;
                if (this.currentSb.length() > 0 && this.currentThreadInfo.peerId >= 0) {
                    String threadInfo = this.currentSb.toString();
                    if (this.currentThreadInfo.threadId == 1) {
                        this.mainThreadInfo = threadInfo;
                    }
                    this.currentThreadInfo.info = threadInfo;
                    this.threadsWaitingForHeldLock.put(this.currentThreadInfo.threadId, this.currentThreadInfo);
                    this.currentThreadInfo = new ThreadNode();
                }
            } else if (!this.threadInfoBegin) {
                Matcher m = this.threadPattern.matcher(line);
                if (m.find()) {
                    this.threadInfoBegin = true;
                    this.currentSb.setLength(0);
                    this.currentSb.append(line).append('\n');
                    try {
                        this.currentThreadInfo.threadId = Integer.parseInt(Objects.requireNonNull(m.group(2)));
                    }
                    catch (Exception e) {
                        MatrixLog.e((String)SignalAnrTracer.TAG, (String)e.toString(), (Object[])new Object[0]);
                    }
                }
            } else {
                Matcher m = this.lockHeldPattern.matcher(line);
                if (m.find()) {
                    try {
                        this.currentThreadInfo.lockObjCls = m.group(1);
                        this.currentThreadInfo.peerId = Integer.parseInt(Objects.requireNonNull(m.group(2)));
                    }
                    catch (Exception e) {
                        MatrixLog.e((String)SignalAnrTracer.TAG, (String)e.toString(), (Object[])new Object[0]);
                    }
                }
                this.currentSb.append(line).append('\n');
            }
        }

        public boolean hasDeadLock() {
            this.parseLine("");
            return this.checkDeadLock();
        }

        @NonNull
        public String getMainThreadInfo() {
            return this.mainThreadInfo;
        }

        @NonNull
        public String getLockHeldThread1Info() {
            if (this.waitingList == null || this.waitingList.size() == 0) {
                return "";
            }
            int threadId = this.waitingList.get((int)0).threadId;
            ThreadNode node = this.threadsWaitingForHeldLock.get(threadId);
            return node == null ? "" : node.info;
        }

        @NonNull
        public String getLockHeldThread2Info() {
            if (this.waitingList == null || this.waitingList.size() == 0) {
                return "";
            }
            int threadId = this.waitingList.get((int)(this.waitingList.size() - 1)).threadId;
            ThreadNode node = this.threadsWaitingForHeldLock.get(threadId);
            return node == null ? "" : node.info;
        }

        @NonNull
        public Map.Entry<int[], String[]> getWaitingThreadsInfo() {
            if (this.waitingList.size() == 0) {
                return new Pair<Object, Object>(null, null);
            }
            int[] threadsId = new int[this.waitingList.size()];
            String[] locksType = new String[this.waitingList.size()];
            int idx = 0;
            for (ThreadNode threadNode : this.waitingList) {
                threadsId[idx] = threadNode.threadId;
                locksType[idx] = threadNode.lockObjCls;
                ++idx;
            }
            return new Pair<int[], String[]>(threadsId, locksType);
        }

        private boolean checkDeadLock() {
            this.waitingList.clear();
            for (Map.Entry<Integer, ThreadNode> nodeEntry : this.threadsWaitingForHeldLock.entrySet()) {
                ThreadNode ret;
                ThreadNode node = nodeEntry.getValue();
                if (node.visit != 0 || (ret = this.dfsSearch(node)) == null) continue;
                while (this.waitingList.size() > 0 && this.waitingList.getFirst() != ret) {
                    this.waitingList.removeFirst();
                }
                return true;
            }
            return false;
        }

        private ThreadNode dfsSearch(ThreadNode node) {
            this.waitingList.addLast(node);
            node.visit = 1;
            ThreadNode peerNode = this.threadsWaitingForHeldLock.get(node.peerId);
            if (peerNode != null) {
                ThreadNode ret;
                if (peerNode.visit == 1) {
                    return peerNode;
                }
                if (peerNode.visit == 0 && (ret = this.dfsSearch(peerNode)) != null) {
                    return ret;
                }
            }
            node.visit = 2;
            this.waitingList.removeLast();
            return null;
        }

        private static class Pair<F, S>
        implements Map.Entry<F, S> {
            F f;
            S s;

            Pair(F f, S s) {
                this.f = f;
                this.s = s;
            }

            @Override
            public F getKey() {
                return this.f;
            }

            @Override
            public S getValue() {
                return this.s;
            }

            @Override
            public S setValue(S value) {
                this.s = value;
                return this.s;
            }

            public String toString() {
                return "Pair{f=" + this.f + ", s=" + this.s + '}';
            }
        }

        static class ThreadNode {
            int threadId;
            String info;
            String lockObjCls;
            int peerId = -1;
            int visit = 0;

            ThreadNode() {
            }
        }
    }
}

