/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.tracer;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import com.tencent.matrix.Matrix;
import com.tencent.matrix.report.Issue;
import com.tencent.matrix.trace.TracePlugin;
import com.tencent.matrix.trace.config.TraceConfig;
import com.tencent.matrix.trace.constants.Constants;
import com.tencent.matrix.trace.core.AppMethodBeat;
import com.tencent.matrix.trace.hacker.ActivityThreadHacker;
import com.tencent.matrix.trace.items.MethodItem;
import com.tencent.matrix.trace.listeners.IAppMethodBeatListener;
import com.tencent.matrix.trace.tracer.Tracer;
import com.tencent.matrix.trace.util.TraceDataUtils;
import com.tencent.matrix.util.DeviceUtil;
import com.tencent.matrix.util.MatrixHandlerThread;
import com.tencent.matrix.util.MatrixLog;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class StartupTracer
extends Tracer
implements IAppMethodBeatListener,
ActivityThreadHacker.IApplicationCreateListener,
Application.ActivityLifecycleCallbacks {
    private static final String TAG = "Matrix.StartupTracer";
    private final TraceConfig config;
    private long firstScreenCost = 0L;
    private long coldCost = 0L;
    private int activeActivityCount;
    private boolean isWarmStartUp;
    private boolean hasShowSplashActivity;
    private boolean isStartupEnable;
    private Set<String> splashActivities;
    private long coldStartupThresholdMs;
    private long warmStartupThresholdMs;
    private boolean isHasActivity;
    private long lastCreateActivity = 0L;
    private HashMap<String, Long> createdTimeMap = new HashMap();
    private boolean isShouldRecordCreateTime = true;

    public StartupTracer(TraceConfig config) {
        this.config = config;
        this.isStartupEnable = config.isStartupEnable();
        this.splashActivities = config.getSplashActivities();
        this.coldStartupThresholdMs = config.getColdStartupThresholdMs();
        this.warmStartupThresholdMs = config.getWarmStartupThresholdMs();
        this.isHasActivity = config.isHasActivity();
        ActivityThreadHacker.addListener(this);
    }

    @Override
    protected void onAlive() {
        super.onAlive();
        MatrixLog.i((String)TAG, (String)"[onAlive] isStartupEnable:%s", (Object[])new Object[]{this.isStartupEnable});
        if (this.isStartupEnable) {
            AppMethodBeat.getInstance().addListener(this);
            Matrix.with().getApplication().registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    @Override
    protected void onDead() {
        super.onDead();
        if (this.isStartupEnable) {
            AppMethodBeat.getInstance().removeListener(this);
            Matrix.with().getApplication().unregisterActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)this);
        }
    }

    @Override
    public void onApplicationCreateEnd() {
        if (!this.isHasActivity) {
            long applicationCost = ActivityThreadHacker.getApplicationCost();
            MatrixLog.i((String)TAG, (String)"onApplicationCreateEnd, applicationCost:%d", (Object[])new Object[]{applicationCost});
            this.analyse(applicationCost, 0L, applicationCost, false);
        }
    }

    @Override
    public void onActivityFocused(Activity activity) {
        if (ActivityThreadHacker.sApplicationCreateScene == Integer.MIN_VALUE) {
            Log.w((String)TAG, (String)"start up from unknown scene");
            return;
        }
        String activityName = activity.getClass().getName();
        if (this.isColdStartup()) {
            boolean isCreatedByLaunchActivity = ActivityThreadHacker.isCreatedByLaunchActivity();
            MatrixLog.i((String)TAG, (String)"#ColdStartup# activity:%s, splashActivities:%s, empty:%b, isCreatedByLaunchActivity:%b, hasShowSplashActivity:%b, firstScreenCost:%d, now:%d, application_create_begin_time:%d, app_cost:%d", (Object[])new Object[]{activityName, this.splashActivities, this.splashActivities.isEmpty(), isCreatedByLaunchActivity, this.hasShowSplashActivity, this.firstScreenCost, SystemClock.uptimeMillis(), ActivityThreadHacker.getEggBrokenTime(), ActivityThreadHacker.getApplicationCost()});
            String key = activityName + "@" + activity.hashCode();
            Long createdTime = this.createdTimeMap.get(key);
            if (createdTime == null) {
                createdTime = 0L;
            }
            this.createdTimeMap.put(key, SystemClock.uptimeMillis() - createdTime);
            if (this.firstScreenCost == 0L) {
                this.firstScreenCost = SystemClock.uptimeMillis() - ActivityThreadHacker.getEggBrokenTime();
            }
            if (this.hasShowSplashActivity) {
                this.coldCost = SystemClock.uptimeMillis() - ActivityThreadHacker.getEggBrokenTime();
            } else if (this.splashActivities.contains(activityName)) {
                this.hasShowSplashActivity = true;
            } else if (this.splashActivities.isEmpty()) {
                if (isCreatedByLaunchActivity) {
                    this.coldCost = this.firstScreenCost;
                } else {
                    this.firstScreenCost = 0L;
                    this.coldCost = ActivityThreadHacker.getApplicationCost();
                }
            } else if (isCreatedByLaunchActivity) {
                this.coldCost = this.firstScreenCost;
            } else {
                this.firstScreenCost = 0L;
                this.coldCost = ActivityThreadHacker.getApplicationCost();
            }
            if (this.coldCost > 0L) {
                Long betweenCost = this.createdTimeMap.get(key);
                if (null != betweenCost && betweenCost >= 30000L) {
                    MatrixLog.e((String)TAG, (String)"%s cost too much time[%s] between activity create and onActivityFocused, just throw it.(createTime:%s) ", (Object[])new Object[]{key, SystemClock.uptimeMillis() - createdTime, createdTime});
                    return;
                }
                this.analyse(ActivityThreadHacker.getApplicationCost(), this.firstScreenCost, this.coldCost, false);
            }
        } else if (this.isWarmStartUp()) {
            this.isWarmStartUp = false;
            long warmCost = SystemClock.uptimeMillis() - this.lastCreateActivity;
            MatrixLog.i((String)TAG, (String)"#WarmStartup# activity:%s, warmCost:%d, now:%d, lastCreateActivity:%d", (Object[])new Object[]{activityName, warmCost, SystemClock.uptimeMillis(), this.lastCreateActivity});
            if (warmCost > 0L) {
                this.analyse(0L, 0L, warmCost, true);
            }
        }
    }

    private boolean isColdStartup() {
        return this.coldCost == 0L;
    }

    private boolean isWarmStartUp() {
        return this.isWarmStartUp;
    }

    private void analyse(long applicationCost, long firstScreenCost, long allCost, boolean isWarmStartUp) {
        MatrixLog.i((String)TAG, (String)"[report] applicationCost:%s firstScreenCost:%s allCost:%s isWarmStartUp:%s, createScene:%d", (Object[])new Object[]{applicationCost, firstScreenCost, allCost, isWarmStartUp, ActivityThreadHacker.sApplicationCreateScene});
        long[] data = new long[]{};
        if (!isWarmStartUp && allCost >= this.coldStartupThresholdMs) {
            data = AppMethodBeat.getInstance().copyData(ActivityThreadHacker.sApplicationCreateBeginMethodIndex);
            ActivityThreadHacker.sApplicationCreateBeginMethodIndex.release();
        } else if (isWarmStartUp && allCost >= this.warmStartupThresholdMs) {
            data = AppMethodBeat.getInstance().copyData(ActivityThreadHacker.sLastLaunchActivityMethodIndex);
            ActivityThreadHacker.sLastLaunchActivityMethodIndex.release();
        }
        MatrixHandlerThread.getDefaultHandler().post((Runnable)new AnalyseTask(data, applicationCost, firstScreenCost, allCost, isWarmStartUp, ActivityThreadHacker.sApplicationCreateScene));
    }

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        MatrixLog.i((String)TAG, (String)"activeActivityCount:%d, coldCost:%d", (Object[])new Object[]{this.activeActivityCount, this.coldCost});
        if (this.activeActivityCount == 0 && this.coldCost > 0L) {
            this.lastCreateActivity = SystemClock.uptimeMillis();
            MatrixLog.i((String)TAG, (String)"lastCreateActivity:%d, activity:%s", (Object[])new Object[]{this.lastCreateActivity, activity.getClass().getName()});
            this.isWarmStartUp = true;
        }
        ++this.activeActivityCount;
        if (this.isShouldRecordCreateTime) {
            this.createdTimeMap.put(activity.getClass().getName() + "@" + activity.hashCode(), SystemClock.uptimeMillis());
        }
    }

    public void onActivityDestroyed(Activity activity) {
        MatrixLog.i((String)TAG, (String)"activeActivityCount:%d", (Object[])new Object[]{this.activeActivityCount});
        --this.activeActivityCount;
    }

    public void onActivityStarted(Activity activity) {
    }

    public void onActivityResumed(Activity activity) {
    }

    public void onActivityPaused(Activity activity) {
    }

    public void onActivityStopped(Activity activity) {
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    @Override
    public void onForeground(boolean isForeground) {
        super.onForeground(isForeground);
        if (!isForeground) {
            StartupTracer.checkActivityThread_mCallback();
        }
    }

    private static void checkActivityThread_mCallback() {
        try {
            Class<?> forName = Class.forName("android.app.ActivityThread");
            Field field = forName.getDeclaredField("sCurrentActivityThread");
            field.setAccessible(true);
            Object activityThreadValue = field.get(forName);
            Field mH = forName.getDeclaredField("mH");
            mH.setAccessible(true);
            Object handler = mH.get(activityThreadValue);
            Class<?> handlerClass = handler.getClass().getSuperclass();
            Field callbackField = handlerClass.getDeclaredField("mCallback");
            callbackField.setAccessible(true);
            Handler.Callback currentCallback = (Handler.Callback)callbackField.get(handler);
            MatrixLog.i((String)TAG, (String)"callback %s", (Object[])new Object[]{currentCallback});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class AnalyseTask
    implements Runnable {
        long[] data;
        long applicationCost;
        long firstScreenCost;
        long allCost;
        boolean isWarmStartUp;
        int scene;

        AnalyseTask(long[] data, long applicationCost, long firstScreenCost, long allCost, boolean isWarmStartUp, int scene) {
            this.data = data;
            this.scene = scene;
            this.applicationCost = applicationCost;
            this.firstScreenCost = firstScreenCost;
            this.allCost = allCost;
            this.isWarmStartUp = isWarmStartUp;
        }

        @Override
        public void run() {
            LinkedList<MethodItem> stack = new LinkedList<MethodItem>();
            if (this.data.length > 0) {
                TraceDataUtils.structuredDataToStack(this.data, stack, false, -1L);
                TraceDataUtils.trimStack(stack, 30, new TraceDataUtils.IStructuredDataFilter(){

                    @Override
                    public boolean isFilter(long during, int filterCount) {
                        return during < (long)(filterCount * 5);
                    }

                    @Override
                    public int getFilterMaxCount() {
                        return 60;
                    }

                    @Override
                    public void fallback(List<MethodItem> stack, int size) {
                        MatrixLog.w((String)StartupTracer.TAG, (String)"[fallback] size:%s targetSize:%s stack:%s", (Object[])new Object[]{size, 30, stack});
                        ListIterator<MethodItem> iterator = stack.listIterator(Math.min(size, 30));
                        while (iterator.hasNext()) {
                            iterator.next();
                            iterator.remove();
                        }
                    }
                });
            }
            StringBuilder reportBuilder = new StringBuilder();
            StringBuilder logcatBuilder = new StringBuilder();
            long stackCost = Math.max(this.allCost, TraceDataUtils.stackToString(stack, reportBuilder, logcatBuilder));
            String stackKey = TraceDataUtils.getTreeKey(stack, stackCost);
            if (this.allCost > StartupTracer.this.coldStartupThresholdMs && !this.isWarmStartUp || this.allCost > StartupTracer.this.warmStartupThresholdMs && this.isWarmStartUp) {
                MatrixLog.w((String)StartupTracer.TAG, (String)"stackKey:%s \n%s", (Object[])new Object[]{stackKey, logcatBuilder.toString()});
            }
            this.report(this.applicationCost, this.firstScreenCost, reportBuilder, stackKey, stackCost, this.isWarmStartUp, this.scene);
        }

        private void report(long applicationCost, long firstScreenCost, StringBuilder reportBuilder, String stackKey, long allCost, boolean isWarmStartUp, int scene) {
            Issue issue;
            TracePlugin plugin = (TracePlugin)Matrix.with().getPluginByClass(TracePlugin.class);
            if (null == plugin) {
                return;
            }
            try {
                JSONObject costObject = new JSONObject();
                costObject = DeviceUtil.getDeviceInfo((JSONObject)costObject, (Application)Matrix.with().getApplication());
                costObject.put("application_create", applicationCost);
                costObject.put("application_create_scene", scene);
                costObject.put("first_activity_create", firstScreenCost);
                costObject.put("startup_duration", allCost);
                costObject.put("is_warm_start_up", isWarmStartUp);
                issue = new Issue();
                issue.setTag("Trace_StartUp");
                issue.setContent(costObject);
                plugin.onDetectIssue(issue);
            }
            catch (JSONException e) {
                MatrixLog.e((String)StartupTracer.TAG, (String)"[JSONException for StartUpReportTask error: %s", (Object[])new Object[]{e});
            }
            if (allCost > StartupTracer.this.coldStartupThresholdMs && !isWarmStartUp || allCost > StartupTracer.this.warmStartupThresholdMs && isWarmStartUp) {
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject = DeviceUtil.getDeviceInfo((JSONObject)jsonObject, (Application)Matrix.with().getApplication());
                    jsonObject.put("detail", (Object)Constants.Type.STARTUP);
                    jsonObject.put("cost", allCost);
                    jsonObject.put("stack", (Object)reportBuilder.toString());
                    jsonObject.put("stackKey", (Object)stackKey);
                    jsonObject.put("subType", isWarmStartUp ? 2 : 1);
                    issue = new Issue();
                    issue.setTag("Trace_EvilMethod");
                    issue.setContent(jsonObject);
                    plugin.onDetectIssue(issue);
                }
                catch (JSONException e) {
                    MatrixLog.e((String)StartupTracer.TAG, (String)"[JSONException error: %s", (Object[])new Object[]{e});
                }
            }
        }
    }
}

