/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.tracer;

import android.app.Application;
import androidx.annotation.Keep;
import com.tencent.matrix.Matrix;
import com.tencent.matrix.report.Issue;
import com.tencent.matrix.trace.TracePlugin;
import com.tencent.matrix.trace.constants.Constants;
import com.tencent.matrix.trace.tracer.Tracer;
import com.tencent.matrix.trace.util.Utils;
import com.tencent.matrix.util.DeviceUtil;
import com.tencent.matrix.util.MatrixLog;
import org.json.JSONObject;

public class ThreadTracer
extends Tracer {
    private static final String TAG = "ThreadPriorityTracer";
    private static MainThreadPriorityModifiedListener sMainThreadPriorityModifiedListener;
    private static PthreadKeyCallback sPthreadKeyCallback;
    private static boolean enableThreadPriorityTracer;
    private static boolean enablePthreadKeyTracer;

    @Override
    protected void onAlive() {
        super.onAlive();
        if (enableThreadPriorityTracer || enablePthreadKeyTracer) {
            ThreadTracer.nativeInitThreadHook(enableThreadPriorityTracer ? 1 : 0, enablePthreadKeyTracer ? 1 : 0);
        }
    }

    @Override
    protected void onDead() {
        super.onDead();
    }

    public void setMainThreadPriorityModifiedListener(MainThreadPriorityModifiedListener mainThreadPriorityModifiedListener) {
        enableThreadPriorityTracer = true;
        sMainThreadPriorityModifiedListener = mainThreadPriorityModifiedListener;
    }

    public void setPthreadKeyCallback(PthreadKeyCallback callback) {
        enablePthreadKeyTracer = true;
        sPthreadKeyCallback = callback;
    }

    public static int getPthreadKeySeq() {
        return ThreadTracer.nativeGetPthreadKeySeq();
    }

    private static native void nativeInitThreadHook(int var0, int var1);

    private static native int nativeGetPthreadKeySeq();

    @Keep
    private static void onMainThreadPriorityModified(int priorityBefore, int priorityAfter) {
        if (sMainThreadPriorityModifiedListener != null) {
            sMainThreadPriorityModifiedListener.onMainThreadPriorityModified(priorityBefore, priorityAfter);
            return;
        }
        try {
            TracePlugin plugin = (TracePlugin)Matrix.with().getPluginByClass(TracePlugin.class);
            if (null == plugin) {
                return;
            }
            String stackTrace = Utils.getMainThreadJavaStackTrace();
            JSONObject jsonObject = new JSONObject();
            jsonObject = DeviceUtil.getDeviceInfo((JSONObject)jsonObject, (Application)Matrix.with().getApplication());
            jsonObject.put("detail", (Object)Constants.Type.PRIORITY_MODIFIED);
            jsonObject.put("threadStack", (Object)stackTrace);
            jsonObject.put("processPriority", priorityAfter);
            Issue issue = new Issue();
            issue.setTag("Trace_EvilMethod");
            issue.setContent(jsonObject);
            plugin.onDetectIssue(issue);
            MatrixLog.e((String)TAG, (String)"happens MainThreadPriorityModified : %s ", (Object[])new Object[]{jsonObject.toString()});
        }
        catch (Throwable t) {
            MatrixLog.e((String)TAG, (String)"onMainThreadPriorityModified error: %s", (Object[])new Object[]{t.getMessage()});
        }
    }

    @Keep
    private static void onMainThreadTimerSlackModified(long timerSlack) {
        try {
            if (sMainThreadPriorityModifiedListener != null) {
                sMainThreadPriorityModifiedListener.onMainThreadTimerSlackModified(timerSlack);
                return;
            }
            TracePlugin plugin = (TracePlugin)Matrix.with().getPluginByClass(TracePlugin.class);
            if (null == plugin) {
                return;
            }
            String stackTrace = Utils.getMainThreadJavaStackTrace();
            JSONObject jsonObject = new JSONObject();
            jsonObject = DeviceUtil.getDeviceInfo((JSONObject)jsonObject, (Application)Matrix.with().getApplication());
            jsonObject.put("detail", (Object)Constants.Type.TIMERSLACK_MODIFIED);
            jsonObject.put("threadStack", (Object)stackTrace);
            jsonObject.put("processTimerSlack", timerSlack);
            Issue issue = new Issue();
            issue.setTag("Trace_EvilMethod");
            issue.setContent(jsonObject);
            plugin.onDetectIssue(issue);
            MatrixLog.e((String)TAG, (String)"happens MainThreadPriorityModified : %s ", (Object[])new Object[]{jsonObject.toString()});
        }
        catch (Throwable t) {
            MatrixLog.e((String)TAG, (String)"onMainThreadPriorityModified error: %s", (Object[])new Object[]{t.getMessage()});
        }
    }

    @Keep
    private static void pthreadKeyCallback(int type, int ret, int keySeq, String soPath, String backtrace) {
        if (sPthreadKeyCallback != null) {
            if (type == 0) {
                sPthreadKeyCallback.onPthreadCreate(ret, keySeq, soPath, backtrace);
            } else if (type == 1) {
                sPthreadKeyCallback.onPthreadDelete(ret, keySeq, soPath, backtrace);
            }
        }
    }

    static {
        enableThreadPriorityTracer = false;
        enablePthreadKeyTracer = false;
        System.loadLibrary("trace-canary");
    }

    public static interface PthreadKeyCallback {
        public void onPthreadCreate(int var1, int var2, String var3, String var4);

        public void onPthreadDelete(int var1, int var2, String var3, String var4);
    }

    public static interface MainThreadPriorityModifiedListener {
        public void onMainThreadPriorityModified(int var1, int var2);

        public void onMainThreadTimerSlackModified(long var1);
    }
}

