/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.tracer;

import android.app.Application;
import androidx.annotation.Keep;
import com.tencent.matrix.AppActiveMatrixDelegate;
import com.tencent.matrix.Matrix;
import com.tencent.matrix.report.Issue;
import com.tencent.matrix.trace.TracePlugin;
import com.tencent.matrix.trace.config.TraceConfig;
import com.tencent.matrix.trace.constants.Constants;
import com.tencent.matrix.trace.tracer.Tracer;
import com.tencent.matrix.trace.util.AppForegroundUtil;
import com.tencent.matrix.trace.util.Utils;
import com.tencent.matrix.util.DeviceUtil;
import com.tencent.matrix.util.MatrixHandlerThread;
import com.tencent.matrix.util.MatrixLog;
import org.json.JSONObject;

public class TouchEventLagTracer
extends Tracer {
    private static final String TAG = "Matrix.TouchEventLagTracer";
    private static TraceConfig traceConfig;
    private static long lastLagTime;
    private static String currentLagFdStackTrace;

    public TouchEventLagTracer(TraceConfig config) {
        traceConfig = config;
    }

    @Override
    public synchronized void onAlive() {
        super.onAlive();
        if (traceConfig.isTouchEventTraceEnable()) {
            TouchEventLagTracer.nativeInitTouchEventLagDetective(TouchEventLagTracer.traceConfig.touchEventLagThreshold);
        }
    }

    @Override
    public void onDead() {
        super.onDead();
    }

    public static native void nativeInitTouchEventLagDetective(int var0);

    @Keep
    private static void onTouchEventLagDumpTrace(int fd) {
        MatrixLog.e((String)TAG, (String)("onTouchEventLagDumpTrace, fd = " + fd), (Object[])new Object[0]);
        currentLagFdStackTrace = Utils.getMainThreadJavaStackTrace();
    }

    @Keep
    private static void onTouchEventLag(int fd) {
        MatrixLog.e((String)TAG, (String)("onTouchEventLag, fd = " + fd), (Object[])new Object[0]);
        MatrixHandlerThread.getDefaultHandler().post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (System.currentTimeMillis() - lastLagTime < 4000L) {
                        return;
                    }
                    MatrixLog.i((String)TouchEventLagTracer.TAG, (String)"onTouchEventLag report", (Object[])new Object[0]);
                    lastLagTime = System.currentTimeMillis();
                    TracePlugin plugin = (TracePlugin)Matrix.with().getPluginByClass(TracePlugin.class);
                    if (null == plugin) {
                        return;
                    }
                    String stackTrace = currentLagFdStackTrace;
                    boolean currentForeground = AppForegroundUtil.isInterestingToUser();
                    String scene = AppActiveMatrixDelegate.INSTANCE.getVisibleScene();
                    JSONObject jsonObject = new JSONObject();
                    jsonObject = DeviceUtil.getDeviceInfo((JSONObject)jsonObject, (Application)Matrix.with().getApplication());
                    jsonObject.put("detail", (Object)Constants.Type.LAG_TOUCH);
                    jsonObject.put("scene", (Object)scene);
                    jsonObject.put("threadStack", (Object)stackTrace);
                    jsonObject.put("isProcessForeground", currentForeground);
                    Issue issue = new Issue();
                    issue.setTag("Trace_EvilMethod");
                    issue.setContent(jsonObject);
                    plugin.onDetectIssue(issue);
                }
                catch (Throwable t) {
                    MatrixLog.e((String)TouchEventLagTracer.TAG, (String)("Matrix error, error = " + t.getMessage()), (Object[])new Object[0]);
                }
            }
        });
    }

    static {
        lastLagTime = 0L;
        System.loadLibrary("trace-canary");
    }
}

