/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.tracer;

import androidx.annotation.CallSuper;
import com.tencent.matrix.lifecycle.owners.ProcessUILifecycleOwner;
import com.tencent.matrix.trace.tracer.ITracer;
import com.tencent.matrix.util.MatrixLog;

public abstract class Tracer
implements ITracer {
    private volatile boolean isAlive = false;
    private static final String TAG = "Matrix.Tracer";

    @CallSuper
    protected void onAlive() {
        MatrixLog.i((String)TAG, (String)"[onAlive] %s", (Object[])new Object[]{this.getClass().getName()});
    }

    @CallSuper
    protected void onDead() {
        MatrixLog.i((String)TAG, (String)"[onDead] %s", (Object[])new Object[]{this.getClass().getName()});
    }

    @Override
    public final synchronized void onStartTrace() {
        if (!this.isAlive) {
            this.isAlive = true;
            this.onAlive();
        }
    }

    @Override
    public final synchronized void onCloseTrace() {
        if (this.isAlive) {
            this.isAlive = false;
            this.onDead();
        }
    }

    public void onForeground(boolean isForeground) {
    }

    @Override
    public boolean isAlive() {
        return this.isAlive;
    }

    public boolean isForeground() {
        return ProcessUILifecycleOwner.INSTANCE.isProcessForeground();
    }
}

