/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.util;

import android.app.Activity;
import android.app.Application;
import android.app.Service;
import android.content.ComponentCallbacks2;
import android.content.res.Configuration;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.ArrayMap;
import java.lang.reflect.Field;
import java.util.HashMap;

public enum AppForegroundUtil {
    INSTANCE;

    private static final String TAG = "Matrix.AppActiveDelegate";
    private boolean isAppForeground = false;
    private String visibleScene = "default";
    private Controller controller = new Controller();
    private boolean isInit = false;
    private String currentFragmentName;
    private Handler handler;

    public void init() {
        if (this.isInit) {
            return;
        }
        this.isInit = true;
    }

    public String getCurrentFragmentName() {
        return this.currentFragmentName;
    }

    public void setCurrentFragmentName(String fragmentName) {
        this.currentFragmentName = fragmentName;
        this.updateScene(fragmentName);
    }

    public String getVisibleScene() {
        return this.visibleScene;
    }

    private void onDispatchForeground(String visibleScene) {
        this.isAppForeground = true;
        if (this.isAppForeground || !this.isInit) {
            return;
        }
    }

    private void onDispatchBackground(String visibleScene) {
        this.isAppForeground = false;
        if (!this.isAppForeground || !this.isInit) {
            return;
        }
    }

    public boolean isAppForeground() {
        return this.isAppForeground;
    }

    private void updateScene(Activity activity) {
        this.visibleScene = activity.getClass().getName();
    }

    private void updateScene(String currentFragmentName) {
        StringBuilder ss = new StringBuilder();
        ss.append(TextUtils.isEmpty((CharSequence)currentFragmentName) ? "?" : currentFragmentName);
        this.visibleScene = ss.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTopActivityName() {
        long start = System.currentTimeMillis();
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
            activitiesField.setAccessible(true);
            HashMap activities = Build.VERSION.SDK_INT < 19 ? (HashMap)activitiesField.get(activityThread) : (ArrayMap)activitiesField.get(activityThread);
            if (activities.size() < 1) {
                String string = null;
                return string;
            }
            for (Object activityRecord : activities.values()) {
                Class<?> activityRecordClass = activityRecord.getClass();
                Field pausedField = activityRecordClass.getDeclaredField("paused");
                pausedField.setAccessible(true);
                if (pausedField.getBoolean(activityRecord)) continue;
                Field activityField = activityRecordClass.getDeclaredField("activity");
                activityField.setAccessible(true);
                Activity activity = (Activity)activityField.get(activityRecord);
                String string = activity.getClass().getName();
                return string;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            long l = System.currentTimeMillis() - start;
        }
        return null;
    }

    public static boolean isInterestingToUser() {
        return AppForegroundUtil.isActivityInterestingToUser();
    }

    private static boolean isServiceInterestingToUser() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Field servicesField = activityThreadClass.getDeclaredField("mServices");
            servicesField.setAccessible(true);
            HashMap services = Build.VERSION.SDK_INT < 19 ? (HashMap)servicesField.get(activityThread) : (ArrayMap)servicesField.get(activityThread);
            if (services.size() < 1) {
                return false;
            }
            for (Object serviceObj : services.values()) {
                Class<?> serviceClass = serviceObj.getClass();
                Service service = (Service)serviceObj;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static boolean isActivityInterestingToUser() {
        try {
            Class<?> activityThreadClass = Class.forName("android.app.ActivityThread");
            Object activityThread = activityThreadClass.getMethod("currentActivityThread", new Class[0]).invoke(null, new Object[0]);
            Field activitiesField = activityThreadClass.getDeclaredField("mActivities");
            activitiesField.setAccessible(true);
            HashMap activities = Build.VERSION.SDK_INT < 19 ? (HashMap)activitiesField.get(activityThread) : (ArrayMap)activitiesField.get(activityThread);
            if (activities.size() < 1) {
                return false;
            }
            for (Object activityRecord : activities.values()) {
                Class<?> activityRecordClass = activityRecord.getClass();
                Field pausedField = activityRecordClass.getDeclaredField("paused");
                pausedField.setAccessible(true);
                if (pausedField.getBoolean(activityRecord)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private final class Controller
    implements Application.ActivityLifecycleCallbacks,
    ComponentCallbacks2 {
        private Controller() {
        }

        public void onActivityStarted(Activity activity) {
            AppForegroundUtil.this.updateScene(activity);
            AppForegroundUtil.this.onDispatchForeground(AppForegroundUtil.this.getVisibleScene());
        }

        public void onActivityStopped(Activity activity) {
            if (AppForegroundUtil.getTopActivityName() == null) {
                AppForegroundUtil.this.onDispatchBackground(AppForegroundUtil.this.getVisibleScene());
            }
        }

        public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
        }

        public void onActivityDestroyed(Activity activity) {
        }

        public void onActivityResumed(Activity activity) {
        }

        public void onActivityPaused(Activity activity) {
        }

        public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
        }

        public void onConfigurationChanged(Configuration newConfig) {
        }

        public void onLowMemory() {
        }

        public void onTrimMemory(int level) {
            if (level == 20 && AppForegroundUtil.this.isAppForeground) {
                AppForegroundUtil.this.onDispatchBackground(AppForegroundUtil.this.visibleScene);
            }
        }
    }
}

