/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.util;

import android.util.Log;
import com.tencent.matrix.trace.core.AppMethodBeat;
import com.tencent.matrix.trace.items.MethodItem;
import com.tencent.matrix.util.MatrixLog;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class TraceDataUtils {
    private static final String TAG = "Matrix.TraceDataUtils";

    public static void structuredDataToStack(long[] buffer, LinkedList<MethodItem> result, boolean isStrict, long endTime) {
        long lastInId = 0L;
        int depth = 0;
        LinkedList<Long> rawData = new LinkedList<Long>();
        boolean isBegin = !isStrict;
        for (long trueId : buffer) {
            if (0L == trueId) continue;
            if (isStrict) {
                if (TraceDataUtils.isIn(trueId) && 1048574 == TraceDataUtils.getMethodId(trueId)) {
                    isBegin = true;
                }
                if (!isBegin) continue;
            }
            if (TraceDataUtils.isIn(trueId)) {
                lastInId = TraceDataUtils.getMethodId(trueId);
                if (lastInId == 1048574L) {
                    depth = 0;
                }
                ++depth;
                rawData.push(trueId);
                continue;
            }
            int outMethodId = TraceDataUtils.getMethodId(trueId);
            if (!rawData.isEmpty()) {
                long inTime;
                int inMethodId;
                long in = (Long)rawData.pop();
                --depth;
                LinkedList<Long> tmp = new LinkedList<Long>();
                tmp.add(in);
                while ((inMethodId = TraceDataUtils.getMethodId(in)) != outMethodId && !rawData.isEmpty()) {
                    MatrixLog.w((String)TAG, (String)"pop inMethodId[%s] to continue match ouMethodId[%s]", (Object[])new Object[]{inMethodId, outMethodId});
                    in = (Long)rawData.pop();
                    --depth;
                    tmp.add(in);
                }
                if (inMethodId != outMethodId && inMethodId == 1048574) {
                    MatrixLog.e((String)TAG, (String)"inMethodId[%s] != outMethodId[%s] throw this outMethodId!", (Object[])new Object[]{inMethodId, outMethodId});
                    rawData.addAll(tmp);
                    depth += rawData.size();
                    continue;
                }
                long outTime = TraceDataUtils.getTime(trueId);
                long during = outTime - (inTime = TraceDataUtils.getTime(in));
                if (during < 0L) {
                    MatrixLog.e((String)TAG, (String)"[structuredDataToStack] trace during invalid:%d", (Object[])new Object[]{during});
                    rawData.clear();
                    result.clear();
                    return;
                }
                MethodItem methodItem = new MethodItem(outMethodId, (int)during, depth);
                TraceDataUtils.addMethodItem(result, methodItem);
                continue;
            }
            MatrixLog.w((String)TAG, (String)"[structuredDataToStack] method[%s] not found in! ", (Object[])new Object[]{outMethodId});
        }
        while (!rawData.isEmpty() && isStrict) {
            long trueId = (Long)rawData.pop();
            int methodId = TraceDataUtils.getMethodId(trueId);
            boolean isIn = TraceDataUtils.isIn(trueId);
            long inTime = TraceDataUtils.getTime(trueId) + AppMethodBeat.getDiffTime();
            MatrixLog.w((String)TAG, (String)"[structuredDataToStack] has never out method[%s], isIn:%s, inTime:%s, endTime:%s,rawData size:%s", (Object[])new Object[]{methodId, isIn, inTime, endTime, rawData.size()});
            if (!isIn) {
                MatrixLog.e((String)TAG, (String)"[structuredDataToStack] why has out Method[%s]? is wrong! ", (Object[])new Object[]{methodId});
                continue;
            }
            MethodItem methodItem = new MethodItem(methodId, (int)(endTime - inTime), rawData.size());
            TraceDataUtils.addMethodItem(result, methodItem);
        }
        TreeNode root = new TreeNode(null, null);
        int count = TraceDataUtils.stackToTree(result, root);
        MatrixLog.i((String)TAG, (String)"stackToTree: count=%s", (Object[])new Object[]{count});
        result.clear();
        TraceDataUtils.treeToStack(root, result);
    }

    private static boolean isIn(long trueId) {
        return (trueId >> 63 & 1L) == 1L;
    }

    private static long getTime(long trueId) {
        return trueId & 0x7FFFFFFFFFFL;
    }

    private static int getMethodId(long trueId) {
        return (int)(trueId >> 43 & 0xFFFFFL);
    }

    private static int addMethodItem(LinkedList<MethodItem> resultStack, MethodItem item) {
        if (AppMethodBeat.isDev) {
            Log.v((String)TAG, (String)("method:" + item));
        }
        MethodItem last = null;
        if (!resultStack.isEmpty()) {
            last = resultStack.peek();
        }
        if (null != last && last.methodId == item.methodId && last.depth == item.depth && 0 != item.depth) {
            item.durTime = item.durTime == 5000 ? last.durTime : item.durTime;
            last.mergeMore(item.durTime);
            return last.durTime;
        }
        resultStack.push(item);
        return item.durTime;
    }

    private static void treeToStack(TreeNode root, LinkedList<MethodItem> list) {
        for (int i = 0; i < root.children.size(); ++i) {
            TreeNode node = root.children.get(i);
            if (null == node) continue;
            if (node.item != null) {
                list.add(node.item);
            }
            if (node.children.isEmpty()) continue;
            TraceDataUtils.treeToStack(node, list);
        }
    }

    public static int stackToTree(LinkedList<MethodItem> resultStack, TreeNode root) {
        TreeNode lastNode = null;
        ListIterator<MethodItem> iterator = resultStack.listIterator(0);
        int count = 0;
        while (iterator.hasNext()) {
            TreeNode node = new TreeNode(iterator.next(), lastNode);
            ++count;
            if (null == lastNode && node.depth() != 0) {
                MatrixLog.e((String)TAG, (String)"[stackToTree] begin error! why the first node'depth is not 0!", (Object[])new Object[0]);
                return 0;
            }
            int depth = node.depth();
            if (lastNode == null || depth == 0) {
                root.add(node);
            } else if (lastNode.depth() >= depth) {
                while (null != lastNode && lastNode.depth() > depth) {
                    lastNode = lastNode.father;
                }
                if (lastNode != null && lastNode.father != null) {
                    node.father = lastNode.father;
                    lastNode.father.add(node);
                }
            } else {
                lastNode.add(node);
            }
            lastNode = node;
        }
        return count;
    }

    public static long stackToString(LinkedList<MethodItem> stack, StringBuilder reportBuilder, StringBuilder logcatBuilder) {
        logcatBuilder.append("|*\t\tTraceStack:").append("\n");
        logcatBuilder.append("|*\t\t[id count cost]").append("\n");
        Iterator listIterator = stack.iterator();
        long stackCost = 0L;
        while (listIterator.hasNext()) {
            MethodItem item = (MethodItem)listIterator.next();
            reportBuilder.append(item.toString()).append('\n');
            logcatBuilder.append("|*\t\t").append(item.print()).append('\n');
            if (stackCost >= (long)item.durTime) continue;
            stackCost = item.durTime;
        }
        return stackCost;
    }

    public static int countTreeNode(TreeNode node) {
        int count = node.children.size();
        Iterator iterator = node.children.iterator();
        while (iterator.hasNext()) {
            count += TraceDataUtils.countTreeNode((TreeNode)iterator.next());
        }
        return count;
    }

    public static void printTree(TreeNode root, StringBuilder print) {
        print.append("|*   TraceStack: ").append("\n");
        TraceDataUtils.printTree(root, 0, print, "|*        ");
    }

    public static void printTree(TreeNode root, int depth, StringBuilder ss, String prefixStr) {
        int i;
        StringBuilder empty = new StringBuilder(prefixStr);
        for (i = 0; i <= depth; ++i) {
            empty.append("    ");
        }
        for (i = 0; i < root.children.size(); ++i) {
            TreeNode node = root.children.get(i);
            ss.append(empty.toString()).append(node.item.methodId).append("[").append(node.item.durTime).append("]").append("\n");
            if (node.children.isEmpty()) continue;
            TraceDataUtils.printTree(node, depth + 1, ss, prefixStr);
        }
    }

    public static void trimStack(List<MethodItem> stack, int targetCount, IStructuredDataFilter filter) {
        int size;
        if (0 > targetCount) {
            stack.clear();
            return;
        }
        int filterCount = 1;
        int curStackSize = stack.size();
        while (curStackSize > targetCount) {
            ListIterator<MethodItem> iterator = stack.listIterator(stack.size());
            while (iterator.hasPrevious()) {
                MethodItem item = iterator.previous();
                if (!filter.isFilter(item.durTime, filterCount)) continue;
                iterator.remove();
                if (--curStackSize > targetCount) continue;
                return;
            }
            curStackSize = stack.size();
            if (filter.getFilterMaxCount() >= ++filterCount) continue;
            break;
        }
        if ((size = stack.size()) > targetCount) {
            filter.fallback(stack, size);
        }
    }

    @Deprecated
    public static String getTreeKey(List<MethodItem> stack, final int targetCount) {
        StringBuilder ss = new StringBuilder();
        LinkedList<MethodItem> tmp = new LinkedList<MethodItem>(stack);
        TraceDataUtils.trimStack(tmp, targetCount, new IStructuredDataFilter(){

            @Override
            public boolean isFilter(long during, int filterCount) {
                return during < (long)(filterCount * 5);
            }

            @Override
            public int getFilterMaxCount() {
                return 60;
            }

            @Override
            public void fallback(List<MethodItem> stack, int size) {
                MatrixLog.w((String)TraceDataUtils.TAG, (String)"[getTreeKey] size:%s targetSize:%s", (Object[])new Object[]{size, targetCount});
                ListIterator<MethodItem> iterator = stack.listIterator(Math.min(size, targetCount));
                while (iterator.hasNext()) {
                    iterator.next();
                    iterator.remove();
                }
            }
        });
        for (MethodItem item : tmp) {
            ss.append(item.methodId + "|");
        }
        return ss.toString();
    }

    public static String getTreeKey(List<MethodItem> stack, long stackCost) {
        StringBuilder ss;
        block4: {
            MethodItem item2;
            ss = new StringBuilder();
            long allLimit = (long)((float)stackCost * 0.3f);
            LinkedList<MethodItem> sortList = new LinkedList<MethodItem>();
            for (MethodItem item2 : stack) {
                if ((long)item2.durTime < allLimit) continue;
                sortList.add(item2);
            }
            Collections.sort(sortList, new Comparator<MethodItem>(){

                @Override
                public int compare(MethodItem o1, MethodItem o2) {
                    return Integer.compare((o2.depth + 1) * o2.durTime, (o1.depth + 1) * o1.durTime);
                }
            });
            if (sortList.isEmpty() && !stack.isEmpty()) {
                MethodItem root = stack.get(0);
                sortList.add(root);
            } else if (sortList.size() > 1 && ((MethodItem)sortList.peek()).methodId == 1048574) {
                sortList.removeFirst();
            }
            Iterator<MethodItem> iterator = sortList.iterator();
            if (!iterator.hasNext()) break block4;
            item2 = iterator.next();
            ss.append(item2.methodId + "|");
        }
        return ss.toString();
    }

    public static final class TreeNode {
        MethodItem item;
        TreeNode father;
        LinkedList<TreeNode> children = new LinkedList();

        TreeNode(MethodItem item, TreeNode father) {
            this.item = item;
            this.father = father;
        }

        private int depth() {
            return null == this.item ? 0 : this.item.depth;
        }

        private void add(TreeNode node) {
            this.children.addFirst(node);
        }

        private boolean isLeaf() {
            return this.children.isEmpty();
        }
    }

    public static interface IStructuredDataFilter {
        public boolean isFilter(long var1, int var3);

        public int getFilterMaxCount();

        public void fallback(List<MethodItem> var1, int var2);
    }
}

