/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.util;

import android.os.Looper;
import com.tencent.matrix.util.DeviceUtil;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Utils {
    public static String getStack() {
        StackTraceElement[] trace = new Throwable().getStackTrace();
        return Utils.getStack(trace);
    }

    public static String getStack(StackTraceElement[] trace) {
        return Utils.getStack(trace, "", -1);
    }

    public static String getStack(StackTraceElement[] trace, String preFixStr, int limit) {
        if (trace == null || trace.length < 3) {
            return "";
        }
        if (limit < 0) {
            limit = Integer.MAX_VALUE;
        }
        StringBuilder t = new StringBuilder(" \n");
        for (int i = 3; i < trace.length - 3 && i < limit; ++i) {
            t.append(preFixStr);
            t.append("at ");
            t.append(trace[i].getClassName());
            t.append(":");
            t.append(trace[i].getMethodName());
            t.append("(" + trace[i].getLineNumber() + ")");
            t.append("\n");
        }
        return t.toString();
    }

    public static String getWholeStack(StackTraceElement[] trace, String preFixStr) {
        if (trace == null || trace.length < 3) {
            return "";
        }
        StringBuilder t = new StringBuilder(" \n");
        for (int i = 0; i < trace.length; ++i) {
            t.append(preFixStr);
            t.append("at ");
            t.append(trace[i].getClassName());
            t.append(":");
            t.append(trace[i].getMethodName());
            t.append("(" + trace[i].getLineNumber() + ")");
            t.append("\n");
        }
        return t.toString();
    }

    public static String getWholeStack(StackTraceElement[] trace) {
        StringBuilder stackTrace = new StringBuilder();
        for (StackTraceElement stackTraceElement : trace) {
            stackTrace.append(stackTraceElement.toString()).append("\n");
        }
        return stackTrace.toString();
    }

    public static String getMainThreadJavaStackTrace() {
        StringBuilder stackTrace = new StringBuilder();
        for (StackTraceElement stackTraceElement : Looper.getMainLooper().getThread().getStackTrace()) {
            stackTrace.append(stackTraceElement.toString()).append("\n");
        }
        return stackTrace.toString();
    }

    public static String getJavaStackTrace() {
        StringBuilder stackTrace = new StringBuilder();
        for (StackTraceElement stackTraceElement : Thread.currentThread().getStackTrace()) {
            stackTrace.append(stackTraceElement.toString()).append("\n");
        }
        return stackTrace.toString();
    }

    public static boolean isEmpty(String str) {
        return null == str || str.equals("");
    }

    public static int[] getProcessPriority(int pid) {
        String name = String.format("/proc/%s/stat", pid);
        int priority = Integer.MIN_VALUE;
        int nice = Integer.MAX_VALUE;
        try {
            String content = DeviceUtil.getStringFromFile((String)name).trim();
            String[] args = content.split(" ");
            if (args.length >= 19) {
                priority = Integer.parseInt(args[17].trim());
                nice = Integer.parseInt(args[18].trim());
            }
        }
        catch (Exception e) {
            return new int[]{priority, nice};
        }
        return new int[]{priority, nice};
    }

    public static String formatTime(long timestamp) {
        return new SimpleDateFormat("[yy-MM-dd HH:mm:ss]").format(new Date(timestamp));
    }
}

