/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.util;

import android.view.View;
import android.view.ViewGroup;

public class ViewUtil {
    public static ViewInfo dumpViewInfo(View view) {
        ViewInfo info = new ViewInfo();
        ViewUtil.traversalViewTree(info, 0, view);
        return info;
    }

    private static void traversalViewTree(ViewInfo info, int deep, View view) {
        if (view == null) {
            return;
        }
        if (++deep > info.mViewDeep) {
            info.mViewDeep = deep;
        }
        if (!(view instanceof ViewGroup)) {
            return;
        }
        ViewGroup grp = (ViewGroup)view;
        int n = grp.getChildCount();
        if (n <= 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            View v = grp.getChildAt(i);
            if (null != v && v.getVisibility() == 8) continue;
            ++info.mViewCount;
            ViewUtil.traversalViewTree(info, deep, v);
        }
    }

    public static class ViewInfo {
        public int mViewCount = 0;
        public int mViewDeep = 0;
        public String mActivityName = "";

        public String toString() {
            return "ViewCount:" + this.mViewCount + ",ViewDeep:" + this.mViewDeep + ",mActivityName:" + this.mActivityName;
        }
    }
}

