/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.DashPathEffect;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PathEffect;
import android.text.TextPaint;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.RequiresApi;
import com.tencent.matrix.trace.R;
import java.util.LinkedList;

@RequiresApi(value=24)
public class FloatFrameView
extends LinearLayout {
    public TextView fpsView;
    public TextView sceneView;
    public LineChartView chartView;
    public TextView extraInfoView;
    public TextView unknownDelayDurationView;
    public TextView inputHandlingDurationView;
    public TextView animationDurationView;
    public TextView layoutMeasureDurationView;
    public TextView drawDurationView;
    public TextView syncDurationView;
    public TextView commandIssueDurationView;
    public TextView swapBuffersDurationView;
    public TextView gpuDurationView;
    public TextView totalDurationView;
    public TextView sumNormalView;
    public TextView sumMiddleView;
    public TextView sumHighView;
    public TextView sumFrozenView;
    public TextView levelNormalView;
    public TextView levelMiddleView;
    public TextView levelHighView;
    public TextView levelFrozenView;

    public FloatFrameView(Context context) {
        super(context);
        this.initView(context);
    }

    public FloatFrameView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    private void initView(Context context) {
        this.setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        LayoutInflater.from((Context)context).inflate(R.layout.float_frame_view, (ViewGroup)this);
        this.fpsView = (TextView)this.findViewById(R.id.fps_view);
        this.extraInfoView = (TextView)this.findViewById(R.id.extra_info);
        this.sceneView = (TextView)this.findViewById(R.id.scene_view);
        this.extraInfoView.setText((CharSequence)"{other info}");
        this.unknownDelayDurationView = (TextView)this.findViewById(R.id.unknown_delay_duration_tv);
        this.inputHandlingDurationView = (TextView)this.findViewById(R.id.input_handling_duration_tv);
        this.animationDurationView = (TextView)this.findViewById(R.id.animation_duration_tv);
        this.layoutMeasureDurationView = (TextView)this.findViewById(R.id.layout_measure_duration_tv);
        this.drawDurationView = (TextView)this.findViewById(R.id.draw_duration_tv);
        this.syncDurationView = (TextView)this.findViewById(R.id.sync_duration_tv);
        this.commandIssueDurationView = (TextView)this.findViewById(R.id.command_issue_duration_tv);
        this.swapBuffersDurationView = (TextView)this.findViewById(R.id.swap_buffers_duration_tv);
        this.gpuDurationView = (TextView)this.findViewById(R.id.gpu_duration_tv);
        this.totalDurationView = (TextView)this.findViewById(R.id.total_duration_tv);
        this.sumNormalView = (TextView)this.findViewById(R.id.sum_normal);
        this.sumMiddleView = (TextView)this.findViewById(R.id.sum_middle);
        this.sumHighView = (TextView)this.findViewById(R.id.sum_high);
        this.sumFrozenView = (TextView)this.findViewById(R.id.sum_frozen);
        this.levelNormalView = (TextView)this.findViewById(R.id.level_normal);
        this.levelMiddleView = (TextView)this.findViewById(R.id.level_middle);
        this.levelHighView = (TextView)this.findViewById(R.id.level_high);
        this.levelFrozenView = (TextView)this.findViewById(R.id.level_frozen);
        this.chartView = (LineChartView)this.findViewById(R.id.chart);
    }

    public static class LineChartView
    extends View {
        private final Paint paint;
        private final TextPaint tipPaint;
        private final Paint levelLinePaint;
        private final Paint tipLinePaint;
        private static final int LINE_COUNT = 50;
        private final LinkedList<LineInfo> lines;
        float linePadding;
        float lineStrokeWidth;
        private Path topPath = new Path();
        private Path middlePath = new Path();
        private float[] topTip = new float[2];
        private float[] middleTip = new float[2];
        private int bestColor = this.getContext().getResources().getColor(R.color.level_best_color);
        private int normalColor = this.getContext().getResources().getColor(R.color.level_normal_color);
        private int middleColor = this.getContext().getResources().getColor(R.color.level_middle_color);
        private int highColor = this.getContext().getResources().getColor(R.color.level_high_color);
        private int frozenColor = this.getContext().getResources().getColor(R.color.level_frozen_color);
        private int grayColor = this.getContext().getResources().getColor(R.color.dark_text);
        float padding = LineChartView.dip2px(this.getContext(), 8.0f);
        float width;
        float lineContentWidth;
        float height;
        float textSize;

        public LineChartView(Context context, AttributeSet attrs, int defStyleAttr) {
            super(context, attrs, defStyleAttr);
            this.paint = new Paint();
            this.tipPaint = new TextPaint(1);
            this.textSize = LineChartView.dip2px(this.getContext(), 8.0f);
            this.tipPaint.setTextSize(this.textSize);
            this.tipPaint.setStrokeWidth((float)LineChartView.dip2px(this.getContext(), 1.0f));
            this.tipPaint.setColor(this.grayColor);
            this.levelLinePaint = new TextPaint(1);
            this.levelLinePaint.setStrokeWidth((float)LineChartView.dip2px(this.getContext(), 1.0f));
            this.levelLinePaint.setStyle(Paint.Style.STROKE);
            this.levelLinePaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{6.0f, 6.0f}, 0.0f));
            this.tipLinePaint = new Paint((Paint)this.tipPaint);
            this.tipLinePaint.setStrokeWidth((float)LineChartView.dip2px(this.getContext(), 1.0f));
            this.tipLinePaint.setColor(this.grayColor);
            this.tipLinePaint.setStyle(Paint.Style.STROKE);
            this.tipLinePaint.setPathEffect((PathEffect)new DashPathEffect(new float[]{6.0f, 6.0f}, 0.0f));
            this.lines = new LinkedList();
        }

        public LineChartView(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
            super.onLayout(changed, left, top, right, bottom);
            if (changed) {
                this.width = this.getMeasuredWidth();
                this.height = this.getMeasuredHeight();
                this.lineContentWidth = this.width - 3.0f * this.padding;
                this.lineStrokeWidth = LineChartView.dip2px(this.getContext(), 1.0f);
                this.paint.setStrokeWidth(this.lineStrokeWidth);
                this.linePadding = this.lineStrokeWidth * 2.0f;
                float rate = this.lineContentWidth / 60.0f;
                this.topTip[0] = 10.0f * rate + (this.width - this.lineContentWidth);
                this.topTip[1] = 50.0f * this.linePadding + this.padding;
                this.topPath.moveTo(this.topTip[0], this.topTip[1]);
                this.topPath.lineTo(this.topTip[0], 0.0f);
                this.middleTip[0] = 30.0f * rate + (this.width - this.lineContentWidth);
                this.middleTip[1] = 50.0f * this.linePadding + this.padding;
                this.middlePath.moveTo(this.middleTip[0], this.middleTip[1]);
                this.middlePath.lineTo(this.middleTip[0], 0.0f);
            }
        }

        public void addFps(int fps, int color2) {
            LineInfo linePoint = new LineInfo(fps, color2);
            if (this.lines.size() >= 50) {
                this.lines.removeLast();
            }
            this.lines.addFirst(linePoint);
            this.invalidate();
        }

        @SuppressLint(value={"DefaultLocale"})
        public void draw(Canvas canvas) {
            super.draw(canvas);
            int index = 1;
            int sumFps = 0;
            for (LineInfo lineInfo : this.lines) {
                sumFps += lineInfo.fps;
                lineInfo.draw(canvas, index);
                if (index % 25 == 0) {
                    Path path = new Path();
                    float pathY = lineInfo.linePoint[1];
                    path.moveTo(0.0f, pathY);
                    path.lineTo((float)this.getMeasuredHeight(), pathY);
                    canvas.drawPath(path, this.tipLinePaint);
                    this.tipPaint.setColor(this.grayColor);
                    canvas.drawText(index / 5 + "s", 0.0f, pathY + this.textSize, (Paint)this.tipPaint);
                    if (index > 0) {
                        int aver = sumFps / index;
                        this.tipPaint.setColor(this.getColor(aver));
                        canvas.drawText(aver + "FPS", 0.0f, pathY - this.textSize / 2.0f, (Paint)this.tipPaint);
                    }
                }
                ++index;
            }
            this.tipPaint.setColor(this.grayColor);
            this.levelLinePaint.setColor(this.normalColor);
            canvas.drawPath(this.topPath, this.levelLinePaint);
            canvas.drawText("50", this.topTip[0] - this.textSize / 2.0f, this.topTip[1] + this.textSize, (Paint)this.tipPaint);
            this.levelLinePaint.setColor(this.middleColor);
            canvas.drawPath(this.middlePath, this.levelLinePaint);
            canvas.drawText("30", this.middleTip[0] - this.textSize / 2.0f, this.middleTip[1] + this.textSize, (Paint)this.tipPaint);
        }

        public static int dip2px(Context context, float dpValue) {
            float scale = context.getResources().getDisplayMetrics().density;
            return (int)(dpValue * scale + 0.5f);
        }

        private int getColor(int fps) {
            int color2 = fps > 57 ? this.bestColor : (fps > 51 ? this.normalColor : (fps > 36 ? this.middleColor : (fps > 18 ? this.highColor : this.frozenColor)));
            return color2;
        }

        class LineInfo {
            private float[] linePoint = new float[4];
            int fps;
            int color;

            LineInfo(int fps, int color2) {
                this.fps = fps;
                this.color = color2;
                this.linePoint[0] = LineChartView.this.width;
                this.linePoint[2] = (float)(60 - fps) * LineChartView.this.lineContentWidth / 60.0f + ((float)LineChartView.this.getWidth() - LineChartView.this.lineContentWidth);
            }

            void draw(Canvas canvas, int index) {
                if (LineChartView.this.paint.getColor() != this.color) {
                    LineChartView.this.paint.setColor(this.color);
                }
                this.linePoint[1] = (float)(1 + index) * LineChartView.this.linePadding;
                this.linePoint[3] = this.linePoint[1];
                canvas.drawLine(this.linePoint[0], this.linePoint[1], this.linePoint[2], this.linePoint[3], LineChartView.this.paint);
            }
        }
    }
}

