/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.trace.view;

import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.DisplayMetrics;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.view.animation.AccelerateInterpolator;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import com.tencent.matrix.Matrix;
import com.tencent.matrix.lifecycle.IStateObserver;
import com.tencent.matrix.lifecycle.owners.ProcessUIResumedStateOwner;
import com.tencent.matrix.trace.R;
import com.tencent.matrix.trace.TracePlugin;
import com.tencent.matrix.trace.listeners.ISceneFrameListener;
import com.tencent.matrix.trace.tracer.FrameTracer;
import com.tencent.matrix.trace.view.FloatFrameView;
import com.tencent.matrix.util.MatrixLog;
import java.util.Arrays;

@RequiresApi(value=24)
public class FrameDecorator
implements ISceneFrameListener {
    private static final String TAG = "Matrix.FrameDecorator";
    private WindowManager windowManager;
    private WindowManager.LayoutParams layoutParam;
    private boolean isShowing;
    private final FloatFrameView view;
    private static final Handler mainHandler = new Handler(Looper.getMainLooper());
    private static FrameDecorator instance;
    private static final Object lock;
    private View.OnClickListener clickListener;
    private final DisplayMetrics displayMetrics = new DisplayMetrics();
    private boolean isEnable = true;
    private static final int sdkInt;
    private final int bestColor;
    private final int normalColor;
    private final int middleColor;
    private final int highColor;
    private final int frozenColor;
    private int belongColor;
    private IStateObserver mProcessForegroundListener = new IStateObserver(){

        public void on() {
            FrameDecorator.this.onForeground(true);
        }

        public void off() {
            FrameDecorator.this.onForeground(false);
        }
    };

    @SuppressLint(value={"ClickableViewAccessibility"})
    private FrameDecorator(Context context, final FloatFrameView view) {
        this.view = view;
        this.bestColor = context.getResources().getColor(R.color.level_best_color);
        this.normalColor = context.getResources().getColor(R.color.level_normal_color);
        this.middleColor = context.getResources().getColor(R.color.level_middle_color);
        this.highColor = context.getResources().getColor(R.color.level_high_color);
        this.frozenColor = context.getResources().getColor(R.color.level_frozen_color);
        this.belongColor = this.bestColor;
        ProcessUIResumedStateOwner.INSTANCE.observeForever(this.mProcessForegroundListener);
        view.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

            public void onViewAttachedToWindow(View v) {
                TracePlugin tracePlugin;
                MatrixLog.i((String)FrameDecorator.TAG, (String)"onViewAttachedToWindow", (Object[])new Object[0]);
                if (Matrix.isInstalled() && null != (tracePlugin = (TracePlugin)Matrix.with().getPluginByClass(TracePlugin.class))) {
                    FrameTracer tracer = tracePlugin.getFrameTracer();
                    tracer.register(FrameDecorator.this);
                }
            }

            public void onViewDetachedFromWindow(View v) {
                TracePlugin tracePlugin;
                MatrixLog.i((String)FrameDecorator.TAG, (String)"onViewDetachedFromWindow", (Object[])new Object[0]);
                if (Matrix.isInstalled() && null != (tracePlugin = (TracePlugin)Matrix.with().getPluginByClass(TracePlugin.class))) {
                    FrameTracer tracer = tracePlugin.getFrameTracer();
                    tracer.unregister(FrameDecorator.this);
                }
            }
        });
        this.initLayoutParams(context);
        view.setOnTouchListener(new View.OnTouchListener(){
            float downX = 0.0f;
            float downY = 0.0f;
            int downOffsetX = 0;
            int downOffsetY = 0;

            public boolean onTouch(final View v, MotionEvent event) {
                switch (event.getAction()) {
                    case 0: {
                        this.downX = event.getX();
                        this.downY = event.getY();
                        this.downOffsetX = ((FrameDecorator)FrameDecorator.this).layoutParam.x;
                        this.downOffsetY = ((FrameDecorator)FrameDecorator.this).layoutParam.y;
                        break;
                    }
                    case 2: {
                        float moveX = event.getX();
                        float moveY = event.getY();
                        ((FrameDecorator)FrameDecorator.this).layoutParam.x = (int)((float)((FrameDecorator)FrameDecorator.this).layoutParam.x + (moveX - this.downX) / 3.0f);
                        ((FrameDecorator)FrameDecorator.this).layoutParam.y = (int)((float)((FrameDecorator)FrameDecorator.this).layoutParam.y + (moveY - this.downY) / 3.0f);
                        if (v == null) break;
                        FrameDecorator.this.windowManager.updateViewLayout(v, (ViewGroup.LayoutParams)FrameDecorator.this.layoutParam);
                        break;
                    }
                    case 1: {
                        PropertyValuesHolder holder = PropertyValuesHolder.ofInt((String)"trans", (int[])new int[]{((FrameDecorator)FrameDecorator.this).layoutParam.x, ((FrameDecorator)FrameDecorator.this).layoutParam.x > ((FrameDecorator)FrameDecorator.this).displayMetrics.widthPixels / 2 ? ((FrameDecorator)FrameDecorator.this).displayMetrics.widthPixels - view.getWidth() : 0});
                        ValueAnimator animator = ValueAnimator.ofPropertyValuesHolder((PropertyValuesHolder[])new PropertyValuesHolder[]{holder});
                        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                            public void onAnimationUpdate(ValueAnimator animation) {
                                if (!FrameDecorator.this.isShowing) {
                                    return;
                                }
                                ((FrameDecorator)FrameDecorator.this).layoutParam.x = (Integer)animation.getAnimatedValue("trans");
                                FrameDecorator.this.windowManager.updateViewLayout(v, (ViewGroup.LayoutParams)FrameDecorator.this.layoutParam);
                            }
                        });
                        animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
                        animator.setDuration(180L).start();
                        int upOffsetX = ((FrameDecorator)FrameDecorator.this).layoutParam.x;
                        int upOffsetY = ((FrameDecorator)FrameDecorator.this).layoutParam.y;
                        if (Math.abs(upOffsetX - this.downOffsetX) > 20 || Math.abs(upOffsetY - this.downOffsetY) > 20 || null == FrameDecorator.this.clickListener) break;
                        FrameDecorator.this.clickListener.onClick(v);
                    }
                }
                return true;
            }
        });
    }

    public void setClickListener(View.OnClickListener clickListener) {
        this.clickListener = clickListener;
    }

    public void setExtraInfo(String info) {
        TextView textView;
        if (this.getView() != null && null != (textView = (TextView)this.getView().findViewById(R.id.extra_info))) {
            textView.setText((CharSequence)info);
        }
    }

    public static FrameDecorator get() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FrameDecorator getInstance(final Context context) {
        if (instance == null) {
            if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
                instance = new FrameDecorator(context, new FloatFrameView(context));
            } else {
                try {
                    Object object = lock;
                    synchronized (object) {
                        mainHandler.post(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                instance = new FrameDecorator(context, new FloatFrameView(context));
                                Object object = lock;
                                synchronized (object) {
                                    lock.notifyAll();
                                }
                            }
                        });
                        lock.wait();
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return instance;
    }

    public FloatFrameView getView() {
        return this.view;
    }

    private void initLayoutParams(Context context) {
        this.windowManager = (WindowManager)context.getApplicationContext().getSystemService("window");
        try {
            DisplayMetrics metrics = new DisplayMetrics();
            if (null != this.windowManager.getDefaultDisplay()) {
                this.windowManager.getDefaultDisplay().getMetrics(this.displayMetrics);
                this.windowManager.getDefaultDisplay().getMetrics(metrics);
            }
            this.layoutParam = new WindowManager.LayoutParams();
            this.layoutParam.type = Build.VERSION.SDK_INT >= 26 ? 2038 : 2002;
            this.layoutParam.flags = 40;
            this.layoutParam.gravity = 0x800033;
            if (null != this.view) {
                this.layoutParam.x = metrics.widthPixels - this.view.getLayoutParams().width * 2;
            }
            this.layoutParam.y = 0;
            this.layoutParam.width = -2;
            this.layoutParam.height = -2;
            this.layoutParam.format = -2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void show() {
        if (!this.isEnable) {
            return;
        }
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (!FrameDecorator.this.isShowing) {
                    FrameDecorator.this.isShowing = true;
                    FrameDecorator.this.windowManager.addView((View)FrameDecorator.this.view, (ViewGroup.LayoutParams)FrameDecorator.this.layoutParam);
                }
            }
        });
    }

    public boolean isEnable() {
        return this.isEnable;
    }

    public void setEnable(boolean enable) {
        this.isEnable = enable;
    }

    public void dismiss() {
        if (!this.isEnable) {
            return;
        }
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                if (FrameDecorator.this.isShowing) {
                    FrameDecorator.this.isShowing = false;
                    FrameDecorator.this.windowManager.removeView((View)FrameDecorator.this.view);
                }
            }
        });
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    private void onForeground(final boolean isForeground) {
        MatrixLog.i((String)TAG, (String)"[onForeground] isForeground:%s", (Object[])new Object[]{isForeground});
        if (!this.isEnable) {
            return;
        }
        if (mainHandler != null) {
            mainHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (isForeground) {
                        FrameDecorator.this.show();
                    } else {
                        FrameDecorator.this.dismiss();
                    }
                }
            });
        }
    }

    @Override
    public int getIntervalMs() {
        return 200;
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public boolean skipFirstFrame() {
        return false;
    }

    @Override
    public int getThreshold() {
        return 0;
    }

    @Override
    @SuppressLint(value={"DefaultLocale"})
    public void onFrameMetricsAvailable(@NonNull String sceneName, long[] avgDurations, int[] dropLevel, int[] dropSum, float avgDroppedFrame, float avgRefreshRate, final float fps) {
        final String unknownDelay = String.format("unknown delay: %.1fms", (double)avgDurations[FrameTracer.FrameDuration.UNKNOWN_DELAY_DURATION.ordinal()] / 1000000.0);
        final String inputHandling = String.format("input handling: %.1fms", (double)avgDurations[FrameTracer.FrameDuration.INPUT_HANDLING_DURATION.ordinal()] / 1000000.0);
        final String animation = String.format("animation: %.1fms", (double)avgDurations[FrameTracer.FrameDuration.ANIMATION_DURATION.ordinal()] / 1000000.0);
        final String layoutMeasure = String.format("layout measure: %.1fms", (double)avgDurations[FrameTracer.FrameDuration.LAYOUT_MEASURE_DURATION.ordinal()] / 1000000.0);
        final String draw = String.format("draw: %.1fms", (double)avgDurations[FrameTracer.FrameDuration.DRAW_DURATION.ordinal()] / 1000000.0);
        final String sync = String.format("sync: %.1fms", (double)avgDurations[FrameTracer.FrameDuration.SYNC_DURATION.ordinal()] / 1000000.0);
        final String commandIssue = String.format("command issue: %.1fms", (double)avgDurations[FrameTracer.FrameDuration.COMMAND_ISSUE_DURATION.ordinal()] / 1000000.0);
        final String swapBuffers = String.format("swap buffers: %.1fms", (double)avgDurations[FrameTracer.FrameDuration.SWAP_BUFFERS_DURATION.ordinal()] / 1000000.0);
        final String gpu = String.format("gpu: %.1fms", (double)avgDurations[FrameTracer.FrameDuration.GPU_DURATION.ordinal()] / 1000000.0);
        final String total = String.format("total: %.1fms", (double)avgDurations[FrameTracer.FrameDuration.TOTAL_DURATION.ordinal()] / 1000000.0);
        this.belongColor = fps <= avgRefreshRate - 42.0f ? this.frozenColor : (fps <= avgRefreshRate - 24.0f ? this.highColor : (fps <= avgRefreshRate - 9.0f ? this.middleColor : (fps <= avgRefreshRate - 3.0f ? this.normalColor : this.bestColor)));
        final int[] level = Arrays.copyOf(dropLevel, dropLevel.length);
        final int[] sum = Arrays.copyOf(dropSum, dropSum.length);
        mainHandler.post(new Runnable(){

            @Override
            public void run() {
                ((FrameDecorator)FrameDecorator.this).view.chartView.addFps((int)fps, FrameDecorator.this.belongColor);
                ((FrameDecorator)FrameDecorator.this).view.fpsView.setText((CharSequence)String.format("%.2f FPS", Float.valueOf(fps)));
                ((FrameDecorator)FrameDecorator.this).view.fpsView.setTextColor(FrameDecorator.this.belongColor);
                ((FrameDecorator)FrameDecorator.this).view.unknownDelayDurationView.setText((CharSequence)unknownDelay);
                ((FrameDecorator)FrameDecorator.this).view.inputHandlingDurationView.setText((CharSequence)inputHandling);
                ((FrameDecorator)FrameDecorator.this).view.animationDurationView.setText((CharSequence)animation);
                ((FrameDecorator)FrameDecorator.this).view.layoutMeasureDurationView.setText((CharSequence)layoutMeasure);
                ((FrameDecorator)FrameDecorator.this).view.drawDurationView.setText((CharSequence)draw);
                ((FrameDecorator)FrameDecorator.this).view.syncDurationView.setText((CharSequence)sync);
                ((FrameDecorator)FrameDecorator.this).view.commandIssueDurationView.setText((CharSequence)commandIssue);
                ((FrameDecorator)FrameDecorator.this).view.swapBuffersDurationView.setText((CharSequence)swapBuffers);
                if (sdkInt >= 31) {
                    ((FrameDecorator)FrameDecorator.this).view.gpuDurationView.setText((CharSequence)gpu);
                } else {
                    ((FrameDecorator)FrameDecorator.this).view.gpuDurationView.setText((CharSequence)"gpu: unusable");
                }
                ((FrameDecorator)FrameDecorator.this).view.totalDurationView.setText((CharSequence)total);
                ((FrameDecorator)FrameDecorator.this).view.sumNormalView.setText((CharSequence)String.valueOf(sum[FrameTracer.DropStatus.DROPPED_NORMAL.ordinal()]));
                ((FrameDecorator)FrameDecorator.this).view.sumMiddleView.setText((CharSequence)String.valueOf(sum[FrameTracer.DropStatus.DROPPED_MIDDLE.ordinal()]));
                ((FrameDecorator)FrameDecorator.this).view.sumHighView.setText((CharSequence)String.valueOf(sum[FrameTracer.DropStatus.DROPPED_HIGH.ordinal()]));
                ((FrameDecorator)FrameDecorator.this).view.sumFrozenView.setText((CharSequence)String.valueOf(sum[FrameTracer.DropStatus.DROPPED_FROZEN.ordinal()]));
                ((FrameDecorator)FrameDecorator.this).view.levelNormalView.setText((CharSequence)String.valueOf(level[FrameTracer.DropStatus.DROPPED_NORMAL.ordinal()]));
                ((FrameDecorator)FrameDecorator.this).view.levelMiddleView.setText((CharSequence)String.valueOf(level[FrameTracer.DropStatus.DROPPED_MIDDLE.ordinal()]));
                ((FrameDecorator)FrameDecorator.this).view.levelHighView.setText((CharSequence)String.valueOf(level[FrameTracer.DropStatus.DROPPED_HIGH.ordinal()]));
                ((FrameDecorator)FrameDecorator.this).view.levelFrozenView.setText((CharSequence)String.valueOf(level[FrameTracer.DropStatus.DROPPED_FROZEN.ordinal()]));
            }
        });
    }

    static {
        lock = new Object();
        sdkInt = Build.VERSION.SDK_INT;
    }
}

