/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.matrix.traffic;

import androidx.annotation.Keep;
import com.tencent.matrix.plugin.Plugin;
import com.tencent.matrix.traffic.TrafficConfig;
import com.tencent.matrix.util.MatrixLog;
import com.tencent.matrix.util.MatrixUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class TrafficPlugin
extends Plugin {
    private static final String TAG = "TrafficPlugin";
    private final TrafficConfig trafficConfig;
    public static final int TYPE_GET_TRAFFIC_RX = 0;
    public static final int TYPE_GET_TRAFFIC_TX = 1;
    private static int stackTraceFilterMode = 0;
    private static String stackTraceFilterCore = "";
    private static final Map<String, String> hashStackTraceMap = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> keyHashMap = new ConcurrentHashMap<String, String>();

    public TrafficPlugin(TrafficConfig trafficConfig) {
        this.trafficConfig = trafficConfig;
    }

    public void start() {
        if (this.isPluginStarted()) {
            return;
        }
        super.start();
        MatrixLog.i((String)TAG, (String)"start", (Object[])new Object[0]);
        String[] ignoreSoFiles = this.trafficConfig.getIgnoreSoFiles();
        stackTraceFilterMode = this.trafficConfig.getStackTraceFilterMode();
        stackTraceFilterCore = this.trafficConfig.getStackTraceFilterCore();
        TrafficPlugin.nativeInitMatrixTraffic(this.trafficConfig.isRxCollectorEnable(), this.trafficConfig.isTxCollectorEnable(), this.trafficConfig.willDumpStackTrace(), this.trafficConfig.willDumpNativeBackTrace(), this.trafficConfig.willHookAllSoReadWrite(), ignoreSoFiles);
    }

    public void stop() {
        if (this.isPluginStopped()) {
            return;
        }
        super.stop();
        TrafficPlugin.nativeReleaseMatrixTraffic();
    }

    public HashMap<String, String> getTrafficInfoMap(int type) {
        return TrafficPlugin.nativeGetTrafficInfoMap(type);
    }

    public String getStackTraceByMd5(String md5) {
        return hashStackTraceMap.get(md5);
    }

    public String getJavaStackTraceByKey(String key) {
        if (!this.trafficConfig.willDumpStackTrace()) {
            return "";
        }
        String md5 = keyHashMap.get(key);
        if (md5 == null || md5.isEmpty()) {
            return "";
        }
        return hashStackTraceMap.get(md5);
    }

    public String getNativeBackTraceByKey(String key) {
        if (!this.trafficConfig.willDumpNativeBackTrace()) {
            return "";
        }
        return TrafficPlugin.nativeGetNativeBackTraceByKey(key);
    }

    public void clearTrafficInfo() {
        keyHashMap.clear();
        hashStackTraceMap.clear();
        TrafficPlugin.nativeClearTrafficInfo();
    }

    private static native void nativeInitMatrixTraffic(boolean var0, boolean var1, boolean var2, boolean var3, boolean var4, String[] var5);

    private static native String nativeGetTrafficInfo();

    private static native String nativeGetAllStackTraceTrafficInfo();

    private static native void nativeReleaseMatrixTraffic();

    private static native void nativeClearTrafficInfo();

    private static native HashMap<String, String> nativeGetTrafficInfoMap(int var0);

    private static native String nativeGetNativeBackTraceByKey(String var0);

    @Keep
    private static void setFdStackTrace(String key) {
        StringBuilder stackTrace = new StringBuilder();
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        for (int line = 0; line < stackTraceElements.length; ++line) {
            String stackTraceLine = stackTraceElements[line].toString();
            boolean willAppend = false;
            if (stackTraceFilterMode == 0) {
                willAppend = true;
            } else if (stackTraceFilterMode == 1) {
                if (stackTraceLine.startsWith(stackTraceFilterCore)) {
                    willAppend = true;
                }
            } else if (stackTraceFilterMode == 2 && stackTraceLine.matches(stackTraceFilterCore)) {
                willAppend = true;
            }
            if (!willAppend) continue;
            stackTrace.append(stackTraceLine).append("\n");
        }
        String md5 = MatrixUtil.getMD5String((String)stackTrace.toString());
        if (!hashStackTraceMap.containsKey(md5)) {
            hashStackTraceMap.put(md5, stackTrace.toString());
        }
        keyHashMap.put(key, md5);
    }

    static {
        System.loadLibrary("matrix-traffic");
    }
}

