/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.channel.a.a;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.utils.Log;

public final class SendAuth {
    private SendAuth() {
    }

    public static class Options {
        public static final int INVALID_FLAGS = -1;
        public String callbackClassName;
        public int callbackFlags = -1;

        public void toBundle(Bundle bundle) {
            bundle.putString("_wxapi_sendauth_options_callback_classname", this.callbackClassName);
            bundle.putInt("_wxapi_sendauth_options_callback_flags", this.callbackFlags);
        }

        public void fromBundle(Bundle bundle) {
            this.callbackClassName = a.a(bundle, "_wxapi_sendauth_options_callback_classname");
            this.callbackFlags = a.a(bundle, "_wxapi_sendauth_options_callback_flags", -1);
        }
    }

    public static class Resp
    extends BaseResp {
        private static final String TAG = "MicroMsg.SDK.SendAuth.Resp";
        private static final int LENGTH_LIMIT = 1024;
        public static final int ERR_SCOPE_SNSAPI_WXAAPP_INFO_CAN_ONLY_AUTHORIZED_SEPARATELY = -1000;
        public String code;
        public String state;
        public boolean authResult;
        public String url;
        public String lang;
        public String country;

        public Resp() {
            this.authResult = false;
        }

        public Resp(Bundle bundle) {
            Resp resp = this;
            resp.authResult = false;
            resp.fromBundle(bundle);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public void fromBundle(Bundle bundle) {
            super.fromBundle(bundle);
            this.code = bundle.getString("_wxapi_sendauth_resp_token");
            this.state = bundle.getString("_wxapi_sendauth_resp_state");
            this.url = bundle.getString("_wxapi_sendauth_resp_url");
            this.lang = bundle.getString("_wxapi_sendauth_resp_lang");
            this.country = bundle.getString("_wxapi_sendauth_resp_country");
            this.authResult = bundle.getBoolean("_wxapi_sendauth_resp_auth_result");
        }

        @Override
        public void toBundle(Bundle bundle) {
            Resp resp = this;
            super.toBundle(bundle);
            bundle.putString("_wxapi_sendauth_resp_token", resp.code);
            bundle.putString("_wxapi_sendauth_resp_state", this.state);
            bundle.putString("_wxapi_sendauth_resp_url", this.url);
            bundle.putString("_wxapi_sendauth_resp_lang", this.lang);
            bundle.putString("_wxapi_sendauth_resp_country", this.country);
            bundle.putBoolean("_wxapi_sendauth_resp_auth_result", this.authResult);
        }

        @Override
        public boolean checkArgs() {
            String string = ((Resp)((Object)string)).state;
            if (string != null && string.length() > 1024) {
                Log.e(TAG, "checkArgs fail, state is invalid");
                return false;
            }
            return true;
        }
    }

    public static class Req
    extends BaseReq {
        private static final String TAG = "MicroMsg.SDK.SendAuth.Req";
        private static final int LENGTH_LIMIT = 1024;
        public String scope;
        public String state;
        public String extData;
        public Options options;
        public boolean isOption1;

        public Req() {
        }

        public Req(Bundle bundle) {
            Req req = this;
            req.fromBundle(bundle);
        }

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public void fromBundle(Bundle bundle) {
            Options options;
            Options options2;
            super.fromBundle(bundle);
            this.scope = bundle.getString("_wxapi_sendauth_req_scope");
            this.state = bundle.getString("_wxapi_sendauth_req_state");
            this.extData = bundle.getString("_wxapi_sendauth_req_ext_data");
            this.isOption1 = bundle.getBoolean("_wxapi_sendauth_req_isoption1");
            Options options3 = options2 = options;
            options3();
            this.options = options3;
            options.fromBundle(bundle);
        }

        @Override
        public void toBundle(Bundle bundle) {
            Req req = options;
            super.toBundle(bundle);
            bundle.putString("_wxapi_sendauth_req_scope", req.scope);
            bundle.putString("_wxapi_sendauth_req_state", ((Req)((Object)options)).state);
            bundle.putString("_wxapi_sendauth_req_ext_data", ((Req)((Object)options)).extData);
            bundle.putBoolean("_wxapi_sendauth_req_isoption1", ((Req)((Object)options)).isOption1);
            Options options = ((Req)((Object)options)).options;
            if (options != null) {
                options.toBundle(bundle);
            }
        }

        @Override
        public boolean checkArgs() {
            String string = ((Req)((Object)string2)).scope;
            if (string != null && string.length() != 0 && ((Req)((Object)string2)).scope.length() <= 1024) {
                String string2 = ((Req)((Object)string2)).state;
                if (string2 != null && string2.length() > 1024) {
                    Log.e(TAG, "checkArgs fail, state is invalid");
                    return false;
                }
                return true;
            }
            Log.e(TAG, "checkArgs fail, scope is invalid");
            return false;
        }
    }
}

