/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelbiz;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelbase.BaseReq;
import com.tencent.mm.opensdk.modelbase.BaseResp;
import com.tencent.mm.opensdk.modelbiz.IWXChannelJumpInfo;
import com.tencent.mm.opensdk.utils.Log;
import com.tencent.mm.opensdk.utils.d;

public class WXChannelShareVideo {

    public static class Resp
    extends BaseResp {
        public String extMsg;

        public Resp() {
        }

        public Resp(Bundle bundle) {
            this.fromBundle(bundle);
        }

        @Override
        public int getType() {
            return 33;
        }

        @Override
        public void fromBundle(Bundle bundle) {
            super.fromBundle(bundle);
            this.extMsg = bundle.getString("_wxapi_finder_extMsg");
        }

        @Override
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
            bundle.putString("_wxapi_finder_extMsg", this.extMsg);
        }

        @Override
        public boolean checkArgs() {
            return true;
        }
    }

    public static class Req
    extends BaseReq {
        private static final String TAG = "MicroMsg.SDK.WXChannelShareVideo.Req";
        private static final String WX_CHANNEL_SHARE_VIDEO_JUMP_INFO_KEY_IDENTIFIER = "_wxapi_channel_share_video_jump_info_identifier";
        private static final int LENGTH_LIMIT = 1024;
        public String videoPath;
        public String extData;
        public IWXChannelJumpInfo jumpInfo;

        @Override
        public int getType() {
            return 33;
        }

        @Override
        public boolean checkArgs() {
            if (d.b(this.videoPath)) {
                Log.e(TAG, "videoPath is null");
                return false;
            }
            if (this.jumpInfo != null && !this.jumpInfo.checkArgs()) {
                Log.e(TAG, "checkArgs fail, jumpInfo is invalid");
                return false;
            }
            return true;
        }

        @Override
        public void fromBundle(Bundle bundle) {
            super.fromBundle(bundle);
            this.videoPath = bundle.getString("_wxapi_finder_share_video_path");
            this.extData = bundle.getString("_wxapi_finder_share_video_extData");
            String string = bundle.getString(WX_CHANNEL_SHARE_VIDEO_JUMP_INFO_KEY_IDENTIFIER);
            try {
                if (string != null) {
                    Class<?> clazz = Class.forName(string);
                    this.jumpInfo = (IWXChannelJumpInfo)clazz.newInstance();
                    this.jumpInfo.unserialize(bundle);
                }
                return;
            }
            catch (Exception exception) {
                Log.e(TAG, "get WXChannelJumpInfo from bundle failed: unknown ident " + string + ", ex = " + exception.getMessage());
                return;
            }
        }

        @Override
        public void toBundle(Bundle bundle) {
            super.toBundle(bundle);
            bundle.putString("_wxapi_finder_share_video_path", this.videoPath);
            bundle.putString("_wxapi_finder_share_video_extData", this.extData);
            if (this.jumpInfo != null) {
                bundle.putString(WX_CHANNEL_SHARE_VIDEO_JUMP_INFO_KEY_IDENTIFIER, this.jumpInfo.getClass().getName());
                this.jumpInfo.serialize(bundle);
            }
        }
    }
}

