/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.SendMessageToWX;
import com.tencent.mm.opensdk.utils.Log;

public class WXStateSceneDataObject
implements SendMessageToWX.IWXSceneDataObject {
    private static final String TAG = "MicroMsg.SDK.WXStateSceneDataObject";
    private static final String WX_STATE_JUMP_INFO_KEY_IDENTIFIER = "_wxapi_scene_data_state_jump_info_identifier";
    private static final int LENGTH_LIMIT = 10240;
    public String stateId;
    public String stateTitle;
    public String token;
    public IWXStateJumpInfo stateJumpInfo;

    @Override
    public void serialize(Bundle bundle) {
        bundle.putString("_wxapi_scene_data_state_id", this.stateId);
        bundle.putString("_wxapi_scene_data_state_title", this.stateTitle);
        bundle.putString("_wxapi_scene_data_state_token", this.token);
        if (this.stateJumpInfo != null) {
            bundle.putString(WX_STATE_JUMP_INFO_KEY_IDENTIFIER, this.stateJumpInfo.getClass().getName());
            this.stateJumpInfo.serialize(bundle);
        }
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.stateId = bundle.getString("_wxapi_scene_data_state_id");
        this.stateTitle = bundle.getString("_wxapi_scene_data_state_title");
        this.token = bundle.getString("_wxapi_scene_data_state_token");
        String string = bundle.getString(WX_STATE_JUMP_INFO_KEY_IDENTIFIER);
        try {
            if (string != null) {
                Class<?> clazz = Class.forName(string);
                this.stateJumpInfo = (IWXStateJumpInfo)clazz.newInstance();
                this.stateJumpInfo.unserialize(bundle);
            }
            return;
        }
        catch (Exception exception) {
            Log.e(TAG, "get WXSceneDataObject from bundle failed: unknown ident " + string + ", ex = " + exception.getMessage());
            return;
        }
    }

    @Override
    public boolean checkArgs() {
        if (this.stateId != null && this.stateId.length() > 10240) {
            Log.e(TAG, "checkArgs fail, stateId is invalid");
            return false;
        }
        if (this.stateTitle != null && this.stateTitle.length() > 10240) {
            Log.e(TAG, "checkArgs fail, stateId is invalid");
            return false;
        }
        if (this.token != null && this.token.length() > 10240) {
            Log.e(TAG, "checkArgs fail, stateId is invalid");
            return false;
        }
        if (this.stateJumpInfo == null) {
            Log.e(TAG, "checkArgs fail, statsJumpInfo is null");
            return false;
        }
        return this.stateJumpInfo.checkArgs();
    }

    @Override
    public int getJumpType() {
        if (this.stateJumpInfo != null) {
            return this.stateJumpInfo.type();
        }
        return 0;
    }

    public static interface IWXStateJumpInfo {
        public static final int WX_STATE_JUMP_TYPE_UNKNOWN = 0;
        public static final int WX_STATE_JUMP_TYPE_URL = 1;
        public static final int WX_STATE_JUMP_TYPE_MINI_PROGRAM = 2;
        public static final int WX_STATE_JUMP_TYPE_CHANNEL_PROFILE = 3;

        public int type();

        public void serialize(Bundle var1);

        public void unserialize(Bundle var1);

        public boolean checkArgs();
    }
}

