/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.mm.opensdk.modelmsg;

import android.os.Bundle;
import com.tencent.mm.opensdk.modelmsg.WXMediaMessage;
import com.tencent.mm.opensdk.modelmsg.WXMusicVipInfo;
import com.tencent.mm.opensdk.utils.Log;
import com.tencent.mm.opensdk.utils.b;

public class WXMusicVideoObject
implements WXMediaMessage.IMediaObject {
    private static final String TAG = "MicroMsg.SDK.WXMusicVideoObject";
    private static final int URL_LENGTH_LIMIT = 10240;
    private static final int LYRIC_LENGTH_LIMIT = 32768;
    private static final int STRING_LIMIT = 1024;
    private static final int HD_ALBUM_FILE_LENGTH = 0xA00000;
    public String musicUrl;
    public String musicDataUrl;
    public String singerName;
    public String songLyric;
    public String hdAlbumThumbFilePath;
    public String albumName;
    public String musicGenre;
    public long issueDate;
    public String identification;
    public int duration;
    public String musicOperationUrl;
    public WXMusicVipInfo musicVipInfo;

    private int getFileSize(String string) {
        return b.a(string);
    }

    @Override
    public void serialize(Bundle bundle) {
        bundle.putString("_wxmusicvideoobject_musicUrl", this.musicUrl);
        bundle.putString("_wxmusicvideoobject_musicDataUrl", this.musicDataUrl);
        bundle.putString("_wxmusicvideoobject_singerName", this.singerName);
        bundle.putString("_wxmusicvideoobject_songLyric", this.songLyric);
        bundle.putString("_wxmusicvideoobject_hdAlbumThumbFilePath", this.hdAlbumThumbFilePath);
        bundle.putString("_wxmusicvideoobject_albumName", this.albumName);
        bundle.putString("_wxmusicvideoobject_musicGenre", this.musicGenre);
        long l = this.issueDate;
        bundle.putLong("_wxmusicvideoobject_issueDate", l);
        bundle.putString("_wxmusicvideoobject_identification", this.identification);
        bundle.putInt("_wxmusicvideoobject_duration", this.duration);
        bundle.putString("_wxmusicvideoobject_musicOperationUrl", this.musicOperationUrl);
        WXMusicVipInfo wXMusicVipInfo = this.musicVipInfo;
        if (wXMusicVipInfo != null) {
            bundle.putString("_wxmusicvideoobject_musicVipInfo", wXMusicVipInfo.getClass().getName());
            this.musicVipInfo.serialize(bundle);
        }
    }

    @Override
    public void unserialize(Bundle bundle) {
        this.musicUrl = bundle.getString("_wxmusicvideoobject_musicUrl");
        this.musicDataUrl = bundle.getString("_wxmusicvideoobject_musicDataUrl");
        this.singerName = bundle.getString("_wxmusicvideoobject_singerName");
        this.songLyric = bundle.getString("_wxmusicvideoobject_songLyric");
        this.hdAlbumThumbFilePath = bundle.getString("_wxmusicvideoobject_hdAlbumThumbFilePath");
        this.albumName = bundle.getString("_wxmusicvideoobject_albumName");
        this.musicGenre = bundle.getString("_wxmusicvideoobject_musicGenre");
        this.issueDate = bundle.getLong("_wxmusicvideoobject_issueDate", 0L);
        this.identification = bundle.getString("_wxmusicvideoobject_identification");
        this.duration = bundle.getInt("_wxmusicvideoobject_duration", 0);
        this.musicOperationUrl = bundle.getString("_wxmusicvideoobject_musicOperationUrl");
        String string = bundle.getString("_wxmusicvideoobject_musicVipInfo");
        if (string != null) {
            WXMusicVipInfo wXMusicVipInfo = (WXMusicVipInfo)Class.forName(string).newInstance();
            try {
                this.musicVipInfo = wXMusicVipInfo;
                wXMusicVipInfo.unserialize(bundle);
            }
            catch (Exception exception) {
                Log.e(TAG, "get WXSceneDataObject from bundle failed: unknown vipInfoObjectStr " + string + ", ex = " + exception.getMessage());
            }
        }
    }

    @Override
    public int type() {
        return 76;
    }

    @Override
    public boolean checkArgs() {
        if (!b.b(this.musicUrl) && this.musicUrl.length() <= 10240) {
            if (!b.b(this.musicDataUrl) && this.musicDataUrl.length() <= 10240) {
                if (!b.b(this.singerName) && this.singerName.length() <= 1024) {
                    if (!b.b(this.songLyric) && this.songLyric.length() > 32768) {
                        Log.e(TAG, "songLyric.length exceeds the limit");
                        return false;
                    }
                    if (!b.b(this.hdAlbumThumbFilePath) && this.hdAlbumThumbFilePath.length() > 1024) {
                        Log.e(TAG, "hdAlbumThumbFilePath.length exceeds the limit");
                        return false;
                    }
                    if (!b.b(this.hdAlbumThumbFilePath)) {
                        WXMusicVideoObject wXMusicVideoObject = this;
                        if (wXMusicVideoObject.getFileSize(wXMusicVideoObject.hdAlbumThumbFilePath) > 0xA00000) {
                            Log.e(TAG, "hdAlbumThumbFilePath file length exceeds the limit");
                            return false;
                        }
                    }
                    if (!b.b(this.musicGenre) && this.musicGenre.length() > 1024) {
                        Log.e(TAG, "musicGenre.length exceeds the limit");
                        return false;
                    }
                    if (!b.b(this.identification) && this.identification.length() > 1024) {
                        Log.e(TAG, "identification.length exceeds the limit");
                        return false;
                    }
                    if (!b.b(this.musicOperationUrl) && this.musicOperationUrl.length() > 10240) {
                        Log.e(TAG, "musicOperationUrl.length exceeds the limit");
                        return false;
                    }
                    return true;
                }
                Log.e(TAG, "singerName.length exceeds the limit");
                return false;
            }
            Log.e(TAG, "musicDataUrl.length exceeds the limit");
            return false;
        }
        Log.e(TAG, "musicUrl.length exceeds the limit");
        return false;
    }
}

