/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.common;

import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigSet;
import com.tencent.polaris.plugins.circuitbreaker.common.RuleIdentifier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

public class ConfigGroup<T extends Verifier> {
    private final ConfigSet<T> localConfig;
    private final Map<RuleIdentifier, ConfigSet<T>> serviceConfigs = new ConcurrentHashMap<RuleIdentifier, ConfigSet<T>>();

    public ConfigGroup(ConfigSet<T> localConfig) {
        this.localConfig = localConfig;
    }

    public ConfigSet<T> getLocalConfig() {
        return this.localConfig;
    }

    public ConfigSet<T> getServiceConfig(RuleIdentifier ruleIdentifier, Function<RuleIdentifier, ConfigSet<T>> create) {
        ConfigSet<T> tConfigSet = this.serviceConfigs.computeIfAbsent(ruleIdentifier, create);
        if (tConfigSet.isUseDefault()) {
            return this.localConfig;
        }
        return tConfigSet;
    }
}

