/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.common;

import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.api.config.verify.Verifier;
import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.InstanceLocalValue;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.StatusDimension;
import com.tencent.polaris.client.pojo.InstanceByProto;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigGroup;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigSet;
import com.tencent.polaris.plugins.circuitbreaker.common.ConfigSetLocator;
import com.tencent.polaris.plugins.circuitbreaker.common.HalfOpenConfig;
import com.tencent.polaris.plugins.circuitbreaker.common.HalfOpenCounter;
import com.tencent.polaris.plugins.circuitbreaker.common.RuleIdentifier;
import com.tencent.polaris.plugins.circuitbreaker.common.StateMachine;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;

public abstract class AbstractStateMachine<T extends Verifier>
implements StateMachine<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractStateMachine.class);
    protected final ConfigGroup<T> configGroup;
    protected final int pluginId;
    protected final ConfigSetLocator<T> configSetLocator;

    public AbstractStateMachine(ConfigGroup<T> configGroup, int pluginId, ConfigSetLocator<T> configSetLocator) {
        this.configGroup = configGroup;
        this.pluginId = pluginId;
        this.configSetLocator = configSetLocator;
    }

    @Override
    public Set<StatusDimension> getStatusDimensions(Instance instance, StateMachine.Parameter parameter) {
        HalfOpenCounter halfOpenCounter = this.getHalfOpenCounter(parameter.getPluginId(), instance);
        if (null == halfOpenCounter) {
            return Collections.emptySet();
        }
        return halfOpenCounter.getStatusDimensions();
    }

    @Override
    public boolean openToHalfOpen(Instance instance, StatusDimension statusDimension, StateMachine.Parameter parameter) {
        boolean matched;
        HalfOpenCounter halfOpenCounter;
        String cbName = parameter.getCircuitBreakerName();
        CircuitBreakerStatus cbStatus = instance.getCircuitBreakerStatus(statusDimension);
        if (null == cbStatus || !cbStatus.getCircuitBreaker().equals(cbName) || cbStatus.getStatus() != CircuitBreakerStatus.Status.OPEN) {
            return false;
        }
        boolean detectSuccess = false;
        if (instance instanceof InstanceByProto) {
            DetectResult detectResult = ((InstanceByProto)instance).getDetectResult();
            boolean bl = detectSuccess = null != detectResult && detectResult.getRetStatus() == RetStatus.RetSuccess;
        }
        if (null == (halfOpenCounter = this.getHalfOpenCounter(parameter.getPluginId(), instance))) {
            return false;
        }
        long startTimeMs = cbStatus.getStartTimeMs();
        HalfOpenConfig halfOpenConfig = this.getHalfOpenConfigOnHalfOpen(instance, statusDimension);
        if (detectSuccess && halfOpenConfig.getWhenToDetect() != OutlierDetectionConfig.When.never) {
            matched = true;
        } else {
            boolean bl = matched = parameter.getCurrentTimeMs() - startTimeMs >= halfOpenConfig.getSleepWindowMs();
        }
        if (matched) {
            halfOpenCounter.resetHalfOpen(statusDimension);
        }
        return matched;
    }

    @Override
    public boolean halfOpenToOpen(Instance instance, StatusDimension statusDimension, StateMachine.Parameter parameter) {
        HalfOpenCounter halfOpenCounter = this.getHalfOpenCounterByParameter(instance, statusDimension, parameter);
        if (halfOpenCounter == null) {
            return false;
        }
        long failCountAfterHalfOpen = halfOpenCounter.getHalfOpenFailCount(statusDimension);
        return failCountAfterHalfOpen >= (long)this.getHalfOpenConfigOnHalfOpen(instance, statusDimension).getHalfOpenFailCount();
    }

    private HalfOpenCounter getHalfOpenCounterByParameter(Instance instance, StatusDimension statusDimension, StateMachine.Parameter parameter) {
        String cbName = parameter.getCircuitBreakerName();
        CircuitBreakerStatus cbStatus = instance.getCircuitBreakerStatus(statusDimension);
        if (null == cbStatus || !cbStatus.getCircuitBreaker().equals(cbName) || cbStatus.getStatus() != CircuitBreakerStatus.Status.HALF_OPEN) {
            return null;
        }
        return this.getHalfOpenCounter(parameter.getPluginId(), instance);
    }

    @Override
    public boolean halfOpenToClose(Instance instance, StatusDimension statusDimension, StateMachine.Parameter parameter) {
        boolean matched;
        HalfOpenCounter halfOpenCounter = this.getHalfOpenCounterByParameter(instance, statusDimension, parameter);
        if (halfOpenCounter == null) {
            return false;
        }
        HalfOpenConfig halfOpenConfig = this.getHalfOpenConfigOnHalfOpen(instance, statusDimension);
        long sucCountAfterHalfOpen = halfOpenCounter.getHalfOpenSuccessCount(statusDimension);
        boolean bl = matched = sucCountAfterHalfOpen >= (long)halfOpenConfig.getHalfOpenSuccessCount();
        if (matched) {
            halfOpenCounter.resetCounter(statusDimension);
        }
        return matched;
    }

    protected HalfOpenCounter getHalfOpenCounter(int pluginId, Instance instance) {
        InstanceByProto instanceByProto = (InstanceByProto)instance;
        InstanceLocalValue instanceLocalValue = instanceByProto.getInstanceLocalValue();
        if (null == instanceLocalValue) {
            return null;
        }
        Object pluginValue = instanceLocalValue.getPluginValue(pluginId, null);
        if (null == pluginValue) {
            return null;
        }
        return (HalfOpenCounter)pluginValue;
    }

    private HalfOpenConfig getHalfOpenConfigOnHalfOpen(Instance instance, StatusDimension statusDimension) {
        RuleIdentifier ruleIdentifier = new RuleIdentifier(instance.getNamespace(), instance.getService(), statusDimension.getCallerService(), statusDimension.getMethod());
        ConfigSet<T> configSet = this.configSetLocator.getConfigSet(ruleIdentifier);
        return configSet.getHalfOpenConfig();
    }

    protected HalfOpenCounter getHalfOpenCounterOnClose(Instance instance, StatusDimension statusDimension) {
        CircuitBreakerStatus cbStatus = instance.getCircuitBreakerStatus(statusDimension);
        if (null != cbStatus && cbStatus.getStatus() != CircuitBreakerStatus.Status.CLOSE) {
            return null;
        }
        return this.getHalfOpenCounter(this.pluginId, instance);
    }

    protected <T extends Verifier> ConfigSet<T> getConfigSetByLocator(Instance instance, StatusDimension statusDimension, ConfigSetLocator<T> configSetLocator) {
        RuleIdentifier ruleIdentifier = new RuleIdentifier(instance.getNamespace(), instance.getService(), statusDimension.getCallerService(), statusDimension.getMethod());
        return configSetLocator.getConfigSet(ruleIdentifier);
    }
}

