/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.common.stat;

import com.tencent.polaris.plugins.circuitbreaker.common.stat.Bucket;
import com.tencent.polaris.plugins.circuitbreaker.common.stat.TimePosition;
import com.tencent.polaris.plugins.circuitbreaker.common.stat.TimeRange;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceWindow {
    private static final Logger LOG = LoggerFactory.getLogger(SliceWindow.class);
    private final String name;
    private final int bucketCount;
    private final long bucketIntervalMs;
    private final long windowLengthMs;
    private final int metricSize;
    private final Object lock = new Object();
    private final AtomicReference<Bucket> headBucket = new AtomicReference();

    public SliceWindow(String name, int bucketCount, long bucketIntervalMs, int metricSize) {
        this.name = name;
        this.bucketCount = bucketCount;
        this.bucketIntervalMs = bucketIntervalMs;
        this.metricSize = metricSize;
        this.windowLengthMs = bucketIntervalMs * (long)bucketCount;
    }

    public int getBucketCount() {
        return this.bucketCount;
    }

    public long getBucketIntervalMs() {
        return this.bucketIntervalMs;
    }

    public long getWindowLengthMs() {
        return this.windowLengthMs;
    }

    private long doAddGauge(Function<Bucket, Long> operation, long now) {
        Bucket head = this.headBucket.get();
        Bucket tail = null;
        if (null != head) {
            tail = head.getTailBucket();
        }
        if (null != tail && TimePosition.inside == tail.getTimeRange().isTimeInBucket(now)) {
            Long retValue = operation.apply(tail);
            LOG.debug("window {}: add tail bucket {}, now is {}, value is {}", new Object[]{this.name, tail.getTimeRange(), now, retValue});
            return null != retValue ? retValue : 0L;
        }
        if (null == head || null == tail || tail.getTimeRange().getEnd() + this.windowLengthMs <= now) {
            Bucket newBucket = new Bucket(now, this.bucketIntervalMs, this.metricSize);
            newBucket.getCount().set(1);
            this.headBucket.set(newBucket);
            LOG.debug("window {}: recreated, new bucket {}, now is {}", new Object[]{this.name, newBucket.getTimeRange(), now});
            Long value = operation.apply(newBucket);
            return null != value ? value : 0L;
        }
        return this.addNextBucket(operation, head, tail, now);
    }

    private long addNextBucket(Function<Bucket, Long> operation, Bucket head, Bucket tail, long now) {
        long lastTailEndTime = tail.getTimeRange().getEnd();
        long nextStartTime = lastTailEndTime + (now - lastTailEndTime) / this.bucketIntervalMs;
        Bucket newBucket = new Bucket(nextStartTime, this.bucketIntervalMs, this.metricSize);
        tail.getNextBucket().set(newBucket);
        this.slipExpireBucket(head, newBucket, now);
        Long value = operation.apply(newBucket);
        LOG.debug("window {}: tail add next, tail is {}, new bucket {}, now is {}, value is {}", new Object[]{this.name, tail.getTimeRange(), newBucket.getTimeRange(), now, value});
        return null != value ? value : 0L;
    }

    private void slipExpireBucket(Bucket head, Bucket newBucket, long now) {
        Bucket nextHead = head;
        long headStartTime = nextHead.getTimeRange().getStart();
        long headWindowEndTime = headStartTime + this.windowLengthMs;
        int slipCount = 0;
        while (headWindowEndTime <= newBucket.getTimeRange().getStart() && null != (nextHead = nextHead.getNextBucket().get())) {
            ++slipCount;
            headStartTime = head.getTimeRange().getStart();
            headWindowEndTime = headStartTime + this.windowLengthMs;
        }
        if (null == nextHead) {
            newBucket.getCount().set(1);
            this.headBucket.set(newBucket);
            LOG.info("window {}: recreated, new bucket {}, now is {}", new Object[]{this.name, newBucket.getTimeRange(), now});
            return;
        }
        if (slipCount > 0) {
            nextHead.getCount().addAndGet(1 - slipCount);
            this.headBucket.set(nextHead);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long addGauge(Function<Bucket, Long> operation) {
        long now = System.currentTimeMillis();
        Bucket tail = this.getTailBucket();
        if (null != tail && TimePosition.inside == tail.getTimeRange().isTimeInBucket(now)) {
            Long retValue = operation.apply(tail);
            LOG.debug("window {}: add tail bucket {}, now is {}, value is {}", new Object[]{this.name, tail.getTimeRange(), now, retValue});
            return null != retValue ? retValue : 0L;
        }
        Object object = this.lock;
        synchronized (object) {
            return this.doAddGauge(operation, now);
        }
    }

    public Bucket getHeadBucket() {
        return this.headBucket.get();
    }

    public Bucket getTailBucket() {
        Bucket head = this.headBucket.get();
        if (null != head) {
            return head.getTailBucket();
        }
        return null;
    }

    public long calcMetricsBothIncluded(int dimension, TimeRange timeRange) {
        Bucket head = this.getHeadBucket();
        if (null == head) {
            return 0L;
        }
        return head.calcMetricsBothIncluded(dimension, timeRange);
    }
}

