/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.common;

import com.tencent.polaris.api.config.consumer.CircuitBreakerConfig;
import com.tencent.polaris.api.config.consumer.OutlierDetectionConfig;
import com.tencent.polaris.client.pb.CircuitBreakerProto;

public class HalfOpenConfig {
    private final int halfOpenMaxReqCount;
    private final int halfOpenSuccessCount;
    private final int halfOpenFailCount;
    private final long sleepWindowMs;
    private final OutlierDetectionConfig.When whenToDetect;

    public HalfOpenConfig(CircuitBreakerConfig circuitBreakerConfig, OutlierDetectionConfig outlierDetectionConfig) {
        int halfOpenFailCount;
        this.halfOpenMaxReqCount = circuitBreakerConfig.getRequestCountAfterHalfOpen();
        int successCountAfterHalfOpen = circuitBreakerConfig.getSuccessCountAfterHalfOpen();
        if (successCountAfterHalfOpen > this.halfOpenMaxReqCount) {
            successCountAfterHalfOpen = this.halfOpenMaxReqCount;
        }
        if ((halfOpenFailCount = this.halfOpenMaxReqCount - successCountAfterHalfOpen + 1) > this.halfOpenMaxReqCount) {
            halfOpenFailCount = this.halfOpenMaxReqCount;
        }
        this.sleepWindowMs = circuitBreakerConfig.getSleepWindow();
        this.halfOpenSuccessCount = successCountAfterHalfOpen;
        this.halfOpenFailCount = halfOpenFailCount;
        this.whenToDetect = outlierDetectionConfig.getWhen();
    }

    public HalfOpenConfig(HalfOpenConfig halfOpenConfig, CircuitBreakerProto.RecoverConfig recoverConfig) {
        this.halfOpenMaxReqCount = halfOpenConfig.getHalfOpenMaxReqCount();
        this.sleepWindowMs = halfOpenConfig.getSleepWindowMs();
        this.halfOpenSuccessCount = halfOpenConfig.getHalfOpenSuccessCount();
        this.halfOpenFailCount = halfOpenConfig.getHalfOpenFailCount();
        this.whenToDetect = null != recoverConfig ? OutlierDetectionConfig.When.values()[recoverConfig.getOutlierDetectWhen().getNumber()] : halfOpenConfig.getWhenToDetect();
    }

    public int getHalfOpenMaxReqCount() {
        return this.halfOpenMaxReqCount;
    }

    public int getHalfOpenSuccessCount() {
        return this.halfOpenSuccessCount;
    }

    public int getHalfOpenFailCount() {
        return this.halfOpenFailCount;
    }

    public long getSleepWindowMs() {
        return this.sleepWindowMs;
    }

    public OutlierDetectionConfig.When getWhenToDetect() {
        return this.whenToDetect;
    }
}

