/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.composite;

import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.plugin.registry.AbstractResourceEventListener;
import com.tencent.polaris.api.pojo.RegistryCacheValue;
import com.tencent.polaris.api.pojo.ServiceEventKey;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.circuitbreaker.composite.CircuitBreakerRuleContainer;
import com.tencent.polaris.plugins.circuitbreaker.composite.PolarisCircuitBreaker;
import java.util.Map;
import org.slf4j.Logger;

public class CircuitBreakerRuleListener
extends AbstractResourceEventListener {
    private final PolarisCircuitBreaker polarisCircuitBreaker;
    private static final Logger LOG = LoggerFactory.getLogger(CircuitBreakerRuleListener.class);

    public CircuitBreakerRuleListener(PolarisCircuitBreaker polarisCircuitBreaker) {
        this.polarisCircuitBreaker = polarisCircuitBreaker;
    }

    public void onResourceAdd(ServiceEventKey svcEventKey, RegistryCacheValue newValue) {
        if (svcEventKey.getEventType() != ServiceEventKey.EventType.CIRCUIT_BREAKING && svcEventKey.getEventType() != ServiceEventKey.EventType.FAULT_DETECTING) {
            return;
        }
        LOG.info("[CircuitBreaker] onResourceAdd {}", (Object)svcEventKey);
        this.doSchedule(svcEventKey);
    }

    public void onResourceUpdated(ServiceEventKey svcEventKey, RegistryCacheValue oldValue, RegistryCacheValue newValue) {
        if (svcEventKey.getEventType() != ServiceEventKey.EventType.CIRCUIT_BREAKING && svcEventKey.getEventType() != ServiceEventKey.EventType.FAULT_DETECTING) {
            return;
        }
        LOG.info("[CircuitBreaker] onResourceUpdated {}", (Object)svcEventKey);
        this.doSchedule(svcEventKey);
    }

    private void doSchedule(ServiceEventKey svcEventKey) {
        for (Map.Entry<Resource, CircuitBreakerRuleContainer> entry : this.polarisCircuitBreaker.getContainers().entrySet()) {
            if (!entry.getKey().getService().equals((Object)svcEventKey.getServiceKey())) continue;
            switch (svcEventKey.getEventType()) {
                case CIRCUIT_BREAKING: {
                    entry.getValue().scheduleCircuitBreaker();
                    break;
                }
                case FAULT_DETECTING: {
                    entry.getValue().scheduleHealthCheck();
                    break;
                }
            }
        }
    }

    public void onResourceDeleted(ServiceEventKey svcEventKey, RegistryCacheValue oldValue) {
        if (svcEventKey.getEventType() != ServiceEventKey.EventType.CIRCUIT_BREAKING && svcEventKey.getEventType() != ServiceEventKey.EventType.FAULT_DETECTING) {
            return;
        }
        LOG.info("[CircuitBreaker] onResourceDeleted {}", (Object)svcEventKey);
        this.doSchedule(svcEventKey);
    }
}

