/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.composite;

import com.tencent.polaris.api.control.Destroyable;
import com.tencent.polaris.api.exception.PolarisException;
import com.tencent.polaris.api.plugin.PluginType;
import com.tencent.polaris.api.plugin.circuitbreaker.CircuitBreaker;
import com.tencent.polaris.api.plugin.circuitbreaker.ResourceStat;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.InstanceResource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.plugin.common.InitContext;
import com.tencent.polaris.api.plugin.common.PluginTypes;
import com.tencent.polaris.api.plugin.compose.Extensions;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.plugin.registry.ResourceEventListener;
import com.tencent.polaris.api.pojo.CircuitBreakerStatus;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.pojo.ServiceKey;
import com.tencent.polaris.api.pojo.ServiceResourceProvider;
import com.tencent.polaris.client.flow.DefaultServiceResourceProvider;
import com.tencent.polaris.client.util.NamedThreadFactory;
import com.tencent.polaris.plugins.circuitbreaker.composite.CircuitBreakerRuleContainer;
import com.tencent.polaris.plugins.circuitbreaker.composite.CircuitBreakerRuleListener;
import com.tencent.polaris.plugins.circuitbreaker.composite.HealthCheckUtils;
import com.tencent.polaris.plugins.circuitbreaker.composite.ResourceCounters;
import com.tencent.polaris.plugins.circuitbreaker.composite.ResourceHealthChecker;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.function.Function;

public class PolarisCircuitBreaker
extends Destroyable
implements CircuitBreaker {
    private final Map<CircuitBreakerProto.Level, Map<Resource, ResourceCounters>> countersCache = new HashMap<CircuitBreakerProto.Level, Map<Resource, ResourceCounters>>();
    private final Map<Resource, ResourceHealthChecker> healthCheckCache = new ConcurrentHashMap<Resource, ResourceHealthChecker>();
    private final Map<ServiceKey, Map<Resource, ResourceHealthChecker>> serviceHealthCheckCache = new ConcurrentHashMap<ServiceKey, Map<Resource, ResourceHealthChecker>>();
    private final ScheduledExecutorService stateChangeExecutors = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("circuitbreaker-state-worker"));
    private final ScheduledExecutorService pullRulesExecutors = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new NamedThreadFactory("circuitbreaker-pull-rules-worker"));
    private final ScheduledExecutorService healthCheckExecutors = new ScheduledThreadPoolExecutor(4, (ThreadFactory)new NamedThreadFactory("circuitbreaker-health-check-worker"));
    private final Map<Resource, CircuitBreakerRuleContainer> containers = new ConcurrentHashMap<Resource, CircuitBreakerRuleContainer>();
    private Extensions extensions;
    private ServiceResourceProvider serviceResourceProvider;
    private Map<String, HealthChecker> healthCheckers = Collections.emptyMap();
    private long healthCheckInstanceExpireInterval;
    private long checkPeriod;

    public CircuitBreakerStatus checkResource(Resource resource) {
        ResourceCounters resourceCounters = this.getResourceCounters(resource);
        if (null == resourceCounters) {
            return null;
        }
        return resourceCounters.getCircuitBreakerStatus();
    }

    private ResourceCounters getResourceCounters(Resource resource) {
        Map<Resource, ResourceCounters> resourceResourceCountersMap = this.countersCache.get(resource.getLevel());
        return resourceResourceCountersMap.get(resource);
    }

    public void report(ResourceStat resourceStat) {
        this.doReport(resourceStat, true);
    }

    void doReport(ResourceStat resourceStat, boolean record) {
        Resource resource = resourceStat.getResource();
        if (resource.getLevel() == CircuitBreakerProto.Level.UNKNOWN) {
            return;
        }
        RetStatus retStatus = resourceStat.getRetStatus();
        if (retStatus == RetStatus.RetReject || retStatus == RetStatus.RetFlowControl) {
            return;
        }
        ResourceCounters resourceCounters = this.getResourceCounters(resource);
        if (null == resourceCounters) {
            this.containers.computeIfAbsent(resource, new Function<Resource, CircuitBreakerRuleContainer>(){

                @Override
                public CircuitBreakerRuleContainer apply(Resource resource) {
                    return new CircuitBreakerRuleContainer(resource, PolarisCircuitBreaker.this);
                }
            });
        } else {
            resourceCounters.report(resourceStat);
        }
        this.addInstanceForHealthCheck(resourceStat.getResource(), record);
    }

    private void addInstanceForHealthCheck(Resource resource, boolean record) {
        if (!(resource instanceof InstanceResource)) {
            return;
        }
        InstanceResource instanceResource = (InstanceResource)resource;
        Map<Resource, ResourceHealthChecker> resourceResourceHealthCheckerMap = this.serviceHealthCheckCache.get(instanceResource.getService());
        if (null == resourceResourceHealthCheckerMap) {
            return;
        }
        for (ResourceHealthChecker resourceHealthChecker : resourceResourceHealthCheckerMap.values()) {
            resourceHealthChecker.addInstance(instanceResource, record);
        }
    }

    public PluginType getType() {
        return PluginTypes.CIRCUIT_BREAKER.getBaseType();
    }

    public void init(InitContext ctx) throws PolarisException {
        this.countersCache.put(CircuitBreakerProto.Level.SERVICE, new ConcurrentHashMap());
        this.countersCache.put(CircuitBreakerProto.Level.METHOD, new ConcurrentHashMap());
        this.countersCache.put(CircuitBreakerProto.Level.GROUP, new ConcurrentHashMap());
        this.countersCache.put(CircuitBreakerProto.Level.INSTANCE, new ConcurrentHashMap());
        this.checkPeriod = 0L;
        if (null != ctx) {
            this.checkPeriod = ctx.getConfig().getConsumer().getCircuitBreaker().getCheckPeriod();
        }
        if (this.checkPeriod == 0L) {
            this.checkPeriod = HealthCheckUtils.DEFAULT_CHECK_INTERVAL;
        }
        this.healthCheckInstanceExpireInterval = (long)HealthCheckUtils.CHECK_PERIOD_MULTIPLE * this.checkPeriod;
    }

    public void postContextInit(Extensions extensions) throws PolarisException {
        this.extensions = extensions;
        this.serviceResourceProvider = new DefaultServiceResourceProvider(extensions);
        extensions.getLocalRegistry().registerResourceListener((ResourceEventListener)new CircuitBreakerRuleListener(this));
        this.healthCheckers = extensions.getAllHealthCheckers();
    }

    public void setServiceRuleProvider(ServiceResourceProvider serviceResourceProvider) {
        this.serviceResourceProvider = serviceResourceProvider;
    }

    public long getHealthCheckInstanceExpireInterval() {
        return this.healthCheckInstanceExpireInterval;
    }

    public void setHealthCheckInstanceExpireInterval(long healthCheckInstanceExpireInterval) {
        this.healthCheckInstanceExpireInterval = healthCheckInstanceExpireInterval;
    }

    public long getCheckPeriod() {
        return this.checkPeriod;
    }

    public void setCheckPeriod(long checkPeriod) {
        this.checkPeriod = checkPeriod;
    }

    protected void doDestroy() {
        this.stateChangeExecutors.shutdown();
        this.pullRulesExecutors.shutdown();
        this.healthCheckExecutors.shutdown();
    }

    Map<CircuitBreakerProto.Level, Map<Resource, ResourceCounters>> getCountersCache() {
        return this.countersCache;
    }

    Map<Resource, ResourceHealthChecker> getHealthCheckCache() {
        return this.healthCheckCache;
    }

    Map<ServiceKey, Map<Resource, ResourceHealthChecker>> getServiceHealthCheckCache() {
        return this.serviceHealthCheckCache;
    }

    Extensions getExtensions() {
        return this.extensions;
    }

    ScheduledExecutorService getPullRulesExecutors() {
        return this.pullRulesExecutors;
    }

    ScheduledExecutorService getStateChangeExecutors() {
        return this.stateChangeExecutors;
    }

    ScheduledExecutorService getHealthCheckExecutors() {
        return this.healthCheckExecutors;
    }

    Map<Resource, CircuitBreakerRuleContainer> getContainers() {
        return this.containers;
    }

    public ServiceResourceProvider getServiceRuleProvider() {
        return this.serviceResourceProvider;
    }

    public Map<String, HealthChecker> getHealthCheckers() {
        return this.healthCheckers;
    }

    public void setHealthCheckers(Map<String, HealthChecker> healthCheckers) {
        this.healthCheckers = healthCheckers;
    }

    public String getName() {
        return "composite";
    }
}

