/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.polaris.plugins.circuitbreaker.composite;

import com.tencent.polaris.api.plugin.cache.FlowCache;
import com.tencent.polaris.api.plugin.circuitbreaker.ResourceStat;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.InstanceResource;
import com.tencent.polaris.api.plugin.circuitbreaker.entity.Resource;
import com.tencent.polaris.api.plugin.detect.HealthChecker;
import com.tencent.polaris.api.pojo.DefaultInstance;
import com.tencent.polaris.api.pojo.DetectResult;
import com.tencent.polaris.api.pojo.Instance;
import com.tencent.polaris.api.pojo.RetStatus;
import com.tencent.polaris.api.utils.RuleUtils;
import com.tencent.polaris.client.pojo.Node;
import com.tencent.polaris.logging.LoggerFactory;
import com.tencent.polaris.plugins.circuitbreaker.composite.CircuitBreakerRuleContainer;
import com.tencent.polaris.plugins.circuitbreaker.composite.HealthCheckUtils;
import com.tencent.polaris.plugins.circuitbreaker.composite.MatchUtils;
import com.tencent.polaris.plugins.circuitbreaker.composite.PolarisCircuitBreaker;
import com.tencent.polaris.specification.api.v1.fault.tolerance.CircuitBreakerProto;
import com.tencent.polaris.specification.api.v1.fault.tolerance.FaultDetectorProto;
import com.tencent.polaris.specification.api.v1.model.ModelProto;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.slf4j.Logger;

public class ResourceHealthChecker {
    private static final Logger HC_EVENT_LOG = LoggerFactory.getLogger((String)"polaris-healthcheck-event");
    private static final Logger LOG = LoggerFactory.getLogger(ResourceHealthChecker.class);
    private static final int DEFAULT_CHECK_INTERVAL = 10;
    private final Resource resource;
    private final FaultDetectorProto.FaultDetector faultDetector;
    private final ScheduledExecutorService checkScheduler;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final Map<String, HealthChecker> healthCheckers;
    private final PolarisCircuitBreaker polarisCircuitBreaker;
    private final Function<String, Pattern> regexToPattern;
    private final List<ScheduledFuture<?>> futures = new ArrayList();
    private final Map<Node, ProtocolInstance> instances = new ConcurrentHashMap<Node, ProtocolInstance>();

    public ResourceHealthChecker(Resource resource, FaultDetectorProto.FaultDetector faultDetector, PolarisCircuitBreaker polarisCircuitBreaker) {
        this.resource = resource;
        this.faultDetector = faultDetector;
        this.regexToPattern = regex -> {
            FlowCache flowCache = polarisCircuitBreaker.getExtensions().getFlowCache();
            return flowCache.loadOrStoreCompiledRegex(regex);
        };
        this.checkScheduler = polarisCircuitBreaker.getHealthCheckExecutors();
        this.healthCheckers = polarisCircuitBreaker.getHealthCheckers();
        this.polarisCircuitBreaker = polarisCircuitBreaker;
        if (resource instanceof InstanceResource) {
            this.addInstance((InstanceResource)resource, false);
        }
        this.start();
    }

    public void addInstance(InstanceResource instanceResource, boolean record) {
        ProtocolInstance protocolInstance = this.instances.get(instanceResource.getNode());
        if (null == protocolInstance) {
            this.instances.put(instanceResource.getNode(), new ProtocolInstance(HealthCheckUtils.parseProtocol(instanceResource.getProtocol()), instanceResource));
            return;
        }
        if (record) {
            protocolInstance.doReport();
        }
    }

    private static List<FaultDetectorProto.FaultDetectRule> sortFaultDetectRules(List<FaultDetectorProto.FaultDetectRule> rules) {
        ArrayList<FaultDetectorProto.FaultDetectRule> outRules = new ArrayList<FaultDetectorProto.FaultDetectRule>(rules);
        outRules.sort(new Comparator<FaultDetectorProto.FaultDetectRule>(){

            @Override
            public int compare(FaultDetectorProto.FaultDetectRule rule1, FaultDetectorProto.FaultDetectRule rule2) {
                FaultDetectorProto.FaultDetectRule.DestinationService targetService1 = rule1.getTargetService();
                String destNamespace1 = targetService1.getNamespace();
                String destService1 = targetService1.getService();
                String destMethod1 = targetService1.getMethod().getValue().getValue();
                FaultDetectorProto.FaultDetectRule.DestinationService targetService2 = rule2.getTargetService();
                String destNamespace2 = targetService2.getNamespace();
                String destService2 = targetService2.getService();
                String destMethod2 = targetService2.getMethod().getValue().getValue();
                int svcResult = CircuitBreakerRuleContainer.compareService(destNamespace1, destService1, destNamespace2, destService2);
                if (svcResult != 0) {
                    return svcResult;
                }
                return CircuitBreakerRuleContainer.compareSingleValue(destMethod1, destMethod2);
            }
        });
        return outRules;
    }

    public static Map<String, FaultDetectorProto.FaultDetectRule> selectFaultDetectRules(Resource resource, FaultDetectorProto.FaultDetector faultDetector, Function<String, Pattern> regexToPattern) {
        List<FaultDetectorProto.FaultDetectRule> sortedRules = ResourceHealthChecker.sortFaultDetectRules(faultDetector.getRulesList());
        HashMap<String, FaultDetectorProto.FaultDetectRule> out = new HashMap<String, FaultDetectorProto.FaultDetectRule>();
        for (FaultDetectorProto.FaultDetectRule sortedRule : sortedRules) {
            FaultDetectorProto.FaultDetectRule.DestinationService targetService = sortedRule.getTargetService();
            if (!MatchUtils.matchService(resource.getService(), targetService.getNamespace(), targetService.getService()) || (resource.getLevel() != CircuitBreakerProto.Level.METHOD ? !RuleUtils.isMatchAllValue((ModelProto.MatchString)targetService.getMethod()) : !MatchUtils.matchMethod(resource, targetService.getMethod(), regexToPattern)) || out.containsKey(sortedRule.getProtocol().name())) continue;
            out.put(sortedRule.getProtocol().name(), sortedRule);
        }
        return out;
    }

    private Instance createDefaultInstance(String host, int port) {
        DefaultInstance instance = new DefaultInstance();
        instance.setHost(host);
        instance.setPort(port);
        return instance;
    }

    private Runnable createCheckTask(FaultDetectorProto.FaultDetectRule.Protocol protocol, FaultDetectorProto.FaultDetectRule faultDetectRule) {
        return () -> {
            if (this.stopped.get()) {
                return;
            }
            this.checkResource(protocol, faultDetectRule);
        };
    }

    private void checkResource(FaultDetectorProto.FaultDetectRule.Protocol protocol, FaultDetectorProto.FaultDetectRule faultDetectRule) {
        int port = faultDetectRule.getPort();
        if (port > 0) {
            HashSet<String> hosts = new HashSet<String>();
            for (Map.Entry<Node, ProtocolInstance> entry : this.instances.entrySet()) {
                Node instance = entry.getKey();
                if (hosts.contains(instance.getHost())) continue;
                hosts.add(instance.getHost());
                boolean success = this.doCheck(this.createDefaultInstance(instance.getHost(), port), protocol, faultDetectRule);
                entry.getValue().checkSuccess.set(success);
            }
        } else {
            for (Map.Entry<Node, ProtocolInstance> entry : this.instances.entrySet()) {
                FaultDetectorProto.FaultDetectRule.Protocol currentProtocol = entry.getValue().getProtocol();
                if (currentProtocol != FaultDetectorProto.FaultDetectRule.Protocol.UNKNOWN && protocol != currentProtocol) continue;
                InstanceResource instance = entry.getValue().getInstanceResource();
                boolean success = this.doCheck(this.createDefaultInstance(instance.getHost(), instance.getPort()), protocol, faultDetectRule);
                entry.getValue().checkSuccess.set(success);
            }
        }
    }

    private void start() {
        Map<String, FaultDetectorProto.FaultDetectRule> protocol2Rules = ResourceHealthChecker.selectFaultDetectRules(this.resource, this.faultDetector, this.regexToPattern);
        for (Map.Entry<String, FaultDetectorProto.FaultDetectRule> entry : protocol2Rules.entrySet()) {
            FaultDetectorProto.FaultDetectRule faultDetectRule = entry.getValue();
            Runnable checkTask = this.createCheckTask(FaultDetectorProto.FaultDetectRule.Protocol.valueOf((String)entry.getKey()), entry.getValue());
            int interval = 10;
            if (faultDetectRule.getInterval() > 0) {
                interval = faultDetectRule.getInterval();
            }
            LOG.info("schedule task: resource {}, protocol {}, interval {}, rule {}", new Object[]{this.resource, entry.getKey(), interval, faultDetectRule.getName()});
            ScheduledFuture<?> future = this.checkScheduler.scheduleWithFixedDelay(checkTask, interval, interval, TimeUnit.SECONDS);
            this.futures.add(future);
        }
        if (this.resource.getLevel() != CircuitBreakerProto.Level.INSTANCE) {
            long checkPeriod = this.polarisCircuitBreaker.getCheckPeriod();
            LOG.info("schedule expire task: resource {}, interval {}", (Object)this.resource, (Object)checkPeriod);
            ScheduledFuture<?> future = this.checkScheduler.scheduleWithFixedDelay(new Runnable(){

                @Override
                public void run() {
                    ResourceHealthChecker.this.cleanInstances();
                }
            }, checkPeriod, checkPeriod, TimeUnit.MILLISECONDS);
            this.futures.add(future);
        }
    }

    private boolean doCheck(Instance instance, FaultDetectorProto.FaultDetectRule.Protocol protocol, FaultDetectorProto.FaultDetectRule faultDetectRule) {
        HealthChecker healthChecker = this.healthCheckers.get(protocol.name().toLowerCase());
        if (null == healthChecker) {
            HC_EVENT_LOG.info("plugin not found, skip health check for instance {}:{}, resource {}, protocol {}", new Object[]{instance.getHost(), instance.getPort(), this.resource, protocol});
            return false;
        }
        DetectResult detectResult = healthChecker.detectInstance(instance, faultDetectRule);
        ResourceStat resourceStat = new ResourceStat(this.resource, detectResult.getStatusCode(), detectResult.getDelay(), detectResult.getRetStatus());
        HC_EVENT_LOG.info("health check for instance {}:{}, resource {}, protocol {}, result: code {}, delay {}ms, status {}", new Object[]{instance.getHost(), instance.getPort(), this.resource, protocol, detectResult.getStatusCode(), detectResult.getDelay(), detectResult.getRetStatus()});
        this.polarisCircuitBreaker.doReport(resourceStat, false);
        return resourceStat.getRetStatus() == RetStatus.RetSuccess;
    }

    public void cleanInstances() {
        long curTimeMilli = System.currentTimeMillis();
        long expireIntervalMilli = this.polarisCircuitBreaker.getHealthCheckInstanceExpireInterval();
        for (Map.Entry<Node, ProtocolInstance> entry : this.instances.entrySet()) {
            ProtocolInstance protocolInstance = entry.getValue();
            long lastReportMilli = protocolInstance.getLastReportMilli();
            Node node = entry.getKey();
            if (protocolInstance.isCheckSuccess() || curTimeMilli - lastReportMilli < expireIntervalMilli) continue;
            this.instances.remove(node);
            HC_EVENT_LOG.info("clean instance from health check tasks, resource {}, expired node {}, lastReportMilli {}", new Object[]{this.resource, node, lastReportMilli});
        }
    }

    public void stop() {
        LOG.info("health checker for resource {} has stopped", (Object)this.resource);
        this.stopped.set(true);
        for (ScheduledFuture<?> future : this.futures) {
            future.cancel(true);
        }
    }

    public FaultDetectorProto.FaultDetector getFaultDetector() {
        return this.faultDetector;
    }

    private static class ProtocolInstance {
        final FaultDetectorProto.FaultDetectRule.Protocol protocol;
        final InstanceResource instanceResource;
        final AtomicLong lastReportMilli = new AtomicLong(0L);
        final AtomicBoolean checkSuccess = new AtomicBoolean(true);

        ProtocolInstance(FaultDetectorProto.FaultDetectRule.Protocol protocol, InstanceResource instanceResource) {
            this.protocol = protocol;
            this.instanceResource = instanceResource;
            this.lastReportMilli.set(System.currentTimeMillis());
        }

        FaultDetectorProto.FaultDetectRule.Protocol getProtocol() {
            return this.protocol;
        }

        InstanceResource getInstanceResource() {
            return this.instanceResource;
        }

        public long getLastReportMilli() {
            return this.lastReportMilli.get();
        }

        void doReport() {
            this.lastReportMilli.set(System.currentTimeMillis());
        }

        boolean isCheckSuccess() {
            return this.checkSuccess.get();
        }
    }
}

